/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.automation.Parameter;
import blue.automation.ParameterListener;
import blue.automation.ParameterTimeManagerFactory;
import blue.orchestra.blueSynthBuilder.AutomatableBSBObject;
import blue.orchestra.blueSynthBuilder.BSBCompilationUnit;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.blueSynthBuilder.Randomizable;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.math.BigDecimal;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;

public class BSBCheckBox
extends AutomatableBSBObject
implements ParameterListener,
Randomizable {
    private StringProperty label;
    private BooleanProperty selected;
    private BooleanProperty randomizable;
    private ChangeListener<Boolean> listener = (obs, old, newVal) -> {
        Parameter p;
        if (this.parameters != null && (p = this.parameters.getParameter(this.getObjectName())) != null && !p.isAutomationEnabled()) {
            p.setValue(newVal != false ? 1.0 : 0.0);
        }
    };

    public BSBCheckBox() {
        this.label = new SimpleStringProperty("label");
        this.selected = new SimpleBooleanProperty(false);
        this.randomizable = new SimpleBooleanProperty(true);
        this.selected.addListener(this.listener);
    }

    public BSBCheckBox(BSBCheckBox checkBox) {
        super(checkBox);
        this.label = new SimpleStringProperty(checkBox.getLabel());
        this.selected = new SimpleBooleanProperty(checkBox.isSelected());
        this.randomizable = new SimpleBooleanProperty(checkBox.isRandomizable());
        this.selected.addListener(this.listener);
    }

    public static BSBObject loadFromXML(Element data) {
        BSBCheckBox checkBox = new BSBCheckBox();
        BSBCheckBox.initBasicFromXML(data, checkBox);
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "label": {
                    checkBox.setLabel(node.getTextString());
                    break;
                }
                case "selected": {
                    checkBox.setSelected(node.getTextString().equals("true"));
                    break;
                }
                case "randomizable": {
                    checkBox.setRandomizable(XMLUtilities.readBoolean(node));
                }
            }
        }
        return checkBox;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = BSBCheckBox.getBasicXML(this);
        retVal.addElement("label").setText(this.getLabel());
        retVal.addElement("selected").setText(Boolean.toString(this.isSelected()));
        retVal.addElement(XMLUtilities.writeBoolean("randomizable", this.isRandomizable()));
        return retVal;
    }

    @Override
    public void setupForCompilation(BSBCompilationUnit compilationUnit) {
        Parameter param;
        if (this.parameters != null && (param = this.parameters.getParameter(this.getObjectName())) != null && param.getCompilationVarName() != null) {
            compilationUnit.addReplacementValue(this.getObjectName(), param.getCompilationVarName());
            return;
        }
        String replaceVal = this.isSelected() ? "1" : "0";
        compilationUnit.addReplacementValue(this.getObjectName(), replaceVal);
    }

    public final void setLabel(String value) {
        this.label.set((Object)value);
    }

    public final String getLabel() {
        return (String)this.label.get();
    }

    public final StringProperty labelProperty() {
        return this.label;
    }

    public final void setSelected(boolean value) {
        this.selected.set(value);
    }

    public final boolean isSelected() {
        return this.selected.get();
    }

    public final BooleanProperty selectedProperty() {
        return this.selected;
    }

    @Override
    public final void setRandomizable(boolean value) {
        this.randomizable.set(value);
    }

    @Override
    public final boolean isRandomizable() {
        return this.randomizable.get();
    }

    public final BooleanProperty randomizableProperty() {
        return this.randomizable;
    }

    @Override
    public String getPresetValue() {
        return Boolean.toString(this.isSelected());
    }

    @Override
    public void setPresetValue(String val) {
        this.setSelected(Boolean.valueOf(val));
    }

    @Override
    public void randomize() {
        if (this.isRandomizable()) {
            boolean randomSelected;
            boolean bl = randomSelected = Math.random() < 0.5;
            if (randomSelected != this.isSelected()) {
                this.setSelected(randomSelected);
                if (this.propListeners != null) {
                    this.propListeners.firePropertyChange("selected", !randomSelected, randomSelected);
                }
            }
        }
    }

    @Override
    protected void initializeParameters() {
        if (this.parameters == null) {
            return;
        }
        if (!this.automationAllowed && this.getObjectName() != null && this.getObjectName().length() != 0) {
            Parameter param = this.parameters.getParameter(this.getObjectName());
            if (param != null && param.isAutomationEnabled()) {
                this.automationAllowed = true;
            } else {
                this.parameters.removeParameter(this.getObjectName());
                return;
            }
        }
        if (this.getObjectName() == null || this.getObjectName().trim().length() == 0) {
            return;
        }
        Parameter parameter = this.parameters.getParameter(this.getObjectName());
        if (parameter != null) {
            parameter.addParameterListener(this);
            if (!parameter.isAutomationEnabled()) {
                parameter.setValue(this.isSelected() ? 1.0 : 0.0);
            }
            return;
        }
        Parameter param = new Parameter();
        param.setValue(this.isSelected() ? 1.0 : 0.0);
        param.setMax(1.0, true);
        param.setMin(0.0, true);
        param.setName(this.getObjectName());
        param.setResolution(new BigDecimal(1));
        param.addParameterListener(this);
        this.parameters.add(param);
    }

    @Override
    public void setAutomationAllowed(boolean allowAutomation) {
        this.automationAllowed = allowAutomation;
        if (this.parameters != null) {
            if (allowAutomation) {
                this.initializeParameters();
            } else if (this.getObjectName() != null && this.getObjectName().length() != 0) {
                this.parameters.removeParameter(this.getObjectName());
            }
        }
    }

    protected void updateSelected(boolean value) {
        boolean oldValue = this.isSelected();
        this.setSelected(value);
        if (this.propListeners != null) {
            this.propListeners.firePropertyChange("selected", (Object)oldValue, this.selected);
        }
    }

    @Override
    public void parameterChanged(Parameter param) {
    }

    @Override
    public void lineDataChanged(Parameter param) {
        Parameter parameter = this.parameters.getParameter(this.getObjectName());
        if (parameter != null) {
            boolean newSelected;
            double time = ParameterTimeManagerFactory.getInstance().getTime();
            long val = Math.round(parameter.getLine().getValue(time));
            boolean bl = newSelected = val > 0L;
            if (newSelected != this.isSelected()) {
                this.updateSelected(newSelected);
            }
        }
    }

    @Override
    public BSBCheckBox deepCopy() {
        return new BSBCheckBox(this);
    }
}

