/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.CompileData;
import blue.noteProcessor.NoteProcessorChain;
import blue.noteProcessor.NoteProcessorException;
import blue.score.ScoreObjectEvent;
import blue.soundObject.AbstractSoundObject;
import blue.soundObject.NoteList;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.soundObject.SoundObjectUtilities;
import blue.utility.ScoreUtilities;
import electric.xml.Element;
import java.util.Map;

public class Instance
extends AbstractSoundObject {
    private SoundObject sObj;
    private NoteProcessorChain npc = new NoteProcessorChain();
    private int timeBehavior;
    double repeatPoint = -1.0;
    int soundObjectLibraryId = -1;

    public Instance(SoundObject sObj) {
        this.sObj = sObj;
        this.setName(sObj.getName());
        this.setBackgroundColor(sObj.getBackgroundColor());
        this.timeBehavior = 0;
    }

    public Instance() {
        this.name = "Instance: ";
    }

    public Instance(Instance instance) {
        super(instance);
        this.sObj = instance.sObj;
        this.npc = new NoteProcessorChain(instance.npc);
        this.backgroundColor = instance.getBackgroundColor();
        this.timeBehavior = instance.getTimeBehavior();
        this.repeatPoint = instance.repeatPoint;
    }

    public void processNotes(NoteList nl) throws SoundObjectException {
        ScoreUtilities.normalizeNoteList(nl);
        try {
            ScoreUtilities.applyNoteProcessorChain(nl, this.npc);
        }
        catch (NoteProcessorException e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
        ScoreUtilities.applyTimeBehavior(nl, this.getTimeBehavior(), this.getSubjectiveDuration(), this.getRepeatPoint());
        ScoreUtilities.setScoreStart(nl, this.startTime);
    }

    @Override
    public double getObjectiveDuration() {
        return this.sObj.getSubjectiveDuration();
    }

    @Override
    public void setNoteProcessorChain(NoteProcessorChain npc) {
        this.npc = npc;
    }

    @Override
    public NoteProcessorChain getNoteProcessorChain() {
        return this.npc;
    }

    @Override
    public int getTimeBehavior() {
        return this.timeBehavior;
    }

    @Override
    public void setTimeBehavior(int timeBehavior) {
        this.timeBehavior = timeBehavior;
    }

    @Override
    public double getRepeatPoint() {
        return this.repeatPoint;
    }

    @Override
    public void setRepeatPoint(double repeatPoint) {
        this.repeatPoint = repeatPoint;
        ScoreObjectEvent event = new ScoreObjectEvent(this, 4);
        this.fireScoreObjectEvent(event);
    }

    public static SoundObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        Instance instance = new Instance();
        SoundObjectUtilities.initBasicFromXML(data, instance);
        String id = data.getElement("soundObjectReference").getAttributeValue("soundObjectLibraryID");
        if ("null".equals(id)) {
            throw new Exception("ERROR: SoundObject Instance found pointing to an library item that no longer exists");
        }
        Object sObj = objRefMap.get(id);
        if (sObj == null) {
            throw new Exception("Could not find SoundObject pointed to from Instance with ID: " + id);
        }
        instance.setSoundObject((SoundObject)sObj);
        return instance;
    }

    @Override
    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = SoundObjectUtilities.getBasicXML(this);
        retVal.addElement("soundObjectReference").setAttribute("soundObjectLibraryID", objRefMap.get(this.getSoundObject()));
        return retVal;
    }

    public SoundObject getSoundObject() {
        return this.sObj;
    }

    public void setSoundObject(SoundObject obj) {
        this.sObj = obj;
    }

    @Override
    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) throws SoundObjectException {
        NoteList nl = this.sObj.generateForCSD(compileData, startTime, endTime);
        this.processNotes(nl);
        return nl;
    }

    @Override
    public Instance deepCopy() {
        return new Instance(this);
    }
}

