/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask;

import blue.soundObject.jmask.Accumulatable;
import blue.soundObject.jmask.Generator;
import blue.soundObject.jmask.Maskable;
import blue.soundObject.jmask.Quantizable;
import blue.soundObject.jmask.probability.Beta;
import blue.soundObject.jmask.probability.Cauchy;
import blue.soundObject.jmask.probability.Exponential;
import blue.soundObject.jmask.probability.Gaussian;
import blue.soundObject.jmask.probability.Linear;
import blue.soundObject.jmask.probability.ProbabilityGenerator;
import blue.soundObject.jmask.probability.Triangle;
import blue.soundObject.jmask.probability.Uniform;
import blue.soundObject.jmask.probability.Weibull;
import blue.utility.ObjectUtilities;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Random;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Probability
implements Generator,
Maskable,
Quantizable,
Accumulatable {
    ProbabilityGenerator[] generators;
    private int selectedIndex = 0;
    private transient double duration = 0.0;

    public Probability() {
        this.generators = new ProbabilityGenerator[]{new Uniform(), new Linear(), new Triangle(), new Exponential(), new Gaussian(), new Cauchy(), new Beta(), new Weibull()};
    }

    public Probability(Probability prob) {
        this.selectedIndex = prob.selectedIndex;
        this.generators = new ProbabilityGenerator[prob.generators.length];
        for (int i = 0; i < this.generators.length; ++i) {
            this.generators[i] = (ProbabilityGenerator)prob.generators[i].deepCopy();
        }
    }

    public static Generator loadFromXML(Element data) throws Exception {
        Probability retVal = new Probability();
        Elements nodes = data.getElements();
        int generatorIndex = 0;
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "selectedIndex": {
                    retVal.setSelectedIndex(Integer.parseInt(node.getTextString()));
                    break;
                }
                case "probabilityGenerator": {
                    retVal.generators[generatorIndex] = (ProbabilityGenerator)ObjectUtilities.loadFromXML(node);
                    ++generatorIndex;
                }
            }
        }
        return retVal;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("generator");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement(XMLUtilities.writeInt("selectedIndex", this.getSelectedIndex()));
        for (ProbabilityGenerator generator : this.generators) {
            retVal.addElement(generator.saveAsXML());
        }
        return retVal;
    }

    @Override
    public void initialize(double duration) {
        this.duration = duration;
    }

    @Override
    public double getValue(double time, Random rnd) {
        return this.generators[this.selectedIndex].getValue(time / this.duration, rnd);
    }

    public ProbabilityGenerator[] getGenerators() {
        return this.generators;
    }

    public static void main(String[] args) {
        Probability prob = new Probability();
        ProbabilityGenerator[] generators2 = prob.getGenerators();
        for (int i = 0; i < generators2.length; ++i) {
            System.out.println("Generator: " + generators2[i].getName());
        }
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
    }

    public ProbabilityGenerator getSelectedProbabilityGenerator() {
        return this.generators[this.selectedIndex];
    }

    @Override
    public Probability deepCopy() {
        return new Probability(this);
    }
}

