/*
 * Decompiled with CFR 0.152.
 */
package blue.upgrades;

import blue.upgrades.ProjectUpgrader;
import blue.utility.TextUtilities;
import electric.xml.Element;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

class ProjectUpgrader_2_1_10
extends ProjectUpgrader {
    public ProjectUpgrader_2_1_10() {
        super("2.1.10");
    }

    @Override
    public boolean performUpgrade(Element data) {
        Element element = data.getElement("globalOrcSco");
        Element projectPropsNode = data.getElement("projectProperties");
        if (element == null || projectPropsNode == null) {
            return false;
        }
        Element globalOrcNode = element.getElement("globalOrc");
        if (element == null) {
            return false;
        }
        String globalOrc = globalOrcNode.getTextString();
        if (globalOrc == null || !globalOrc.contains("0dbfs")) {
            return false;
        }
        StringBuilder buffer = new StringBuilder();
        BufferedReader reader = new BufferedReader(new StringReader(globalOrc));
        try {
            String str;
            while ((str = reader.readLine()) != null) {
                if (str.trim().startsWith("0dbfs") && str.contains("=")) {
                    str = TextUtilities.stripSingleLineComments(str);
                    str = str.substring(str.indexOf(61) + 1).trim();
                    projectPropsNode.addElement("useZeroDbFS").setText("true");
                    projectPropsNode.addElement("zeroDbFS").setText(str);
                    projectPropsNode.addElement("diskUseZeroDbFS").setText("true");
                    projectPropsNode.addElement("diskZeroDbFS").setText(str);
                    continue;
                }
                buffer.append(str).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        globalOrcNode.setText(buffer.toString());
        return true;
    }
}

