/*
 * Decompiled with CFR 0.152.
 */
package blue.upgrades;

import blue.upgrades.ProjectUpgrader;
import blue.upgrades.ProjectUpgrader_2_1_10;
import blue.upgrades.ProjectUpgrader_2_3_0;
import blue.upgrades.ProjectVersion;
import electric.xml.Attribute;
import electric.xml.Element;
import java.util.ArrayList;
import java.util.logging.Logger;

public class UpgradeManager {
    Logger logger = Logger.getLogger("UpgradeManager");
    private ArrayList<ProjectUpgrader> upgraders = new ArrayList();
    private static UpgradeManager instance = null;

    public static UpgradeManager getInstance() {
        if (instance == null) {
            instance = new UpgradeManager();
        }
        return instance;
    }

    private UpgradeManager() {
        this.upgraders.add(new ProjectUpgrader_2_1_10());
        this.upgraders.add(new ProjectUpgrader_2_3_0());
    }

    public void performUpgrades(Element element) {
        Attribute versionAttribute = element.getAttribute("version");
        String versionString = "0.0.0";
        if (versionAttribute != null) {
            versionString = versionAttribute.getValue();
        }
        ProjectVersion version = ProjectVersion.parseVersion(versionString);
        for (ProjectUpgrader upgrader : this.upgraders) {
            if (!version.lessThan(upgrader.getVersion()) || !upgrader.performUpgrade(element)) continue;
            this.logger.info(String.format("Performed Upgrade for Version '%s'", upgrader.getVersion()));
        }
    }
}

