/*
 * Decompiled with CFR 0.152.
 */
package blue.projects;

import blue.utility.GUI;
import com.l2fprod.common.swing.BaseDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class AudioFileDependencyDialog
extends BaseDialog {
    DependencyTableModel model = new DependencyTableModel();
    JFileChooser fChooser = null;

    public AudioFileDependencyDialog() {
        super((Frame)null, "Audio File Dependencies", true);
        this.getBanner().setTitle("Locate Missing Audio Files");
        this.setModal(true);
        this.setDefaultCloseOperation(1);
        final JTable table = new JTable(this.model);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = table.getSelectedRow();
                if (row >= AudioFileDependencyDialog.this.model.getRowCount()) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    if (AudioFileDependencyDialog.this.fChooser == null) {
                        AudioFileDependencyDialog.this.fChooser = new JFileChooser();
                        AudioFileDependencyDialog.this.fChooser.setDialogTitle("Choose Replacement File");
                    }
                    int retVal = AudioFileDependencyDialog.this.fChooser.showOpenDialog(null);
                    File f = AudioFileDependencyDialog.this.fChooser.getSelectedFile();
                    if (retVal == 0) {
                        AudioFileDependencyDialog.this.model.setValueAt(f.getPath(), row, 1);
                    }
                }
            }
        });
        JScrollPane jsp = new JScrollPane(table);
        this.getContentPane().add(jsp);
        this.setSize(400, 500);
        GUI.centerOnScreen((Component)((Object)this));
    }

    public void setFilesList(ArrayList<String> filesList) {
        this.model.setFilesList(filesList);
    }

    public Map<String, String> getFilesMap() {
        return this.model.getFilesMap();
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        AudioFileDependencyDialog aDialog = new AudioFileDependencyDialog();
        ArrayList<String> fList = new ArrayList<String>();
        fList.add("test1");
        fList.add("test2");
        fList.add("test3");
        aDialog.setFilesList(fList);
        boolean value = aDialog.ask();
        System.exit(0);
    }

    static class DependencyTableModel
    extends AbstractTableModel {
        ArrayList<String> filesList = null;
        ArrayList<String> returnList = null;

        DependencyTableModel() {
        }

        public void setFilesList(ArrayList<String> filesList) {
            this.filesList = filesList;
            this.returnList = new ArrayList();
            for (int i = 0; i < filesList.size(); ++i) {
                this.returnList.add("");
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.filesList == null ? 0 : this.filesList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.filesList.get(rowIndex);
            }
            return this.returnList.get(rowIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex != 1) {
                return;
            }
            this.returnList.set(rowIndex, (String)aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Original File";
            }
            return "New File";
        }

        public Map<String, String> getFilesMap() {
            HashMap<String, String> filesMap = new HashMap<String, String>();
            for (int i = 0; i < this.filesList.size(); ++i) {
                String val;
                String key = this.filesList.get(i);
                if (key.equals(val = this.returnList.get(i)) || val == null || val.equals("")) continue;
                filesMap.put(key, val);
            }
            return filesMap;
        }
    }
}

