/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.filemanager;

import blue.ui.filemanager.FileManagerRoots;
import blue.ui.filemanager.FileNode;
import java.io.File;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class FileManagerRootNode
extends AbstractNode {
    private final FileManagerRoots roots;

    public FileManagerRootNode(FileManagerRoots roots) {
        super(Children.create((ChildFactory)new FileManagerRootChildFactory(roots), (boolean)true));
        this.roots = roots;
        this.setDisplayName("Roots");
    }

    static class FileManagerRootChildFactory
    extends ChildFactory<File> {
        private final FileManagerRoots roots;

        private FileManagerRootChildFactory(FileManagerRoots roots) {
            this.roots = roots;
            roots.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    FileManagerRootChildFactory.this.refresh(true);
                }
            });
        }

        protected boolean createKeys(List<File> toPopulate) {
            toPopulate.addAll(this.roots.getRoots());
            return true;
        }

        protected Node createNodeForKey(File key) {
            return new FileNode(key, true, this.roots);
        }
    }
}

