/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.Lex;
import electric.xml.Attribute;
import electric.xml.Child;
import electric.xml.Parent;
import java.io.IOException;
import java.io.Writer;

public final class XMLDecl
extends Child {
    static final String DEFAULT_VERSION = "1.0";
    static final String DEFAULT_ENCODING = "UTF-8";
    static final boolean DEFAULT_STANDALONE = false;
    static final String START = "<?xml ";
    static final String STOP = "?>";
    String content;
    String version = "1.0";
    String encoding = "UTF-8";
    boolean standalone = false;

    public XMLDecl(String string, String string2, boolean bl) {
        this.content = String.valueOf(String.valueOf(new StringBuffer("version='").append(string).append("' encoding='").append(string2).append("' standalone='").append(bl ? "yes" : "no").append("'")));
        this.version = string;
        this.encoding = string2;
        this.standalone = bl;
    }

    public XMLDecl(String string, String string2) {
        this.content = String.valueOf(String.valueOf(new StringBuffer("version='").append(string).append("' encoding='").append(string2).append("'")));
        this.version = string;
        this.encoding = string2;
    }

    public XMLDecl(XMLDecl xMLDecl) {
        this.content = xMLDecl.content;
        this.version = xMLDecl.version;
        this.encoding = xMLDecl.encoding;
        this.standalone = xMLDecl.standalone;
    }

    XMLDecl(Lex lex, Parent parent) throws IOException {
        super(parent);
        lex.skip(START.length());
        this.content = lex.readToPattern(STOP, 3);
        Lex lex2 = new Lex(this.content, "=", 1);
        while (!lex2.eof()) {
            Attribute attribute = new Attribute(lex2, null);
            String string = attribute.getName();
            String string2 = attribute.getValue();
            if (string.equals("version")) {
                this.version = string2;
                continue;
            }
            if (string.equals("encoding")) {
                this.encoding = string2;
                continue;
            }
            if (!string.equals("standalone")) continue;
            this.standalone = string2.equals("yes");
        }
    }

    public Object clone() {
        return new XMLDecl(this);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public boolean getStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean bl) {
        this.standalone = bl;
    }

    public void write(Writer writer, int n) throws IOException {
        this.indent(writer, n);
        writer.write(START);
        writer.write(this.content);
        writer.write(STOP);
    }

    static {
        DEFAULT_VERSION = DEFAULT_VERSION;
        DEFAULT_ENCODING = DEFAULT_ENCODING;
        DEFAULT_STANDALONE = false;
        START = START;
        STOP = STOP;
    }
}

