/*
 * Decompiled with CFR 0.152.
 */
package blue.settings;

import blue.services.render.DiskRenderServiceFactory;
import blue.settings.DiskRenderSettings;
import blue.settings.DiskRenderSettingsOptionsPanelController;
import blue.ui.utilities.FileChooserManager;
import blue.ui.utilities.SimpleDocumentListener;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class DiskRenderSettingsPanel
extends JPanel {
    private final DiskRenderSettingsOptionsPanelController controller;
    private boolean loading = false;
    private JTextField advancedText;
    private JCheckBox benchmarkCBox;
    private JTextField csoundExecText;
    private JCheckBox disableDisplaysCBox;
    private JCheckBox ditherOutputCBox;
    private JCheckBox externalCommandBox;
    private JTextField externalCommandText;
    private JTextField externalOpenCommandText;
    private JCheckBox fileFormatCBox;
    private JComboBox fileFormatCombo;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JTextField ksmpsText;
    private JTextField nchnlsText;
    private JCheckBox noteAmpCBox;
    private JCheckBox outOfRangeCBox;
    private JComboBox renderServiceComboBox;
    private JCheckBox rewriteHeaderCBox;
    private JCheckBox sampleFormatCBox;
    private JComboBox sampleFormatCombo;
    private JCheckBox savePeakCBox;
    private JTextField srText;
    private JCheckBox warningsCBox;
    private JCheckBox zeroDBFSCheckBox;
    private JTextField zeroDBFSText;

    DiskRenderSettingsPanel(DiskRenderSettingsOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        SimpleDocumentListener changeListener = new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (!DiskRenderSettingsPanel.this.loading) {
                    DiskRenderSettingsPanel.this.controller.changed();
                }
            }
        };
        this.csoundExecText.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.srText.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.ksmpsText.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.nchnlsText.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.externalCommandText.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.externalOpenCommandText.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.advancedText.getDocument().addDocumentListener((DocumentListener)changeListener);
        this.zeroDBFSText.getDocument().addDocumentListener((DocumentListener)changeListener);
    }

    private void fireUpdate() {
        if (!this.loading) {
            this.controller.changed();
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.srText = new JTextField();
        this.ksmpsText = new JTextField();
        this.nchnlsText = new JTextField();
        this.zeroDBFSCheckBox = new JCheckBox();
        this.zeroDBFSText = new JTextField();
        this.jPanel3 = new JPanel();
        this.fileFormatCBox = new JCheckBox();
        this.fileFormatCombo = new JComboBox();
        this.sampleFormatCBox = new JCheckBox();
        this.sampleFormatCombo = new JComboBox();
        this.savePeakCBox = new JCheckBox();
        this.ditherOutputCBox = new JCheckBox();
        this.rewriteHeaderCBox = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.advancedText = new JTextField();
        this.jButton2 = new JButton();
        this.jPanel5 = new JPanel();
        this.noteAmpCBox = new JCheckBox();
        this.outOfRangeCBox = new JCheckBox();
        this.warningsCBox = new JCheckBox();
        this.benchmarkCBox = new JCheckBox();
        this.jPanel6 = new JPanel();
        this.jLabel5 = new JLabel();
        this.externalCommandText = new JTextField();
        this.externalCommandBox = new JCheckBox();
        this.jPanel7 = new JPanel();
        this.disableDisplaysCBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.csoundExecText = new JTextField();
        this.jButton1 = new JButton();
        this.jLabel6 = new JLabel();
        this.renderServiceComboBox = new JComboBox();
        this.jPanel8 = new JPanel();
        this.jLabel7 = new JLabel();
        this.externalOpenCommandText = new JTextField();
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.jPanel2.border.title_1")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.jLabel1.text_1"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.jLabel2.text_1"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.jLabel4.text_1"));
        this.srText.setText(NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.srText.text_1"));
        this.ksmpsText.setText(NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.ksmpsText.text_1"));
        this.nchnlsText.setText(NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.nchnlsText.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.zeroDBFSCheckBox, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.zeroDBFSCheckBox.text"));
        this.zeroDBFSCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiskRenderSettingsPanel.this.zeroDBFSCheckBoxActionPerformed(evt);
            }
        });
        this.zeroDBFSText.setText(NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.zeroDBFSText.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel4).addComponent(this.zeroDBFSCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.nchnlsText).addComponent(this.zeroDBFSText, GroupLayout.Alignment.LEADING).addComponent(this.srText).addComponent(this.ksmpsText, GroupLayout.Alignment.LEADING)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.srText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.ksmpsText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.nchnlsText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.zeroDBFSCheckBox).addComponent(this.zeroDBFSText, -2, -1, -2))));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.jPanel3.border.title_1")));
        Mnemonics.setLocalizedText((AbstractButton)this.fileFormatCBox, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.fileFormatCBox.text_1"));
        this.fileFormatCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fileFormatCBox.setMargin(new Insets(0, 0, 0, 0));
        this.fileFormatCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiskRenderSettingsPanel.this.fileFormatCBoxActionPerformed(evt);
            }
        });
        this.fileFormatCombo.setModel(new DefaultComboBoxModel<String>(DiskRenderSettings.FILE_FORMATS));
        this.fileFormatCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiskRenderSettingsPanel.this.fileFormatComboActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.sampleFormatCBox, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.sampleFormatCBox.text_1"));
        this.sampleFormatCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.sampleFormatCBox.setMargin(new Insets(0, 0, 0, 0));
        this.sampleFormatCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiskRenderSettingsPanel.this.sampleFormatCBoxActionPerformed(evt);
            }
        });
        this.sampleFormatCombo.setModel(new DefaultComboBoxModel<String>(DiskRenderSettings.SAMPLE_FORMATS));
        this.sampleFormatCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiskRenderSettingsPanel.this.sampleFormatComboActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.savePeakCBox, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.savePeakCBox.text_1"));
        this.savePeakCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.savePeakCBox.setMargin(new Insets(0, 0, 0, 0));
        this.savePeakCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiskRenderSettingsPanel.this.savePeakCBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.ditherOutputCBox, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.ditherOutputCBox.text_1"));
        this.ditherOutputCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ditherOutputCBox.setMargin(new Insets(0, 0, 0, 0));
        this.ditherOutputCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiskRenderSettingsPanel.this.ditherOutputCBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.rewriteHeaderCBox, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.rewriteHeaderCBox.text_1"));
        this.rewriteHeaderCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rewriteHeaderCBox.setMargin(new Insets(0, 0, 0, 0));
        this.rewriteHeaderCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiskRenderSettingsPanel.this.rewriteHeaderCBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileFormatCBox).addComponent(this.sampleFormatCBox, -2, 94, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileFormatCombo, -2, -1, -2).addComponent(this.sampleFormatCombo, -2, 82, -2))).addComponent(this.savePeakCBox).addComponent(this.ditherOutputCBox).addComponent(this.rewriteHeaderCBox)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileFormatCombo, -2, -1, -2).addComponent(this.fileFormatCBox, -2, 19, -2)).addGap(8, 8, 8).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sampleFormatCombo, -2, -1, -2).addComponent(this.sampleFormatCBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.savePeakCBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ditherOutputCBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rewriteHeaderCBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.jPanel4.border.title_1")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.jButton2.text_1"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiskRenderSettingsPanel.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.advancedText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.advancedText, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.jPanel5.border.title_1")));
        Mnemonics.setLocalizedText((AbstractButton)this.noteAmpCBox, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.noteAmpCBox.text_1"));
        this.noteAmpCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noteAmpCBox.setMargin(new Insets(0, 0, 0, 0));
        this.noteAmpCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiskRenderSettingsPanel.this.noteAmpCBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.outOfRangeCBox, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.outOfRangeCBox.text_1"));
        this.outOfRangeCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.outOfRangeCBox.setMargin(new Insets(0, 0, 0, 0));
        this.outOfRangeCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiskRenderSettingsPanel.this.outOfRangeCBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.warningsCBox, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.warningsCBox.text_1"));
        this.warningsCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.warningsCBox.setMargin(new Insets(0, 0, 0, 0));
        this.warningsCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiskRenderSettingsPanel.this.warningsCBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.benchmarkCBox, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.benchmarkCBox.text_1"));
        this.benchmarkCBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.benchmarkCBox.setMargin(new Insets(0, 0, 0, 0));
        this.benchmarkCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiskRenderSettingsPanel.this.benchmarkCBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outOfRangeCBox).addComponent(this.noteAmpCBox).addComponent(this.warningsCBox).addComponent(this.benchmarkCBox)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.noteAmpCBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outOfRangeCBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.warningsCBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.benchmarkCBox).addContainerGap(22, Short.MAX_VALUE)));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.jPanel6.border.title_1")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.jLabel5.text_1"));
        this.externalCommandText.setText(NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.externalCommandText.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.externalCommandBox, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.externalCommandBox.text_1"));
        this.externalCommandBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.externalCommandBox.setMargin(new Insets(0, 0, 0, 0));
        this.externalCommandBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiskRenderSettingsPanel.this.externalCommandBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.externalCommandText)).addComponent(this.externalCommandBox)).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.externalCommandBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.externalCommandText, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel7.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.jPanel7.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.disableDisplaysCBox, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.disableDisplaysCBox.text"));
        this.disableDisplaysCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiskRenderSettingsPanel.this.disableDisplaysCBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.disableDisplaysCBox).addContainerGap(361, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.disableDisplaysCBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.jPanel1.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.jLabel3.text_1"));
        this.csoundExecText.setText(NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.csoundExecText.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.jButton1.text_1"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiskRenderSettingsPanel.this.jButton1ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.jLabel6.text"));
        this.renderServiceComboBox.setModel(new DefaultComboBoxModel<DiskRenderServiceFactory>(DiskRenderSettings.getAvailableDiskRenderServices()));
        this.renderServiceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiskRenderSettingsPanel.this.renderServiceComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.csoundExecText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addComponent(this.renderServiceComboBox, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jButton1).addComponent(this.csoundExecText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.renderServiceComboBox, -2, -1, -2)).addContainerGap(20, Short.MAX_VALUE)));
        this.jPanel8.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.jPanel8.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.jLabel7.text"));
        this.externalOpenCommandText.setText(NbBundle.getMessage(DiskRenderSettingsPanel.class, (String)"DiskRenderSettingsPanel.externalOpenCommandText.text"));
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.externalOpenCommandText, -1, 380, Short.MAX_VALUE).addContainerGap()));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.externalOpenCommandText, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel7, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel8, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel8, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        List retVal = FileChooserManager.getDefault().showOpenDialog(this.getClass(), (Component)this);
        if (!retVal.isEmpty()) {
            File f = (File)retVal.get(0);
            try {
                String path = f.getCanonicalPath();
                if (f.exists() && f.isFile()) {
                    this.csoundExecText.setText(path);
                    this.fireUpdate();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void fileFormatCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void fileFormatComboActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void sampleFormatCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void sampleFormatComboActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void savePeakCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void ditherOutputCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void rewriteHeaderCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        File manualDir = InstalledFileLocator.getDefault().locate("csoundManual", "csound-manual", false);
        File index = new File(manualDir, "CommandFlags.html");
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(index.toURL());
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void noteAmpCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void outOfRangeCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void warningsCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void benchmarkCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void externalCommandBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void disableDisplaysCBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void zeroDBFSCheckBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    private void renderServiceComboBoxActionPerformed(ActionEvent evt) {
        this.fireUpdate();
    }

    void load() {
        this.loading = true;
        DiskRenderSettings settings = DiskRenderSettings.getInstance();
        this.csoundExecText.setText(settings.csoundExecutable);
        this.srText.setText(settings.defaultSr);
        this.ksmpsText.setText(settings.defaultKsmps);
        this.nchnlsText.setText(settings.defaultNchnls);
        this.externalCommandBox.setSelected(settings.externalPlayCommandEnabled);
        this.externalCommandText.setText(settings.externalPlayCommand);
        this.externalOpenCommandText.setText(settings.externalOpenCommand);
        this.fileFormatCBox.setSelected(settings.fileFormatEnabled);
        this.fileFormatCombo.setSelectedItem(settings.fileFormat);
        this.sampleFormatCBox.setSelected(settings.sampleFormatEnabled);
        this.sampleFormatCombo.setSelectedItem(settings.sampleFormat);
        this.savePeakCBox.setSelected(settings.savePeakInformation);
        this.ditherOutputCBox.setSelected(settings.ditherOutput);
        this.rewriteHeaderCBox.setSelected(settings.rewriteHeader);
        this.noteAmpCBox.setSelected(settings.noteAmpsEnabled);
        this.outOfRangeCBox.setSelected(settings.outOfRangeEnabled);
        this.warningsCBox.setSelected(settings.warningsEnabled);
        this.benchmarkCBox.setSelected(settings.benchmarkEnabled);
        this.disableDisplaysCBox.setSelected(settings.displaysDisabled);
        this.advancedText.setText(settings.advancedSettings);
        this.zeroDBFSCheckBox.setSelected(settings.useZeroDbFS);
        this.zeroDBFSText.setText(settings.zeroDbFS);
        this.renderServiceComboBox.setSelectedItem(settings.renderServiceFactory);
        this.loading = false;
    }

    void store() {
        DiskRenderSettings settings = DiskRenderSettings.getInstance();
        settings.csoundExecutable = this.csoundExecText.getText();
        settings.defaultSr = this.srText.getText();
        settings.defaultKsmps = this.ksmpsText.getText();
        settings.defaultNchnls = this.nchnlsText.getText();
        settings.externalPlayCommandEnabled = this.externalCommandBox.isSelected();
        settings.externalPlayCommand = this.externalCommandText.getText();
        settings.externalOpenCommand = this.externalOpenCommandText.getText();
        settings.fileFormatEnabled = this.fileFormatCBox.isSelected();
        settings.fileFormat = this.fileFormatCombo.getSelectedItem().toString();
        settings.sampleFormatEnabled = this.sampleFormatCBox.isSelected();
        settings.sampleFormat = this.sampleFormatCombo.getSelectedItem().toString();
        settings.savePeakInformation = this.savePeakCBox.isSelected();
        settings.ditherOutput = this.ditherOutputCBox.isSelected();
        settings.rewriteHeader = this.rewriteHeaderCBox.isSelected();
        settings.noteAmpsEnabled = this.noteAmpCBox.isSelected();
        settings.warningsEnabled = this.warningsCBox.isSelected();
        settings.outOfRangeEnabled = this.outOfRangeCBox.isSelected();
        settings.benchmarkEnabled = this.benchmarkCBox.isSelected();
        settings.displaysDisabled = this.disableDisplaysCBox.isSelected();
        settings.advancedSettings = this.advancedText.getText();
        settings.useZeroDbFS = this.zeroDBFSCheckBox.isSelected();
        settings.zeroDbFS = this.zeroDBFSText.getText();
        settings.renderServiceFactory = (DiskRenderServiceFactory)this.renderServiceComboBox.getSelectedItem();
        settings.save();
    }

    boolean valid() {
        return true;
    }
}

