/*
 * Decompiled with CFR 0.152.
 */
package blue.plaf;

import blue.plaf.BlueBorderUtilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class BlueToggleButtonBorder
extends AbstractBorder
implements UIResource {
    protected static final Insets insets = new Insets(2, 2, 2, 2);

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        JToggleButton button = (JToggleButton)c;
        ButtonModel model = button.getModel();
        if (model.isEnabled()) {
            if (model.isPressed() && model.isArmed()) {
                BlueBorderUtilities.drawPressed3DBorder(g, x, y, w, h);
            } else if (button.isRolloverEnabled()) {
                if (model.isRollover()) {
                    BlueBorderUtilities.drawSimple3DBorder(g, x, y, w, h);
                }
            } else {
                BlueBorderUtilities.drawSimple3DBorder(g, x, y, w, h);
            }
            if (button.isSelected()) {
                BlueBorderUtilities.drawPressed3DBorder(g, x, y, w, h);
            }
        } else if (!button.isRolloverEnabled()) {
            BlueBorderUtilities.drawDisabledBorder(g, x, y, w - 1, h - 1);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return insets;
    }
}

