/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.editor.csound.sco;

import blue.ui.editor.csound.sco.CsoundScoTokenId;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class CsoundScoHLexer
implements Lexer<CsoundScoTokenId> {
    private static final Map<String, CsoundScoTokenId> keywords = new HashMap<String, CsoundScoTokenId>();
    private static final int EOF = -1;
    private LexerRestartInfo<CsoundScoTokenId> info;
    private LexerInput input;
    TokenFactory<CsoundScoTokenId> tokenFactory;

    private static final void addKeyword(CsoundScoTokenId id) {
        keywords.put(id.getFixedText(), id);
    }

    public CsoundScoHLexer(LexerRestartInfo<CsoundScoTokenId> info) {
        this.info = info;
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
    }

    public Token<CsoundScoTokenId> nextToken() {
        int ch = this.input.read();
        switch (ch) {
            case 34: {
                while (true) {
                    switch (this.input.read()) {
                        case 92: {
                            this.input.read();
                            break;
                        }
                        case 34: {
                            return this.token(CsoundScoTokenId.STRING);
                        }
                        case -1: 
                        case 10: {
                            return this.token(CsoundScoTokenId.ERROR);
                        }
                    }
                }
            }
            case 37: 
            case 42: 
            case 43: 
            case 45: {
                return this.token(CsoundScoTokenId.OPERATOR);
            }
            case 47: {
                switch (this.input.read()) {
                    case 47: {
                        while (true) {
                            switch (this.input.read()) {
                                case 13: {
                                    this.input.consumeNewline();
                                }
                                case -1: 
                                case 10: {
                                    return this.token(CsoundScoTokenId.SL_COMMENT);
                                }
                            }
                        }
                    }
                    case 42: {
                        do {
                            ch = this.input.read();
                            while (ch == 42) {
                                ch = this.input.read();
                                if (ch == 47) {
                                    return this.token(CsoundScoTokenId.ML_COMMENT);
                                }
                                if (ch != -1) continue;
                                return this.token(CsoundScoTokenId.ML_COMMENT_INCOMPLETE);
                            }
                        } while (ch != -1);
                        return this.token(CsoundScoTokenId.ML_COMMENT_INCOMPLETE);
                    }
                }
                this.input.backup(1);
                return this.token(CsoundScoTokenId.OPERATOR);
            }
            case 59: {
                while (true) {
                    switch (this.input.read()) {
                        case 13: {
                            this.input.consumeNewline();
                        }
                        case -1: 
                        case 10: {
                            return this.token(CsoundScoTokenId.SL_COMMENT);
                        }
                    }
                }
            }
            case 40: {
                return this.token(CsoundScoTokenId.LPAREN);
            }
            case 41: {
                return this.token(CsoundScoTokenId.RPAREN);
            }
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.finishIntOrFloatLiteral(ch);
            }
            case -1: {
                return null;
            }
        }
        if (Character.isWhitespace((char)ch)) {
            ch = this.input.read();
            while (ch != -1 && Character.isWhitespace((char)ch)) {
                ch = this.input.read();
            }
            this.input.backup(1);
            return this.token(CsoundScoTokenId.WS);
        }
        if (Character.isLetter((char)ch)) {
            while (true) {
                if (ch == -1 || !Character.isLetter((char)ch)) {
                    this.input.backup(1);
                    CharSequence word = this.input.readText();
                    CsoundScoTokenId id = keywords.get(word);
                    if (id == null) {
                        id = word.equals("i") || word.equals("f") || word.equals("e") || word.equals("t") ? CsoundScoTokenId.KEYWORD : CsoundScoTokenId.CHAR;
                    }
                    return this.token(id);
                }
                ch = this.input.read();
            }
        }
        return this.token(CsoundScoTokenId.CHAR);
    }

    public Object state() {
        return null;
    }

    public void release() {
    }

    private Token<CsoundScoTokenId> finishIntOrFloatLiteral(int ch) {
        boolean floatLiteral = false;
        boolean inExponent = false;
        while (true) {
            switch (ch) {
                case 46: {
                    if (floatLiteral) {
                        return this.token(CsoundScoTokenId.MYFLOAT);
                    }
                    floatLiteral = true;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    break;
                }
                case 69: 
                case 101: {
                    if (inExponent) {
                        return this.token(CsoundScoTokenId.MYFLOAT);
                    }
                    floatLiteral = true;
                    inExponent = true;
                    break;
                }
                default: {
                    this.input.backup(1);
                    return this.token(floatLiteral ? CsoundScoTokenId.MYFLOAT : CsoundScoTokenId.INT);
                }
            }
            ch = this.input.read();
        }
    }

    private Token<CsoundScoTokenId> token(CsoundScoTokenId id) {
        return id.getFixedText() != null ? this.tokenFactory.getFlyweightToken((TokenId)id, id.getFixedText()) : this.tokenFactory.createToken((TokenId)id);
    }
}

