/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import tcl.lang.EncodingCmd;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclInputStream;
import tcl.lang.TclObject;
import tcl.lang.TclOutputStream;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

abstract class Channel {
    protected int mode;
    private String chanName;
    protected int refCount = 0;
    protected TclInputStream input = null;
    protected TclOutputStream output = null;
    protected boolean blocking = true;
    protected int buffering = 0;
    protected int bufferSize = 4096;
    protected String encoding;
    protected int bytesPerChar;
    protected int inputTranslation = 0;
    protected int outputTranslation = TclIO.TRANS_PLATFORM;
    protected char inputEofChar = '\u0000';
    protected char outputEofChar = '\u0000';

    Channel() {
        this.setEncoding(EncodingCmd.systemJavaEncoding);
    }

    int read(Interp interp, TclObject tobj, int readType, int numBytes) throws IOException, TclException {
        this.checkRead(interp);
        this.initInput();
        switch (readType) {
            case 1: {
                return this.input.doReadChars(tobj, -1);
            }
            case 2: {
                return this.input.getsObj(tobj);
            }
            case 3: {
                return this.input.doReadChars(tobj, numBytes);
            }
        }
        throw new TclRuntimeError("Channel.read: Invalid read mode.");
    }

    void write(Interp interp, TclObject outData) throws IOException, TclException {
        this.checkWrite(interp);
        this.initOutput();
        if (this.output != null) {
            this.output.writeObj(outData);
        }
    }

    void write(Interp interp, String outStr) throws IOException, TclException {
        this.write(interp, TclString.newInstance((String)outStr));
    }

    void close() throws IOException {
        IOException ex = null;
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException e) {
                ex = e;
            }
            this.input = null;
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException e) {
                ex = e;
            }
            this.output = null;
        }
        if (ex != null) {
            throw ex;
        }
    }

    void flush(Interp interp) throws IOException, TclException {
        this.checkWrite(interp);
        if (this.output != null) {
            this.output.flush();
        }
    }

    void seek(Interp interp, long offset, int mode) throws IOException, TclException {
        throw new TclPosixException(interp, 22, true, "error during seek on \"" + this.getChanName() + "\"");
    }

    long tell() throws IOException {
        return -1L;
    }

    protected void initInput() throws IOException {
        if (this.input != null) {
            return;
        }
        this.input = new TclInputStream(this.getInputStream());
        this.input.setEncoding(this.encoding);
        this.input.setTranslation(this.inputTranslation);
        this.input.setEofChar(this.inputEofChar);
        this.input.setBuffering(this.buffering);
        this.input.setBufferSize(this.bufferSize);
        this.input.setBlocking(this.blocking);
    }

    protected void initOutput() throws IOException {
        if (this.output != null) {
            return;
        }
        this.output = new TclOutputStream(this.getOutputStream());
        this.output.setEncoding(this.encoding);
        this.output.setTranslation(this.outputTranslation);
        this.output.setEofChar(this.outputEofChar);
        this.output.setBuffering(this.buffering);
        this.output.setBufferSize(this.bufferSize);
        this.output.setBlocking(this.blocking);
    }

    final boolean eof() {
        if (this.input != null) {
            return this.input.eof();
        }
        return false;
    }

    protected abstract InputStream getInputStream() throws IOException;

    protected abstract OutputStream getOutputStream() throws IOException;

    String getChanName() {
        return this.chanName;
    }

    abstract String getChanType();

    int getRefCount() {
        return this.refCount;
    }

    void setChanName(String chan) {
        this.chanName = chan;
    }

    boolean isReadOnly() {
        return (this.mode & 1) != 0;
    }

    boolean isWriteOnly() {
        return (this.mode & 2) != 0;
    }

    boolean isReadWrite() {
        return (this.mode & 4) != 0;
    }

    protected void checkRead(Interp interp) throws TclException {
        if (!this.isReadOnly() && !this.isReadWrite()) {
            throw new TclException(interp, "channel \"" + this.getChanName() + "\" wasn't opened for reading");
        }
    }

    protected void checkWrite(Interp interp) throws TclException {
        if (!this.isWriteOnly() && !this.isReadWrite()) {
            throw new TclException(interp, "channel \"" + this.getChanName() + "\" wasn't opened for writing");
        }
    }

    boolean getBlocking() {
        return this.blocking;
    }

    void setBlocking(boolean inBlocking) {
        this.blocking = inBlocking;
        if (this.input != null) {
            this.input.setBlocking(this.blocking);
        }
        if (this.output != null) {
            this.output.setBlocking(this.blocking);
        }
    }

    int getBuffering() {
        return this.buffering;
    }

    void setBuffering(int inBuffering) {
        if (inBuffering < 0 || inBuffering > 2) {
            throw new TclRuntimeError("invalid buffering mode in Channel.setBuffering()");
        }
        this.buffering = inBuffering;
        if (this.input != null) {
            this.input.setBuffering(this.buffering);
        }
        if (this.output != null) {
            this.output.setBuffering(this.buffering);
        }
    }

    int getBufferSize() {
        return this.bufferSize;
    }

    void setBufferSize(int size) {
        if (size < 10 || size > 0x100000) {
            return;
        }
        this.bufferSize = size;
        if (this.input != null) {
            this.input.setBufferSize(this.bufferSize);
        }
        if (this.output != null) {
            this.output.setBufferSize(this.bufferSize);
        }
    }

    int getNumBufferedInputBytes() {
        if (this.input != null) {
            return this.input.getNumBufferedBytes();
        }
        return 0;
    }

    int getNumBufferedOutputBytes() {
        if (this.output != null) {
            return this.output.getNumBufferedBytes();
        }
        return 0;
    }

    boolean isBlocked(Interp interp) throws TclException {
        this.checkRead(interp);
        if (this.input != null) {
            return this.input.isBlocked();
        }
        return false;
    }

    boolean isBgFlushScheduled() {
        return false;
    }

    boolean inputSawCR() {
        if (this.input != null) {
            return this.input.sawCR();
        }
        return false;
    }

    String getEncoding() {
        return this.encoding;
    }

    void setEncoding(String inEncoding) {
        this.encoding = inEncoding;
        this.bytesPerChar = this.encoding == null ? 1 : EncodingCmd.getBytesPerChar(this.encoding);
        if (this.input != null) {
            this.input.setEncoding(this.encoding);
        }
        if (this.output != null) {
            this.output.setEncoding(this.encoding);
        }
    }

    int getInputTranslation() {
        return this.inputTranslation;
    }

    void setInputTranslation(int translation) {
        this.inputTranslation = translation;
        if (this.input != null) {
            this.input.setTranslation(this.inputTranslation);
        }
    }

    int getOutputTranslation() {
        return this.outputTranslation;
    }

    void setOutputTranslation(int translation) {
        this.outputTranslation = translation;
        if (this.output != null) {
            this.output.setTranslation(this.outputTranslation);
        }
    }

    char getInputEofChar() {
        return this.inputEofChar;
    }

    void setInputEofChar(char inEof) {
        this.inputEofChar = (char)(inEof & 0xFF);
        if (this.input != null) {
            this.input.setEofChar(this.inputEofChar);
        }
    }

    char getOutputEofChar() {
        return this.outputEofChar;
    }

    void setOutputEofChar(char outEof) {
        this.outputEofChar = (char)(outEof & 0xFF);
        if (this.output != null) {
            this.output.setEofChar(this.outputEofChar);
        }
    }
}

