;
; "Herald of Water, Herald of Air"
; by Dave Seidel
;
; Copyright 2009 Dave Seidel, some rights reserved.  This work is licensed under a
; Creative Commons Attribution License (see http://creativecommons.org/licenses/by/3.0/).
; 
; For more information, go to http://mysterybear.net/article/34
; 
; Copy the following text, starting with <CsOptions> and ending with </CsOptions>, into the code
; below,  between <CsoundSynthesizer> and <CsInstruments>.  There are two versions of the
; piece (Herald of Air and Herald of Water), and there is an option line for each version (in two
; different resolutions), so just uncomment the one you one (but only line at at time).  To
; uncomment a line, remove all semicolons (;) at the beginning of the line.
; 
; <CsOptions>
; 
; ;; "Herald of Water", 96K/24-bit
; ;--sample-rate=96000 --control-rate=96000 --format=wav:24bit --omacro:ARTICULATION=0 -o "Herald-of-Water_(96-24).wav"
; ;; "Herald of Water", 44.1K/16-bit
; ;--sample-rate=44100 --control-rate=44100 --format=wav:short --omacro:ARTICULATION=0 -o -o "Herald-of-Water_(44-16).wav"
; 
; ;; "Herald of Air", 96K/24-bit
; ;--sample-rate=96000 --control-rate=96000 --format=wav:24bit --omacro:ARTICULATION=1 -o "Herald-of-Air_(96-24).wav"
; ;; "Herald of Air", 44.1K/16-bit
; ;--sample-rate=44100 --control-rate=44100 --format=wav:short --omacro:ARTICULATION=1 -o -o "Herald-of-Air_(44-16).wav"
; 
; </CsOptions>
; 
;
; Generated by blue 0.125.0 (http://csounds.com/stevenyi/blue/index.html)
;

<CsoundSynthesizer>

<CsInstruments>
sr=96000
ksmps=1
nchnls=2


ga_bluemix_1_0	init	0
ga_bluemix_1_1	init	0
ga_bluesub_Master_0	init	0
ga_bluesub_Master_1	init	0


gk_blue_auto0 init 0.9999989867
gk_blue_auto1 init 7.12196064
gk_blue_auto2 init 960
gk_blue_auto3 init 0.0972608998
gk_blue_auto4 init 0.9999998808
gk_blue_auto5 init 0.2375034392
gk_blue_auto6 init 0
gk_blue_auto7 init 8000
gk_blue_auto8 init 0.8500000238
gk_blue_auto9 init 0.6499999762
gk_blue_auto10 init 0


;git_sqr	ftgen	0, 0, 8192,	7,	1, 4096, 1, 0, -1, 4096, -1


	opcode blueEffect0,aa,aa

ain1,ain2	xin
aout1, aout2  reverbsc ain1, ain2, gk_blue_auto8, gk_blue_auto7

aout1 = (ain1 * gk_blue_auto9) + (aout1 * (1 - gk_blue_auto9))
aout2 = (ain2 * gk_blue_auto9) + (aout2 * (1 - gk_blue_auto9))


xout	aout1,aout2


	endop


	instr 1	;another ResonantRhythm mod
idur		=	p3
kamp		=	ampdb(p4)/10
ifreq		=	(p5 >= 20) ? p5 : cpspch(p5)
ibps		=	p6
itail		=	p7
idetune		=	p8
; optional
iart		=	p9
kbright		=	p10
kres		=	p11
khpfreq		=	p11
; defaults
#ifdef ARTICULATION
iart		=	$ARTICULATION
#end
kbright		=	(kbright == 0) ? i(gk_blue_auto1) : kbright
kres		=	(kres == 0)    ? i(gk_blue_auto5)  : kres
khpfreq		=	(khpfreq == 0) ? i(gk_blue_auto2) : khpfreq
; amplitude envelope
aampenv linsegr	0, i(gk_blue_auto0), 1, i(gk_blue_auto4), 0
; rhythmic envelope
kbps	linseg	0, idur-itail, ibps, itail, 0
; random sequence
if (iart == 0) kgoto Smooth
if (iart == 1) kgoto Sharp
Smooth:
	printks	"Using interpolated random sequence\\n", 1440
krnd	randi	0.4, kbps, 2, 1, .01
	kgoto UseSeq
Sharp:
	printks	"Using non-interpolated random sequence\\n", 1440
krnd	randh	0.4, kbps, 2, 1, .01
	kgoto UseSeq
UseSeq:
kfreq	=	(krnd + .5) * kbright
; pitch offsets
ioff1	=	idetune
ioff2	=	idetune*2
ioff3	=	idetune*3
ioff4	=	idetune*4
; oscillators (like Risset harm. arp.)
aosc1	vco2	kamp+krnd, ifreq,       2, gk_blue_auto3
aosc2	vco2	kamp+krnd, ifreq+ioff1, 2, gk_blue_auto3
aosc3	vco2	kamp+krnd, ifreq+ioff2, 2, gk_blue_auto3
aosc4	vco2	kamp+krnd, ifreq+ioff3, 2, gk_blue_auto3
aosc5	vco2	kamp+krnd, ifreq+ioff4, 2, gk_blue_auto3
aosc6	vco2	kamp+krnd, ifreq-ioff1, 2, gk_blue_auto3
aosc7	vco2	kamp+krnd, ifreq-ioff2, 2, gk_blue_auto3
aosc8	vco2	kamp+krnd, ifreq-ioff3, 2, gk_blue_auto3
aosc9	vco2	kamp+krnd, ifreq-ioff4, 2, gk_blue_auto3
; mix
aoutl	=	(aosc1 + aosc3 + aosc5 + aosc7 + aosc9) * aampenv
aoutr	=	(aosc1 + aosc2 + aosc4 + aosc6 + aosc8) * aampenv
; filter
aoutl	moogvcf2	aoutl, kfreq * ifreq, kres
aoutr	moogvcf2	aoutr, kfreq * ifreq, kres
aoutl	atone		aoutl, khpfreq
aoutr	atone		aoutr, khpfreq
; output
ga_bluemix_1_0 = ga_bluemix_1_0 +  aoutl
ga_bluemix_1_1 = ga_bluemix_1_1 +  aoutr

	endin

	instr 2	;Blue Mixer Instrument
ktempdb = ampdb(gk_blue_auto6)
ga_bluemix_1_0 = ga_bluemix_1_0 * ktempdb
ga_bluemix_1_1 = ga_bluemix_1_1 * ktempdb
ga_bluesub_Master_0	sum	ga_bluesub_Master_0, ga_bluemix_1_0
ga_bluesub_Master_1	sum	ga_bluesub_Master_1, ga_bluemix_1_1
ga_bluesub_Master_0, ga_bluesub_Master_1	blueEffect0	ga_bluesub_Master_0, ga_bluesub_Master_1
ktempdb = ampdb(gk_blue_auto10)
ga_bluesub_Master_0 = ga_bluesub_Master_0 * ktempdb
ga_bluesub_Master_1 = ga_bluesub_Master_1 * ktempdb
outc ga_bluesub_Master_0, ga_bluesub_Master_1
ga_bluemix_1_0 = 0
ga_bluemix_1_1 = 0
ga_bluesub_Master_0 = 0
ga_bluesub_Master_1 = 0

	endin

	instr 3	;Param: attack
if (p4 == p5) then
gk_blue_auto0 init p4
turnoff
else
gk_blue_auto0 line p4, p3, p5
endif
	endin

	instr 4	;Param: brightness
if (p4 == p5) then
gk_blue_auto1 init p4
turnoff
else
gk_blue_auto1 line p4, p3, p5
endif
	endin

	instr 5	;Param: hipassfreq
if (p4 == p5) then
gk_blue_auto2 init p4
turnoff
else
gk_blue_auto2 line p4, p3, p5
endif
	endin

	instr 6	;Param: pulsewidth
if (p4 == p5) then
gk_blue_auto3 init p4
turnoff
else
gk_blue_auto3 line p4, p3, p5
endif
	endin

	instr 7	;Param: release
if (p4 == p5) then
gk_blue_auto4 init p4
turnoff
else
gk_blue_auto4 line p4, p3, p5
endif
	endin

	instr 8	;Param: resonance
if (p4 == p5) then
gk_blue_auto5 init p4
turnoff
else
gk_blue_auto5 line p4, p3, p5
endif
	endin

	instr 9	;Param: Volume
if (p4 == p5) then
gk_blue_auto6 init p4
turnoff
else
gk_blue_auto6 line p4, p3, p5
endif
	endin

	instr 10	;Param: cutoff
if (p4 == p5) then
gk_blue_auto7 init p4
turnoff
else
gk_blue_auto7 line p4, p3, p5
endif
	endin

	instr 11	;Param: feedback
if (p4 == p5) then
gk_blue_auto8 init p4
turnoff
else
gk_blue_auto8 line p4, p3, p5
endif
	endin

	instr 12	;Param: wetdry
if (p4 == p5) then
gk_blue_auto9 init p4
turnoff
else
gk_blue_auto9 line p4, p3, p5
endif
	endin

	instr 13	;Param: Volume
if (p4 == p5) then
gk_blue_auto10 init p4
turnoff
else
gk_blue_auto10 line p4, p3, p5
endif
	endin


</CsInstruments>

<CsScore>







i1	0.0	960	89.700000	120.000000	4.000000	300.000000	0.003662109375	1
i1	0.0	960	89.700000	120.000000	4.000000	300.000000	0.001831054688	1
i1	60.0	900	89.700000	180.000000	6.000000	300.000000	0.003662109375	1
i1	60.0	900	89.700000	180.000000	6.000000	300.000000	0.001831054688	1
i1	120.0	840	89.700000	210.000000	7.000000	300.000000	0.003662109375	1
i1	120.0	840	89.700000	210.000000	7.000000	300.000000	0.001831054688	1
i1	180.0	780	89.700000	240.000000	8.000000	300.000000	0.003662109375	1
i1	180.0	780	89.700000	240.000000	8.000000	300.000000	0.001831054688	1
i1	240.0	720	89.700000	270.000000	9.000000	300.000000	0.003662109375	1
i1	240.0	720	89.700000	270.000000	9.000000	300.000000	0.001831054688	1
i1	300.0	660	89.700000	303.750000	10.125000	300.000000	0.003662109375	1
i1	300.0	660	89.700000	303.750000	10.125000	300.000000	0.001831054688	1
i1	360.0	600	89.700000	315.000000	10.500000	300.000000	0.003662109375	1
i1	360.0	600	89.700000	315.000000	10.500000	300.000000	0.001831054688	1
i1	420.0	540	89.700000	405.000000	13.500000	300.000000	0.003662109375	1
i1	420.0	540	89.700000	405.000000	13.500000	300.000000	0.001831054688	1
i1	480.0	480	89.700000	607.500000	20.250000	300.000000	0.003662109375	1
i1	480.0	480	89.700000	607.500000	20.250000	300.000000	0.001831054688	1
i1	540.0	420	89.700000	720.000000	24.000000	300.000000	0.003662109375	1
i1	540.0	420	89.700000	720.000000	24.000000	300.000000	0.001831054688	1
i1	600.0	360	89.700000	810.000000	27.000000	300.000000	0.003662109375	1
i1	600.0	360	89.700000	810.000000	27.000000	300.000000	0.001831054688	1
i2	0	963	
e

</CsScore>

</CsoundSynthesizer>