/*
 * Decompiled with CFR 0.152.
 */
package org.wonderly.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import org.wonderly.awt.PackAs;

public class Packer
extends GridBagLayout
implements PackAs {
    protected GridBagConstraints gc = null;
    protected Component comp;
    protected Container container;

    public Packer() {
    }

    public Packer(Container cont) {
        cont.setLayout(this);
        this.container = cont;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public PackAs setContainer(Container cont) throws IllegalAccessException {
        if (this.container != null) {
            try {
                Packer p = (Packer)this.clone();
                this.container.setLayout(p);
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalAccessException();
            }
        }
        this.container = cont;
        cont.setLayout(this);
        return this;
    }

    public Container getContainer() {
        return this.container;
    }

    @Override
    public PackAs into(Container cont) throws IllegalAccessException {
        this.setContainer(cont);
        return this;
    }

    @Override
    public PackAs pack(Component cp) {
        if (this.container != null) {
            this.container.add(cp);
        }
        this.comp = cp;
        this.gc = new GridBagConstraints();
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    @Override
    public PackAs add(Component cp) {
        if (this.container != null) {
            this.container.add(cp);
        }
        this.comp = cp;
        if (this.gc == null) {
            this.gc = new GridBagConstraints();
        }
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setAnchorNorth(boolean how) {
        this.gc.anchor = how ? 11 : (this.gc.anchor &= 0xFFFFFFF4);
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public boolean getAnchorNorth() {
        return this.gc.anchor == 11;
    }

    @Override
    public PackAs north() {
        this.gc.anchor = 11;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setAnchorSouth(boolean how) {
        this.gc.anchor = how ? 15 : (this.gc.anchor &= 0xFFFFFFF0);
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public boolean getAnchorSouth() {
        return this.gc.anchor == 15;
    }

    @Override
    public PackAs south() {
        this.gc.anchor = 15;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setAnchorEast(boolean how) {
        this.gc.anchor = how ? 13 : (this.gc.anchor &= 0xFFFFFFF2);
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public boolean getAnchorEast() {
        return this.gc.anchor == 13;
    }

    @Override
    public PackAs east() {
        this.gc.anchor = 13;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setAnchorWest(boolean how) {
        this.gc.anchor = how ? 17 : (this.gc.anchor &= 0xFFFFFFEE);
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public boolean getAnchorWest() {
        return this.gc.anchor == 17;
    }

    @Override
    public PackAs west() {
        this.gc.anchor = 17;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setAnchorNorthWest(boolean how) {
        this.gc.anchor = how ? 18 : (this.gc.anchor &= 0xFFFFFFED);
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public boolean getAnchorNorthWest() {
        return this.gc.anchor == 18;
    }

    @Override
    public PackAs northwest() {
        this.gc.anchor = 18;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setAnchorSouthWest(boolean how) {
        this.gc.anchor = how ? 16 : (this.gc.anchor &= 0xFFFFFFEF);
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public boolean getAnchorSouthWest() {
        return this.gc.anchor == 16;
    }

    @Override
    public PackAs southwest() {
        this.gc.anchor = 16;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setAnchorNorthEast(boolean how) {
        this.gc.anchor = how ? 12 : (this.gc.anchor &= 0xFFFFFFF3);
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public boolean getAnchorNorthEast() {
        return this.gc.anchor == 12;
    }

    @Override
    public PackAs northeast() {
        this.gc.anchor = 12;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setAnchorSouthEast(boolean how) {
        this.gc.anchor = how ? 14 : (this.gc.anchor &= 0xFFFFFFF1);
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public boolean getAnchorSouthEast() {
        return this.gc.anchor == 14;
    }

    @Override
    public PackAs southeast() {
        this.gc.anchor = 14;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setXLeftRelative(boolean how) {
        this.gc.gridx = how ? -1 : 0;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public boolean getXLeftRelative() {
        return this.gc.gridx == -1;
    }

    @Override
    public PackAs left() {
        this.gc.gridx = -1;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setYTopRelative(boolean how) {
        this.gc.gridy = how ? -1 : 0;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public boolean getYTopRelative() {
        return this.gc.gridy == -1;
    }

    @Override
    public PackAs top() {
        this.gc.gridy = -1;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setXRightRelative(boolean how) {
        this.gc.gridwidth = how ? -1 : 1;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public boolean getXRightRelative() {
        return this.gc.gridwidth == -1;
    }

    @Override
    public PackAs right() {
        this.gc.gridwidth = -1;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setYBottomRelative(boolean how) {
        this.gc.gridheight = how ? -1 : 1;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public boolean getYBottomRelative() {
        return this.gc.gridheight == -1;
    }

    @Override
    public PackAs bottom() {
        this.gc.gridheight = -1;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    @Override
    public PackAs gridx(int tot) {
        this.gc.gridx = tot;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public int getGridX() {
        return this.gc.gridx;
    }

    @Override
    public PackAs gridy(int tot) {
        this.gc.gridy = tot;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public int getGridY() {
        return this.gc.gridy;
    }

    @Override
    public PackAs gridw(int tot) {
        this.gc.gridwidth = tot;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public int getGridW() {
        return this.gc.gridwidth;
    }

    @Override
    public PackAs gridh(int tot) {
        this.gc.gridheight = tot;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public int getGridH() {
        return this.gc.gridheight;
    }

    @Override
    public PackAs padx(int cnt) {
        this.gc.ipadx = cnt;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public int getPadX() {
        return this.gc.ipadx;
    }

    @Override
    public PackAs pady(int cnt) {
        this.gc.ipady = cnt;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public int getPadY() {
        return this.gc.ipady;
    }

    public PackAs setFillX(boolean how) {
        if (how) {
            this.gc.fill = 2;
            this.gc.weightx = 1.0;
        } else {
            this.gc.weightx = 0.0;
            this.gc.fill = 0;
        }
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public boolean getFillX() {
        return this.gc.fill == 2;
    }

    @Override
    public PackAs fillx() {
        this.gc.fill = 2;
        this.gc.weightx = 1.0;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setFillY(boolean how) {
        if (how) {
            this.gc.fill = 3;
            this.gc.weighty = 1.0;
        } else {
            this.gc.weighty = 0.0;
            this.gc.fill = 0;
        }
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public boolean getFillY() {
        return this.gc.fill == 3;
    }

    @Override
    public PackAs filly() {
        this.gc.fill = 3;
        this.gc.weighty = 1.0;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setFillBoth(boolean how) {
        if (how) {
            this.gc.fill = 1;
            this.gc.weightx = 1.0;
            this.gc.weighty = 1.0;
        } else {
            this.gc.weightx = 0.0;
            this.gc.weighty = 0.0;
            this.gc.fill = 0;
        }
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public boolean getFillBoth() {
        return this.gc.fill == 1;
    }

    @Override
    public PackAs fillboth() {
        this.gc.fill = 1;
        this.gc.weightx = 1.0;
        this.gc.weighty = 1.0;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    @Override
    public PackAs inset(Insets insets) {
        this.gc.insets = insets;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setInsetTop(int val) {
        Insets i = this.gc.insets;
        if (i == null) {
            i = new Insets(0, 0, 0, 0);
        }
        this.gc.insets = new Insets(val, i.left, i.bottom, i.right);
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public int getInsetTop() {
        return this.gc.insets.top;
    }

    public int getInsetBottom() {
        return this.gc.insets.bottom;
    }

    public int getInsetLeft() {
        return this.gc.insets.left;
    }

    public int getInsetRight() {
        return this.gc.insets.right;
    }

    public PackAs setInsetBottom(int val) {
        Insets i = this.gc.insets;
        if (i == null) {
            i = new Insets(0, 0, 0, 0);
        }
        this.gc.insets = new Insets(i.top, i.left, val, i.right);
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setInsetLeft(int val) {
        Insets i = this.gc.insets;
        if (i == null) {
            i = new Insets(0, 0, 0, 0);
        }
        this.gc.insets = new Insets(i.top, val, i.bottom, i.right);
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setInsetRight(int val) {
        Insets i = this.gc.insets;
        if (i == null) {
            i = new Insets(0, 0, 0, 0);
        }
        this.gc.insets = new Insets(i.top, i.left, i.bottom, val);
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    @Override
    public PackAs inset(int top, int left, int bottom, int right) {
        this.gc.insets = new Insets(top, left, bottom, right);
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    @Override
    public PackAs weightx(double wt) {
        this.gc.weightx = wt;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public double getWeightX() {
        return this.gc.weightx;
    }

    public double getWeightY() {
        return this.gc.weighty;
    }

    @Override
    public PackAs weighty(double wt) {
        this.gc.weighty = wt;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setRemainX(boolean how) {
        this.gc.gridwidth = how ? 0 : 1;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public boolean getRemainX() {
        return this.gc.gridwidth == 0;
    }

    @Override
    public PackAs remainx() {
        this.gc.gridwidth = 0;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public PackAs setRemainY(boolean how) {
        this.gc.gridheight = how ? 0 : 1;
        this.setConstraints(this.comp, this.gc);
        return this;
    }

    public boolean getRemainY() {
        return this.gc.gridheight == 0;
    }

    @Override
    public PackAs remainy() {
        this.gc.gridheight = 0;
        this.setConstraints(this.comp, this.gc);
        return this;
    }
}

