/*
 * Decompiled with CFR 0.152.
 */
package blue.components.lines;

import blue.BlueSystem;
import blue.components.lines.Line;
import blue.components.lines.LineBoundaryDialog;
import blue.components.lines.LineColors;
import blue.components.lines.LineList;
import blue.components.lines.LinePoint;
import java.awt.Color;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class LineListTableModel
extends AbstractTableModel {
    protected LineList lines = null;

    public void setLineList(LineList lines) {
        this.lines = lines;
        this.fireTableDataChanged();
    }

    public void removeLine(int index) {
        if (this.lines == null) {
            return;
        }
        if (index >= 0 && index < this.lines.size()) {
            this.lines.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public void addLine(int index) {
        if (this.lines == null) {
            return;
        }
        Line line = new Line();
        int lineNum = this.createUniqueLineNumber();
        line.setVarName("line" + lineNum);
        line.setColor(LineColors.getColor(this.lines.size()));
        if (index < 0 || index == this.lines.size() - 1) {
            this.lines.add((Object)line);
            int row = this.lines.size() - 1;
            this.fireTableRowsInserted(row, row);
        } else {
            this.lines.add(index, (Object)line);
            this.fireTableRowsInserted(index, index);
        }
    }

    private int createUniqueLineNumber() {
        int lineNum = -1;
        for (int i = 0; i < this.lines.size(); ++i) {
            String lineName = "line" + i;
            boolean found = true;
            for (int j = 0; j < this.lines.size() && found; ++j) {
                Line l = (Line)this.lines.get(j);
                if (l.isZak() || !l.getVarName().equals(lineName)) continue;
                found = false;
            }
            if (!found) continue;
            lineNum = i;
            break;
        }
        if (lineNum == -1) {
            lineNum = this.lines.size();
        }
        return lineNum;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        if (this.lines == null) {
            return 0;
        }
        return this.lines.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.lines == null) {
            return null;
        }
        Line line = (Line)this.lines.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return line.getColor();
            }
            case 1: {
                return line.getVarName();
            }
            case 2: {
                return new Double(line.getMin());
            }
            case 3: {
                return new Double(line.getMax());
            }
            case 4: {
                return line.isEndPointsLinked();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return true;
    }

    public Class<? extends Object> getColumnClass(int c) {
        switch (c) {
            case 0: {
                return Color.class;
            }
            case 1: {
                return String.class;
            }
            case 2: 
            case 3: {
                return Double.class;
            }
            case 4: {
                return Boolean.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Line line = (Line)this.lines.get(row);
        switch (col) {
            case 0: {
                line.setColor((Color)value);
                break;
            }
            case 1: {
                if (!this.isLineNameAvailable((String)value)) break;
                line.setVarName((String)value);
                break;
            }
            case 2: {
                double dval = Double.parseDouble(value.toString());
                if (dval >= line.getMax()) {
                    JOptionPane.showMessageDialog(null, "Error: Min value can not be set greater or equals to Max value.", "Error", 0);
                    return;
                }
                String retVal = LineBoundaryDialog.getLinePointMethod();
                if (retVal == null) {
                    return;
                }
                line.setMin(dval, retVal.equals("Truncate"));
                break;
            }
            case 3: {
                double dval = Double.parseDouble(value.toString());
                if (dval <= line.getMin()) {
                    JOptionPane.showMessageDialog(null, "Error: Max value can not be set less than or equal to Min value.", "Error", 0);
                    return;
                }
                String retVal = LineBoundaryDialog.getLinePointMethod();
                if (retVal == null) {
                    return;
                }
                line.setMax(dval, retVal.equals("Truncate"));
                break;
            }
            case 4: {
                boolean linked = (Boolean)value;
                line.setEndPointsLinked(linked);
                if (!linked) break;
                LinePoint first = line.getLinePoint(0);
                LinePoint last = line.getLinePoint(line.getRowCount() - 1);
                last.setLocation(last.getX(), first.getY());
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    private boolean isLineNameAvailable(String string) {
        for (Line line : this.lines) {
            if (!line.getVarName().equals(string)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getColumnName(int column) {
        String retVal;
        switch (column) {
            case 0: {
                retVal = "[x]";
                break;
            }
            case 1: {
                retVal = BlueSystem.getString((String)"lineObject.lineName");
                break;
            }
            case 2: {
                retVal = BlueSystem.getString((String)"common.min");
                break;
            }
            case 3: {
                retVal = BlueSystem.getString((String)"common.max");
                break;
            }
            case 4: {
                retVal = "Link First/Last";
                break;
            }
            default: {
                retVal = "";
            }
        }
        return retVal;
    }
}

