/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder;

import blue.orchestra.blueSynthBuilder.BSBGraphicInterface;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.editor.blueSynthBuilder.BSBCompletionItem;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.apache.commons.lang3.StringUtils;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.Exceptions;

public class BSBCompletionProvider
implements CompletionProvider {
    BSBGraphicInterface bsbInterface = null;

    public void setBSBGraphicInterface(BSBGraphicInterface bsbInterface) {
        this.bsbInterface = bsbInterface;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType != 1 || this.bsbInterface == null) {
            return null;
        }
        return new AsyncCompletionTask(new AsyncCompletionQuery(){

            protected void query(CompletionResultSet completionResultSet, Document document, int caretOffset) {
                int index;
                String filter = null;
                int startOffset = caretOffset - 1;
                try {
                    StyledDocument bDoc = (StyledDocument)document;
                    int lineStartOffset = BSBCompletionProvider.getRowFirstNonWhite(bDoc, caretOffset);
                    char[] line = bDoc.getText(lineStartOffset, caretOffset - lineStartOffset).toCharArray();
                    int whiteOffset = BSBCompletionProvider.indexOfWhite(line);
                    filter = new String(line, whiteOffset + 1, line.length - whiteOffset - 1);
                    startOffset = whiteOffset > 0 ? lineStartOffset + whiteOffset + 1 : lineStartOffset;
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (filter != null && !filter.equals("") && (index = filter.indexOf("<")) >= 0) {
                    filter = filter.substring(index + 1);
                    for (BSBObject bsbObj : BSBCompletionProvider.this.bsbInterface.getAllSet()) {
                        String[] keys = bsbObj.getReplacementKeys();
                        if (keys == null) continue;
                        for (String key : keys) {
                            if (StringUtils.containsWhitespace((CharSequence)key) || !filter.isEmpty() && !key.startsWith(filter)) continue;
                            completionResultSet.addItem((CompletionItem)new BSBCompletionItem(bsbObj, key));
                        }
                    }
                }
                completionResultSet.finish();
            }
        }, component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    static int getRowFirstNonWhite(StyledDocument doc, int offset) throws BadLocationException {
        Element lineElement = doc.getParagraphElement(offset);
        int start = lineElement.getStartOffset();
        while (start + 1 < lineElement.getEndOffset()) {
            try {
                if (doc.getText(start, 1).charAt(0) != ' ') {
                    break;
                }
            }
            catch (BadLocationException ex) {
                throw (BadLocationException)new BadLocationException("calling getText(" + start + ", " + (start + 1) + ") on doc of length: " + doc.getLength(), start).initCause(ex);
            }
            ++start;
        }
        return start;
    }

    static int indexOfWhite(char[] line) {
        int i = line.length;
        while (--i > -1) {
            char c = line[i];
            if (!Character.isWhitespace(c)) continue;
            return i;
        }
        return -1;
    }
}

