/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder;

import blue.BlueSystem;
import blue.WindowSettingManager;
import blue.WindowSettingsSavable;
import blue.orchestra.blueSynthBuilder.Preset;
import blue.orchestra.blueSynthBuilder.PresetGroup;
import blue.orchestra.editor.blueSynthBuilder.PresetsBuffer;
import blue.orchestra.editor.blueSynthBuilder.PresetsTreeDragSource;
import blue.orchestra.editor.blueSynthBuilder.PresetsTreeDropTarget;
import blue.orchestra.editor.blueSynthBuilder.PresetsTreeModel;
import blue.settings.GeneralSettings;
import blue.ui.utilities.FileChooserManager;
import blue.ui.utilities.UiUtilities;
import blue.utility.GUI;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.ParseException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javafx.stage.FileChooser;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class PresetsManagerDialog
extends JDialog
implements WindowSettingsSavable {
    private final PresetsTreePopup popup = new PresetsTreePopup();
    JTree tree = new JTree();
    PresetsTreeModel model;
    PresetGroup retVal = null;
    PresetsBuffer buffer = PresetsBuffer.getInstance();

    public PresetsManagerDialog(Frame owner) {
        super(owner);
        this.setModal(true);
        this.setTitle("Presets Manager");
        JPanel mainPanel = (JPanel)this.getContentPane();
        mainPanel.setLayout(new BorderLayout());
        JScrollPane jsp = new JScrollPane(this.tree);
        jsp.setPreferredSize(new Dimension(300, 500));
        JPanel bottomPanel = new JPanel();
        JButton saveButton = new JButton(BlueSystem.getString((String)"common.save"));
        saveButton.addActionListener(e -> {
            this.retVal = (PresetGroup)this.model.getRoot();
            this.setVisible(false);
        });
        JButton cancelButton = new JButton(BlueSystem.getString((String)"programOptions.cancelButton"));
        cancelButton.addActionListener(e -> this.setVisible(false));
        bottomPanel.add(saveButton);
        bottomPanel.add(cancelButton);
        mainPanel.add((Component)jsp, "Center");
        mainPanel.add((Component)bottomPanel, "South");
        this.pack();
        GUI.centerOnScreen((Component)this);
        this.tree.setEditable(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        new PresetsTreeDragSource(this.tree, 2);
        new PresetsTreeDropTarget(this.tree);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path = PresetsManagerDialog.this.tree.getSelectionPath();
                if (path == null) {
                    return;
                }
                Object userObject = path.getLastPathComponent();
                if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                    PresetsManagerDialog.this.showPopup(userObject, e.getX(), e.getY());
                }
            }
        });
        WindowSettingManager.getInstance().registerWindow("PresetsManagerDialog", this);
    }

    private void showPopup(Object userObj, int x, int y) {
        this.popup.show(this, userObj, x, y);
    }

    private void setPresetGroup(PresetGroup presetGroup) {
        if (this.tree.isEditing()) {
            this.tree.cancelEditing();
        }
        this.model = new PresetsTreeModel(presetGroup);
        this.tree.setModel(this.model);
    }

    public PresetGroup editPresetGroup(PresetGroup presetGroup) {
        PresetGroup groupCopy = new PresetGroup(presetGroup);
        this.setPresetGroup(groupCopy);
        this.setVisible(true);
        PresetGroup returnValue = this.retVal;
        this.retVal = null;
        return returnValue;
    }

    public static void main(String[] args) {
        new PresetsManagerDialog(null).setVisible(true);
        System.exit(0);
    }

    @Override
    public void loadWindowSettings(Element settings) {
        WindowSettingManager.setBasicSettings(settings, this);
    }

    @Override
    public Element saveWindowSettings() {
        return WindowSettingManager.getBasicSettings(this);
    }

    class PresetsTreePopup
    extends JPopupMenu {
        private static final String IMPORT_DIALOG = "preset.import";
        private static final String EXPORT_DIALOG = "preset.export";
        JMenuItem addFolder = new JMenuItem("Add Folder");
        JMenuItem remove = new JMenuItem(BlueSystem.getString((String)"common.remove"));
        JMenuItem cut = new JMenuItem(BlueSystem.getString((String)"common.cut"));
        JMenuItem copy = new JMenuItem(BlueSystem.getString((String)"common.copy"));
        JMenuItem paste = new JMenuItem(BlueSystem.getString((String)"common.paste"));
        JMenuItem importItem = new JMenuItem(BlueSystem.getString((String)"common.import"));
        JMenuItem export = new JMenuItem(BlueSystem.getString((String)"common.export"));
        private Object userObj;

        public PresetsTreePopup() {
            this.add(this.remove);
            this.addSeparator();
            this.add(this.cut);
            this.add(this.copy);
            this.add(this.paste);
            this.addSeparator();
            this.add(this.importItem);
            this.add(this.export);
            this.addSeparator();
            this.add(this.addFolder);
            this.remove.addActionListener(e -> {
                if (this.userObj == null) {
                    return;
                }
                if (this.userObj instanceof Preset) {
                    PresetsManagerDialog.this.model.removePreset((Preset)this.userObj);
                } else if (this.userObj instanceof PresetGroup) {
                    PresetsManagerDialog.this.model.removePresetGroup((PresetGroup)this.userObj);
                }
            });
            this.cut.addActionListener(e -> {
                if (this.userObj == null) {
                    return;
                }
                if (this.userObj instanceof Preset) {
                    PresetsManagerDialog.this.buffer.setBufferedItem(new Preset((Preset)this.userObj));
                    PresetsManagerDialog.this.model.removePreset((Preset)this.userObj);
                } else {
                    PresetsManagerDialog.this.buffer.setBufferedItem(new PresetGroup((PresetGroup)this.userObj));
                    PresetsManagerDialog.this.model.removePresetGroup((PresetGroup)this.userObj);
                }
            });
            this.copy.addActionListener(e -> {
                if (this.userObj == null) {
                    return;
                }
                if (this.userObj instanceof Preset) {
                    PresetsManagerDialog.this.buffer.setBufferedItem(new Preset((Preset)this.userObj));
                } else {
                    PresetsManagerDialog.this.buffer.setBufferedItem(new PresetGroup((PresetGroup)this.userObj));
                }
            });
            this.paste.addActionListener(e -> {
                if (this.userObj == null || !(this.userObj instanceof PresetGroup)) {
                    return;
                }
                PresetGroup group = (PresetGroup)this.userObj;
                Object item = PresetsManagerDialog.this.buffer.getBufferedItem();
                if (item instanceof Preset) {
                    PresetsManagerDialog.this.model.addPreset(group, new Preset((Preset)item));
                } else {
                    PresetsManagerDialog.this.model.addPresetGroup(group, new PresetGroup((PresetGroup)item));
                }
            });
            this.importItem.addActionListener(e -> {
                if (this.userObj == null || !(this.userObj instanceof PresetGroup)) {
                    return;
                }
                List retVal1 = FileChooserManager.getDefault().showOpenDialog((Object)IMPORT_DIALOG, (Component)PresetsManagerDialog.this);
                if (!retVal1.isEmpty()) {
                    PresetGroup group = (PresetGroup)this.userObj;
                    File f = (File)retVal1.get(0);
                    try {
                        Document doc = new Document(f);
                        Element root = doc.getRoot();
                        switch (root.getName()) {
                            case "presetGroup": {
                                PresetGroup pGroup = PresetGroup.loadFromXML((Element)root);
                                PresetsManagerDialog.this.model.addPresetGroup(group, pGroup);
                                break;
                            }
                            case "preset": {
                                Preset p = Preset.loadFromXML((Element)root);
                                PresetsManagerDialog.this.model.addPreset(group, p);
                                break;
                            }
                            default: {
                                JOptionPane.showMessageDialog(PresetsManagerDialog.this, "Error: File did not contain presets", "Error", 0);
                                break;
                            }
                        }
                    }
                    catch (ParseException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(PresetsManagerDialog.this, "Error: Could not read presets from file", "Error", 0);
                    }
                }
            });
            this.export.addActionListener(e -> {
                if (this.userObj == null) {
                    return;
                }
                File retVal1 = FileChooserManager.getDefault().showSaveDialog((Object)EXPORT_DIALOG, (Component)PresetsManagerDialog.this);
                if (retVal1 != null) {
                    Element node;
                    int overWrite;
                    File f = retVal1;
                    if (f.exists() && (overWrite = JOptionPane.showConfirmDialog(PresetsManagerDialog.this, "Please confirm you would like to overwrite this file.")) != 0) {
                        return;
                    }
                    if (this.userObj instanceof PresetGroup) {
                        node = ((PresetGroup)this.userObj).saveAsXML();
                    } else if (this.userObj instanceof Preset) {
                        node = ((Preset)this.userObj).saveAsXML();
                    } else {
                        return;
                    }
                    try {
                        PrintWriter out = new PrintWriter(new FileWriter(f));
                        out.print(node.toString());
                        out.flush();
                        out.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.addFolder.addActionListener(e -> {
                if (this.userObj == null || !(this.userObj instanceof PresetGroup)) {
                    return;
                }
                PresetGroup pGroup = (PresetGroup)this.userObj;
                PresetGroup newGroup = new PresetGroup();
                newGroup.setPresetGroupName("New Folder");
                PresetsManagerDialog.this.model.addPresetGroup(pGroup, newGroup);
            });
            File defaultFile = new File(GeneralSettings.getInstance().getDefaultDirectory() + File.separator + "default.preset");
            FileChooser.ExtensionFilter presetFilter = new FileChooser.ExtensionFilter("Preset file", new String[]{"*.preset"});
            FileChooserManager.getDefault().addFilter((Object)IMPORT_DIALOG, presetFilter);
            FileChooserManager.getDefault().setDialogTitle((Object)IMPORT_DIALOG, "Import Presets");
            FileChooserManager.getDefault().setSelectedFile((Object)IMPORT_DIALOG, defaultFile);
            FileChooserManager.getDefault().addFilter((Object)EXPORT_DIALOG, presetFilter);
            FileChooserManager.getDefault().setDialogTitle((Object)EXPORT_DIALOG, "Export Presets");
            FileChooserManager.getDefault().setSelectedFile((Object)EXPORT_DIALOG, defaultFile);
        }

        public void show(PresetsManagerDialog dialog, Object userObj, int x, int y) {
            if (userObj == null) {
                return;
            }
            this.userObj = userObj;
            this.paste.setEnabled(userObj instanceof PresetGroup && PresetsManagerDialog.this.buffer.hasItem());
            this.importItem.setEnabled(userObj instanceof PresetGroup);
            this.addFolder.setEnabled(userObj instanceof PresetGroup);
            this.remove.setEnabled(userObj != PresetsManagerDialog.this.model.getRoot());
            this.cut.setEnabled(userObj != PresetsManagerDialog.this.model.getRoot());
            super.show(dialog, x, y);
        }
    }
}

