/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx;

import blue.orchestra.blueSynthBuilder.BSBGroup;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.blueSynthBuilder.GridSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.scene.Node;
import javafx.scene.layout.Pane;

public class BSBEditSelection {
    public final ObservableSet<BSBObject> selection;
    private final Map<BSBObject, Point> startPositions;
    private double minX = 0.0;
    private double minY = 0.0;
    private int gridOffsetX = 0;
    private int gridOffsetY = 0;
    private ObservableSet<BSBObject> copyBuffer = FXCollections.observableSet((Object[])new BSBObject[0]);
    private boolean processingMove = false;
    GridSettings gridSettings = null;
    private final ObservableList<Node> nodeList;
    private ObservableList<BSBGroup> groupList;

    public BSBEditSelection(ObservableList<Node> children) {
        this.selection = FXCollections.observableSet((Object[])new BSBObject[0]);
        this.startPositions = new HashMap<BSBObject, Point>();
        this.nodeList = children;
    }

    public ObservableSet<BSBObject> copyBufferProperty() {
        return this.copyBuffer;
    }

    public void initialize(ObservableList<BSBGroup> groupList, GridSettings gridSettings) {
        this.groupList = groupList;
        this.gridSettings = gridSettings;
        this.selection.clear();
    }

    public void initiateMove(BSBObject sourceDragObject) {
        this.startPositions.clear();
        this.minX = Double.MAX_VALUE;
        this.minY = Double.MAX_VALUE;
        for (BSBObject bsbObj : this.selection) {
            double x = bsbObj.getX();
            double y = bsbObj.getY();
            this.startPositions.put(bsbObj, new Point(x, y));
            this.minX = Math.min(this.minX, x);
            this.minY = Math.min(this.minY, y);
        }
        if (this.gridSettings != null && this.gridSettings.isSnapEnabled()) {
            this.gridOffsetX = sourceDragObject.getX() % this.gridSettings.getWidth();
            this.gridOffsetY = sourceDragObject.getY() % this.gridSettings.getHeight();
        } else {
            this.gridOffsetY = 0;
            this.gridOffsetX = 0;
        }
        this.processingMove = true;
    }

    public void move(double xDiff, double yDiff) {
        if (!this.processingMove) {
            return;
        }
        if (this.gridSettings != null && this.gridSettings.isSnapEnabled()) {
            int w = this.gridSettings.getWidth();
            int h = this.gridSettings.getHeight();
            xDiff = Math.round(xDiff / (double)w) * (long)w - (long)this.gridOffsetX;
            yDiff = Math.round(yDiff / (double)h) * (long)h - (long)this.gridOffsetY;
        }
        double xDiffAdj = Math.max(-this.minX, xDiff);
        double yDiffAdj = Math.max(-this.minY, yDiff);
        for (Map.Entry<BSBObject, Point> entry : this.startPositions.entrySet()) {
            BSBObject obj = entry.getKey();
            Point pt = entry.getValue();
            obj.setX((int)Math.round(pt.x + xDiffAdj));
            obj.setY((int)Math.round(pt.y + yDiffAdj));
        }
    }

    public void endMove() {
        this.startPositions.clear();
        this.minX = 0.0;
        this.minY = 0.0;
        this.processingMove = false;
    }

    void cut() {
        if (this.groupList != null) {
            this.copy();
            this.remove();
        }
    }

    void copy() {
        if (this.groupList != null) {
            this.copyBuffer.clear();
            this.copyBuffer.addAll((Collection)this.selection.stream().map(b -> (BSBObject)b.deepCopy()).collect(Collectors.toList()));
        }
    }

    void remove() {
        if (this.groupList != null) {
            ((BSBGroup)this.groupList.get(this.groupList.size() - 1)).interfaceItemsProperty().removeAll(this.selection);
            this.selection.clear();
        }
    }

    void nudgeHorizontal(int val) {
        if (this.selection.size() == 0 || this.selection.stream().mapToInt(BSBObject::getX).summaryStatistics().getMin() + val <= 0) {
            return;
        }
        for (BSBObject obj : this.selection) {
            obj.setX(obj.getX() + val);
        }
    }

    void nudgeVertical(int val) {
        if (this.selection.size() == 0 || this.selection.stream().mapToInt(BSBObject::getY).summaryStatistics().getMin() + val <= 0) {
            return;
        }
        for (BSBObject obj : this.selection) {
            obj.setY(obj.getY() + val);
        }
    }

    public List<Pane> getSelectedNodes() {
        ArrayList<Pane> retVal = new ArrayList<Pane>();
        for (Node n : this.nodeList) {
            Pane p = (Pane)n;
            if (!this.selection.contains(p.getUserData())) continue;
            retVal.add(p);
        }
        return retVal;
    }

    public GridSettings getGridSettings() {
        return this.gridSettings;
    }

    private class Point {
        public final double x;
        public final double y;

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

