/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx;

import blue.orchestra.blueSynthBuilder.BSBHSlider;
import blue.orchestra.blueSynthBuilder.BSBHSliderBank;
import blue.orchestra.editor.blueSynthBuilder.jfx.BSBHSliderView;
import blue.orchestra.editor.blueSynthBuilder.jfx.ResizeableView;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.scene.layout.VBox;

public class BSBHSliderBankView
extends VBox
implements ResizeableView {
    BSBHSliderBank bsbHSliderBank;

    public BSBHSliderBankView(BSBHSliderBank sliderBank) {
        this.bsbHSliderBank = sliderBank;
        this.setUserData(sliderBank);
        List views = sliderBank.getSliders().stream().map(e -> new BSBHSliderView((BSBHSlider)e)).collect(Collectors.toList());
        this.getChildren().addAll(views);
        ListChangeListener lcl = c -> {
            while (c.next()) {
                if (c.wasPermutated() || c.wasUpdated()) continue;
                List removedItems = c.getRemoved();
                this.getChildren().removeIf(a -> removedItems.contains((BSBHSlider)a.getUserData()));
                this.getChildren().addAll((Collection)c.getAddedSubList().stream().map(a -> new BSBHSliderView((BSBHSlider)a)).collect(Collectors.toList()));
            }
        };
        this.sceneProperty().addListener((obs, old, newVal) -> {
            if (newVal == null) {
                this.spacingProperty().unbind();
                sliderBank.getSliders().removeListener(lcl);
            } else {
                this.spacingProperty().bind((ObservableValue)sliderBank.gapProperty());
                sliderBank.getSliders().addListener(lcl);
            }
        });
    }

    @Override
    public boolean canResizeWidgetWidth() {
        return true;
    }

    @Override
    public boolean canResizeWidgetHeight() {
        return false;
    }

    @Override
    public int getWidgetMinimumWidth() {
        int base = this.bsbHSliderBank.isValueDisplayEnabled() ? 50 : 0;
        return 45 + base;
    }

    @Override
    public int getWidgetMinimumHeight() {
        return -1;
    }

    @Override
    public int getWidgetWidth() {
        int base = this.bsbHSliderBank.isValueDisplayEnabled() ? 50 : 0;
        return base + this.bsbHSliderBank.getSliderWidth();
    }

    @Override
    public void setWidgetWidth(int width) {
        int base = this.bsbHSliderBank.isValueDisplayEnabled() ? 50 : 0;
        this.bsbHSliderBank.setSliderWidth(Math.max(45, width - base));
    }

    @Override
    public int getWidgetHeight() {
        return -1;
    }

    @Override
    public void setWidgetHeight(int height) {
    }

    @Override
    public void setWidgetX(int x) {
        this.bsbHSliderBank.setX(x);
    }

    @Override
    public int getWidgetX() {
        return this.bsbHSliderBank.getX();
    }

    @Override
    public void setWidgetY(int y) {
    }

    @Override
    public int getWidgetY() {
        return -1;
    }
}

