/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor;

import blue.BlueSystem;
import blue.gui.LabelledItemPanel;
import blue.score.ScoreObject;
import blue.soundObject.AudioFile;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import blue.ui.utilities.FileChooserManager;
import blue.ui.utilities.SimpleDocumentListener;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoManager;
import org.openide.awt.UndoRedo;

public class AudioFileEditor
extends ScoreObjectEditor {
    JTextField audioFileName = new JTextField();
    JButton findAudioFile = new JButton();
    MimeTypeEditorComponent csoundCode = new MimeTypeEditorComponent("text/x-csound-orc");
    AudioFile af = null;
    JLabel durationText = new JLabel();
    JLabel formatTypeText = new JLabel();
    JLabel byteLengthText = new JLabel();
    JLabel encodingTypeText = new JLabel();
    JLabel sampleRateText = new JLabel();
    JLabel sampleSizeInBitsText = new JLabel();
    JLabel channelsText = new JLabel();
    JLabel isBigEndianText = new JLabel();
    JLabel channelVariables = new JLabel();
    LabelledItemPanel audioFileInfoPanel = new LabelledItemPanel();
    UndoManager undo = new UndoRedo.Manager();

    public AudioFileEditor() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabs = new JTabbedPane();
        this.findAudioFile.setText("...");
        this.findAudioFile.addActionListener(e -> this.selectFile());
        this.findAudioFile.setToolTipText(BlueSystem.getString((String)"audioFile.selectFile"));
        this.audioFileName.setEditable(false);
        this.csoundCode.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (AudioFileEditor.this.af != null) {
                    AudioFileEditor.this.af.setCsoundPostCode(AudioFileEditor.this.csoundCode.getText());
                }
            }
        });
        this.csoundCode.setUndoManager(this.undo);
        this.csoundCode.getDocument().addUndoableEditListener(this.undo);
        this.audioFileInfoPanel.addItem(BlueSystem.getString((String)"soundfile.infoPanel.duration") + " ", this.durationText);
        this.audioFileInfoPanel.addItem(BlueSystem.getString((String)"soundfile.infoPanel.formatType") + " ", this.formatTypeText);
        this.audioFileInfoPanel.addItem(BlueSystem.getString((String)"soundfile.infoPanel.byteLength") + " ", this.byteLengthText);
        this.audioFileInfoPanel.addItem(BlueSystem.getString((String)"soundfile.infoPanel.encodingType") + " ", this.encodingTypeText);
        this.audioFileInfoPanel.addItem(BlueSystem.getString((String)"soundfile.infoPanel.sampleRate") + " ", this.sampleRateText);
        this.audioFileInfoPanel.addItem(BlueSystem.getString((String)"soundfile.infoPanel.sampleSize") + " ", this.sampleSizeInBitsText);
        this.audioFileInfoPanel.addItem(BlueSystem.getString((String)"soundfile.infoPanel.channels") + " ", this.channelsText);
        this.audioFileInfoPanel.addItem(BlueSystem.getString((String)"soundfile.infoPanel.isBigEndian") + " ", this.isBigEndianText);
        JPanel audioEditPanel = new JPanel();
        audioEditPanel.setLayout(new BorderLayout());
        audioEditPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BorderLayout());
        filePanel.add((Component)new JLabel(BlueSystem.getString((String)"audioFile.audioFileLabel") + " "), "West");
        filePanel.add((Component)this.audioFileName, "Center");
        filePanel.add((Component)this.findAudioFile, "East");
        filePanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        audioEditPanel.add((Component)filePanel, "North");
        audioEditPanel.add((Component)new JScrollPane(this.audioFileInfoPanel), "Center");
        tabs.add(BlueSystem.getString((String)"audioFile.tabTitle"), audioEditPanel);
        JPanel csoundPanel = new JPanel();
        csoundPanel.setLayout(new BorderLayout());
        csoundPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        csoundPanel.add((Component)this.channelVariables, "North");
        csoundPanel.add((Component)this.csoundCode, "Center");
        tabs.add("Csound", csoundPanel);
        this.add((Component)tabs, "Center");
    }

    protected void selectFile() {
        List rValue = FileChooserManager.getDefault().showOpenDialog((Object)this, (Component)this);
        if (!rValue.isEmpty()) {
            File temp = (File)rValue.get(0);
            if (temp.exists() && temp.isFile()) {
                try {
                    String absFilePath = temp.getCanonicalPath();
                    String relPath = BlueSystem.getRelativePath((String)absFilePath);
                    this.af.setSoundFileName(relPath);
                    this.setAudioFileInfo(relPath);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"message.file.notFound"));
            }
        }
    }

    @Override
    public void editScoreObject(ScoreObject sObj) {
        if (sObj == null) {
            System.err.println("[AudioFileEditor::editSoundObject()] ERROR: null object passed in");
            this.af = null;
            return;
        }
        if (!sObj.getClass().getName().equals("blue.soundObject.AudioFile")) {
            System.err.println("[AudioFileEditor::editSoundObject()] ERROR: not an instance of AudioFile");
            this.af = null;
            return;
        }
        this.af = (AudioFile)sObj;
        this.csoundCode.setText(this.af.getCsoundPostCode());
        this.setAudioFileInfo(this.af.getSoundFileName());
        this.undo.discardAllEdits();
    }

    private void setAudioFileInfo(String audioFile) {
        if (audioFile == null || audioFile.equals("")) {
            this.audioFileName.setText("Choose an Audio File");
            this.clearAudioInfo();
            return;
        }
        File soundFile = BlueSystem.findFile((String)audioFile);
        if (soundFile == null || !soundFile.exists() || !soundFile.isFile()) {
            this.audioFileName.setText("Could not find file: " + audioFile);
            this.clearAudioInfo();
            return;
        }
        this.audioFileName.setText(audioFile);
        try {
            AudioFileFormat aFormat = AudioSystem.getAudioFileFormat(soundFile);
            AudioFormat format = aFormat.getFormat();
            this.durationText.setText(this.getDuration(aFormat, format));
            this.formatTypeText.setText(aFormat.getType().toString());
            this.byteLengthText.setText(Integer.toString(aFormat.getByteLength()));
            this.encodingTypeText.setText(format.getEncoding().toString());
            this.sampleRateText.setText(Float.toString(format.getSampleRate()));
            this.sampleSizeInBitsText.setText(Integer.toString(format.getSampleSizeInBits()));
            int numChannels = format.getChannels();
            this.channelsText.setText(Integer.toString(numChannels));
            this.setChannelVariablesInfo(numChannels);
            this.isBigEndianText.setText(this.getBooleanString(format.isBigEndian()));
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"soundfile.infoPanel.error.couldNotOpenFile") + " " + soundFile.getAbsolutePath());
            this.clearAudioInfo();
            return;
        }
        catch (UnsupportedAudioFileException uae) {
            JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"soundfile.infoPanel.error.unsupportedAudio") + " " + uae.getLocalizedMessage());
            this.clearAudioInfo();
            return;
        }
    }

    private void setChannelVariablesInfo(int numChannels) {
        if (numChannels <= 0) {
            this.channelVariables.setText("");
            return;
        }
        String info = BlueSystem.getString((String)"audioFile.channelsMapped") + " aChannel1";
        int i = 1;
        while (i < numChannels) {
            info = info + ", aChannel" + ++i;
        }
        this.channelVariables.setText(info);
    }

    private String getDuration(AudioFileFormat aFormat, AudioFormat format) {
        float duration = (float)aFormat.getByteLength() / (format.getSampleRate() * (float)(format.getSampleSizeInBits() / 8) * (float)format.getChannels());
        int hours = (int)duration / 3600;
        int minutes = (int)(duration -= (float)(hours * 3600)) / 60;
        String h = Integer.toString(hours);
        String m = Integer.toString(minutes);
        String s = Float.toString(duration -= (float)(minutes * 60));
        if (hours < 10) {
            h = "0" + h;
        }
        if (minutes < 10) {
            m = "0" + m;
        }
        if (duration < 10.0f) {
            s = "0" + s;
        }
        return h + ":" + m + ":" + s;
    }

    private String getBooleanString(boolean val) {
        if (val) {
            return BlueSystem.getString((String)"soundfile.infoPanel.true");
        }
        return BlueSystem.getString((String)"soundfile.infoPanel.false");
    }

    void clearAudioInfo() {
        this.durationText.setText("");
        this.formatTypeText.setText("");
        this.byteLengthText.setText("");
        this.encodingTypeText.setText("");
        this.sampleRateText.setText("");
        this.sampleSizeInBitsText.setText("");
        this.channelsText.setText("");
        this.isBigEndianText.setText("");
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        BlueSystem.setCurrentProjectDirectory((File)new File("/home/steven"));
        AudioFileEditor afe = new AudioFileEditor();
        GUI.showComponentAsStandalone((Component)afe, (String)"Audio File Editor Test", (boolean)true);
        afe.editScoreObject((ScoreObject)new AudioFile());
    }
}

