/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor;

import blue.BlueSystem;
import blue.CompileData;
import blue.gui.InfoDialog;
import blue.score.ScoreObject;
import blue.soundObject.Instance;
import blue.soundObject.NoteList;
import blue.soundObject.SoundObject;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;

public class InstanceEditor
extends ScoreObjectEditor {
    Instance instance;
    JLabel editorLabel = new JLabel();
    MimeTypeEditorComponent scoreEditPane = new MimeTypeEditorComponent("text/x-csound-sco");
    JButton testButton = new JButton();
    JPanel topPanel = new JPanel();

    public InstanceEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.editorLabel.setText("generic editor");
        this.setLayout(new BorderLayout());
        this.scoreEditPane.getJEditorPane().setEditable(false);
        this.testButton.setText(BlueSystem.getString((String)"common.test"));
        this.testButton.addActionListener(e -> this.testSoundObject());
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.add((Component)this.editorLabel, "Center");
        this.topPanel.add((Component)this.testButton, "East");
        this.add((Component)this.scoreEditPane, "Center");
        this.add((Component)this.topPanel, "North");
    }

    @Override
    public void editScoreObject(ScoreObject sObj) {
        if (sObj == null) {
            this.instance = null;
            return;
        }
        if (!sObj.getClass().getName().equals("blue.soundObject.Instance")) {
            this.instance = null;
            return;
        }
        this.instance = (Instance)sObj;
        this.editorLabel.setText(BlueSystem.getString((String)"instanceObject.instanceOf") + " " + this.instance.getSoundObject().getName());
        String generatedNoteText = null;
        try {
            SoundObject clone = this.instance.getSoundObject().deepCopy();
            generatedNoteText = clone.generateForCSD(CompileData.createEmptyCompileData(), 0.0, -1.0).toString();
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            generatedNoteText = "Could not generate notes";
        }
        this.scoreEditPane.setText(BlueSystem.getString((String)"instanceObject.scoreGenMessage") + "\n\n" + generatedNoteText);
    }

    public final void testSoundObject() {
        if (this.instance == null) {
            return;
        }
        NoteList notes = null;
        try {
            SoundObject clone = this.instance.getSoundObject().deepCopy();
            notes = clone.generateForCSD(CompileData.createEmptyCompileData(), 0.0, -1.0);
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            notes = null;
        }
        if (notes != null) {
            InfoDialog.showInformationDialog(SwingUtilities.getRoot(this), notes.toString(), BlueSystem.getString((String)"soundObject.generatedScore"));
        }
    }
}

