/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor;

import blue.BlueSystem;
import blue.gui.ExceptionDialog;
import blue.gui.InfoDialog;
import blue.score.ScoreObject;
import blue.soundObject.JMask;
import blue.soundObject.NoteList;
import blue.soundObject.SoundObjectException;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.soundObject.editor.jmask.EditorListPanel;
import blue.soundObject.jmask.Field;
import blue.soundObject.jmask.Parameter;
import blue.ui.components.IconFactory;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import skt.swing.SwingUtil;

public class JMaskEditor
extends ScoreObjectEditor
implements ActionListener {
    EditorListPanel editorListPanel = new EditorListPanel();
    JMask jmask;
    Field field;
    JPopupMenu popup = new JPopupMenu();
    JCheckBox useSeedCheckBox = new JCheckBox("Seed");
    JSpinner seedSpinner = new JSpinner(new SpinnerNumberModel(0.0, -9.223372036854776E18, 9.223372036854776E18, 1.0));

    public JMaskEditor() {
        this.setLayout(new BorderLayout());
        JScrollPane jsp = new JScrollPane(this.editorListPanel);
        jsp.setBorder(null);
        this.add((Component)jsp, "Center");
        Box topPanel = new Box(0);
        topPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), new EmptyBorder(3, 3, 3, 3)));
        topPanel.add(new JLabel("JMask"));
        topPanel.add(Box.createHorizontalStrut(5));
        JButton optionsButton = new JButton(IconFactory.getDownArrowIcon());
        optionsButton.setMargin(new Insets(0, 0, 0, 0));
        optionsButton.setMaximumSize(new Dimension(17, 16));
        optionsButton.setPreferredSize(new Dimension(17, 16));
        optionsButton.setFocusPainted(false);
        topPanel.add(optionsButton);
        topPanel.add(Box.createGlue());
        optionsButton.addActionListener(e -> {
            this.updatePopup();
            this.popup.show(topPanel, optionsButton.getX(), optionsButton.getY() + optionsButton.getHeight());
        });
        this.useSeedCheckBox.addActionListener(e -> {
            if (this.jmask != null) {
                this.jmask.setSeedUsed(this.useSeedCheckBox.isSelected());
            }
        });
        this.seedSpinner.addChangeListener(e -> {
            if (this.jmask != null) {
                this.jmask.setSeed(((Number)this.seedSpinner.getValue()).longValue());
            }
        });
        this.seedSpinner.setMaximumSize(new Dimension(140, 200));
        this.seedSpinner.setPreferredSize(new Dimension(140, 22));
        topPanel.add(this.useSeedCheckBox);
        topPanel.add(this.seedSpinner);
        topPanel.add(Box.createHorizontalStrut(5));
        JButton testButton = new JButton("Test");
        testButton.setFocusPainted(false);
        testButton.setFocusable(false);
        testButton.addActionListener(e -> this.testScore());
        topPanel.add(testButton);
        this.add((Component)topPanel, "North");
        AbstractAction testAction = new AbstractAction("test-action"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JMaskEditor.this.testScore();
            }
        };
        testAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, BlueSystem.getMenuShortcutKey()));
        SwingUtil.installActions((JComponent)this, (Action[])new Action[]{testAction}, (int)1);
    }

    @Override
    public void editScoreObject(ScoreObject sObj) {
        if (sObj == null) {
            return;
        }
        if (!(sObj instanceof JMask)) {
            return;
        }
        JMask jmask = (JMask)sObj;
        this.jmask = null;
        this.useSeedCheckBox.setSelected(jmask.isSeedUsed());
        this.seedSpinner.setValue(jmask.getSeed());
        this.editorListPanel.setJMask(jmask);
        this.jmask = jmask;
        this.field = jmask.getField();
        this.updatePopup();
    }

    private void testScore() {
        if (this.jmask == null) {
            return;
        }
        NoteList notes = null;
        try {
            notes = new JMask(this.jmask).generateNotes(0.0, -1.0);
        }
        catch (SoundObjectException e) {
            ExceptionDialog.showExceptionDialog(SwingUtilities.getRoot(this), e);
        }
        if (notes != null) {
            InfoDialog.showInformationDialog(SwingUtilities.getRoot(this), notes.toString(), BlueSystem.getString((String)"soundObject.generatedScore"));
        }
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        JMaskEditor editor = new JMaskEditor();
        JMask jmask = new JMask();
        jmask.setSubjectiveDuration(5.0);
        editor.editScoreObject((ScoreObject)jmask);
        GUI.showComponentAsStandalone((Component)editor, (String)"JMask Editor", (boolean)true);
    }

    private void updatePopup() {
        this.popup.removeAll();
        for (int i = 0; i < this.field.getSize(); ++i) {
            Parameter param = this.field.getParameter(i);
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem("Parameter " + (i + 1));
            menuItem.setSelected(param.isVisible());
            menuItem.putClientProperty("parameter", param);
            this.popup.add(menuItem);
            menuItem.addActionListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e.getSource();
        Parameter param = (Parameter)menuItem.getClientProperty("parameter");
        param.setVisible(menuItem.isSelected());
    }
}

