/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.jmask;

import blue.soundObject.editor.jmask.DurationSettable;
import blue.soundObject.editor.jmask.TableEditor;
import blue.soundObject.jmask.Oscillator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OscillatorEditor
extends JPanel
implements DurationSettable {
    private Oscillator oscillator = null;
    private JSpinner exponentSpinner;
    private ButtonGroup freqButtonGroup;
    private JSpinner freqSpinner;
    private JComboBox frequencyTypeComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JComboBox oscTypeComboBox;
    private JSpinner phaseSpinner;
    private TableEditor tableEditor;

    public OscillatorEditor(Oscillator oscillator) {
        this.initComponents();
        this.oscTypeComboBox.setSelectedIndex(oscillator.getOscillatorType());
        this.phaseSpinner.setModel(new SpinnerNumberModel(oscillator.getPhaseInit(), 0.0, 1.0, 0.01));
        this.exponentSpinner.setModel(new SpinnerNumberModel(oscillator.getExponent(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.1));
        this.freqSpinner.setModel(new SpinnerNumberModel(oscillator.getFrequency(), Double.MIN_VALUE, Double.POSITIVE_INFINITY, 1.0));
        this.oscillator = oscillator;
        this.tableEditor.setTable(oscillator.getFreqTable());
        this.frequencyTypeComboBox.setSelectedIndex(oscillator.isFreqTableEnabled() ? 1 : 0);
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.freqSpinner.setVisible(!this.oscillator.isFreqTableEnabled());
        this.tableEditor.setVisible(this.oscillator.isFreqTableEnabled());
    }

    private void initComponents() {
        this.freqButtonGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.oscTypeComboBox = new JComboBox();
        this.tableEditor = new TableEditor();
        this.jLabel2 = new JLabel();
        this.phaseSpinner = new JSpinner();
        this.jLabel3 = new JLabel();
        this.exponentSpinner = new JSpinner();
        this.freqSpinner = new JSpinner();
        this.frequencyTypeComboBox = new JComboBox();
        this.jLabel1.setText("Oscillator");
        this.oscTypeComboBox.setModel(new DefaultComboBoxModel<String>(Oscillator.FUNCTIONS));
        this.oscTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OscillatorEditor.this.oscTypeComboBoxActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Initial Phase");
        this.phaseSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                OscillatorEditor.this.phaseSpinnerStateChanged(evt);
            }
        });
        this.jLabel3.setText("Exponent");
        this.exponentSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                OscillatorEditor.this.exponentSpinnerStateChanged(evt);
            }
        });
        this.freqSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                OscillatorEditor.this.freqSpinnerStateChanged(evt);
            }
        });
        this.frequencyTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Frequency (Constant)", "Frequency (Table)"}));
        this.frequencyTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OscillatorEditor.this.frequencyTypeComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.oscTypeComboBox, 0, 561, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phaseSpinner, -2, 84, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exponentSpinner, -2, 84, -2)).addGroup(layout.createSequentialGroup().addComponent(this.frequencyTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.freqSpinner, -2, 84, -2)).addComponent(this.tableEditor, -2, 627, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.exponentSpinner, this.phaseSpinner);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.oscTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.phaseSpinner, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.exponentSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.freqSpinner, -2, -1, -2).addComponent(this.frequencyTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tableEditor, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void frequencyTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.oscillator != null) {
            this.oscillator.setFreqTableEnabled(this.frequencyTypeComboBox.getSelectedIndex() == 1);
            this.updateDisplay();
        }
    }

    private void freqSpinnerStateChanged(ChangeEvent evt) {
        if (this.oscillator != null) {
            this.oscillator.setFrequency(((Double)this.freqSpinner.getValue()).doubleValue());
        }
    }

    private void exponentSpinnerStateChanged(ChangeEvent evt) {
        if (this.oscillator != null) {
            this.oscillator.setExponent(((Double)this.exponentSpinner.getValue()).doubleValue());
        }
    }

    private void phaseSpinnerStateChanged(ChangeEvent evt) {
        if (this.oscillator != null) {
            this.oscillator.setPhaseInit(((Double)this.phaseSpinner.getValue()).doubleValue());
        }
    }

    private void frequencyTableRadioButtonActionPerformed(ActionEvent evt) {
        if (this.oscillator != null) {
            this.oscillator.setFreqTableEnabled(true);
        }
    }

    private void fixedFreqRadioButtonActionPerformed(ActionEvent evt) {
        if (this.oscillator != null) {
            this.oscillator.setFreqTableEnabled(false);
        }
    }

    private void oscTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.oscillator != null) {
            this.oscillator.setOscillatorType(this.oscTypeComboBox.getSelectedIndex());
        }
    }

    @Override
    public void setDuration(double duration) {
        this.tableEditor.setDuration(duration);
    }
}

