/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.jmask;

import blue.soundObject.jmask.Table;
import blue.soundObject.jmask.TablePoint;
import blue.ui.utilities.UiUtilities;
import blue.utility.NumberUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;

public class TableCanvas
extends JComponent {
    private static EditPointsPopup popup = null;
    Table table = null;
    TablePoint selectedPoint = null;
    int leftBoundaryX = -1;
    int rightBoundaryX = -1;
    boolean locked = false;
    TableModelListener lineListener = e -> this.repaint();
    double duration = 1.0;

    public TableCanvas() {
        new TableCanvasMouseListener(this);
    }

    public void setTable(Table table) {
        if (this.table != null) {
            this.table.removeTableModelListener(this.lineListener);
        }
        this.table = table;
        if (this.table != null) {
            this.table.addTableModelListener(this.lineListener);
        }
        this.repaint();
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHints(hints);
        g2d.setColor(Color.black);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(Color.lightGray);
        g2d.drawRect(5, 5, this.getWidth() - 10, this.getHeight() - 10);
        Object currentColor = null;
        if (this.table == null) {
            return;
        }
        g2d.setColor(Color.GREEN);
        this.drawTable(g2d, this.table, true);
        if (this.selectedPoint != null) {
            double min = this.table.getMin();
            double max = this.table.getMax();
            int x = this.doubleToScreenX(this.selectedPoint.getTime());
            int y = this.doubleToScreenY(this.selectedPoint.getValue(), min, max);
            g2d.setColor(Color.red);
            this.paintPoint(g2d, x, y);
            if (this.table != null) {
                this.drawPointInformation(g2d, x, y);
            }
        }
    }

    private void drawPointInformation(Graphics2D g2d, int x, int y) {
        g2d.setColor(Color.white);
        double range = this.table.getMax() - this.table.getMin();
        double yVal = this.selectedPoint.getValue();
        double xVal = this.selectedPoint.getTime();
        String xText = "x: " + NumberUtilities.formatDouble((double)(xVal * this.duration));
        String yText = "y: " + NumberUtilities.formatDouble((double)yVal);
        int width = 95;
        int height = 28;
        int xLoc = x + 5;
        int yLoc = y + 5;
        if (x + width > this.getWidth()) {
            xLoc = x - width - 5;
        }
        if (y + height > this.getHeight()) {
            yLoc = y - 14 - 5;
        }
        g2d.drawString(xText, xLoc, yLoc);
        g2d.drawString(yText, xLoc, yLoc + 14);
    }

    private final void drawTable(Graphics g, Table table, boolean drawPoints) {
        int i;
        double min = table.getMin();
        double max = table.getMax();
        int[] xValues = new int[table.getRowCount()];
        int[] yValues = new int[table.getRowCount()];
        for (i = 0; i < table.getRowCount(); ++i) {
            TablePoint point = table.getTablePoint(i);
            xValues[i] = this.doubleToScreenX(point.getTime());
            yValues[i] = this.doubleToScreenY(point.getValue(), min, max);
        }
        switch (table.getInterpolationType()) {
            case 0: {
                for (i = 0; i < xValues.length - 1; ++i) {
                    g.drawLine(xValues[i], yValues[i], xValues[i + 1], yValues[i]);
                    g.drawLine(xValues[i + 1], yValues[i], xValues[i + 1], yValues[i + 1]);
                }
                break;
            }
            case 1: {
                if (table.getInterpolation() == 0.0) {
                    g.drawPolyline(xValues, yValues, xValues.length);
                    break;
                }
            }
            default: {
                int tableLen = this.getWidth() - 10;
                int[] tempTable = new int[tableLen];
                int[] xvals = new int[tableLen];
                int tableHeight = this.getHeight() - 10;
                double range = max - min;
                for (int i2 = 0; i2 < tableLen; ++i2) {
                    xvals[i2] = i2 + 5;
                    double time = (double)i2 / (double)tableLen;
                    double val = table.getValue(time);
                    double percent = (val - min) / range;
                    int y = (int)((double)tableHeight - percent * (double)tableHeight);
                    tempTable[i2] = y + 5;
                }
                g.drawPolyline(xvals, tempTable, tableLen);
            }
        }
        if (drawPoints) {
            for (i = 0; i < xValues.length; ++i) {
                this.paintPoint(g, xValues[i], yValues[i]);
            }
        }
    }

    private final void paintPoint(Graphics g, int x, int y) {
        g.fillRect(x - 2, y - 2, 5, 5);
    }

    private int doubleToScreenX(double val) {
        int width = this.getWidth() - 10;
        return (int)Math.round(val * (double)width) + 5;
    }

    private int doubleToScreenY(double yVal, double min, double max) {
        int height = this.getHeight() - 10;
        double range = max - min;
        double percent = (yVal - min) / range;
        int y = (int)Math.round((double)height * (1.0 - percent)) + 5;
        return y;
    }

    private double screenToDoubleX(int val) {
        double width = this.getWidth() - 10;
        return (double)(val - 5) / width;
    }

    private double screenToDoubleY(int val, double min, double max) {
        double height = this.getHeight() - 10;
        double percent = 1.0 - (double)(val - 5) / height;
        double range = max - min;
        return percent * range + min;
    }

    public void setBoundaryXValues() {
        if (this.selectedPoint == null) {
            return;
        }
        if (this.selectedPoint == this.table.getTablePoint(0)) {
            this.leftBoundaryX = 5;
            this.rightBoundaryX = 5;
            return;
        }
        if (this.selectedPoint == this.table.getTablePoint(this.table.getRowCount() - 1)) {
            this.leftBoundaryX = this.getWidth() - 5;
            this.rightBoundaryX = this.getWidth() - 5;
            return;
        }
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (this.table.getTablePoint(i) != this.selectedPoint) continue;
            TablePoint p1 = this.table.getTablePoint(i - 1);
            TablePoint p2 = this.table.getTablePoint(i + 1);
            this.leftBoundaryX = this.doubleToScreenX(p1.getTime());
            this.rightBoundaryX = this.doubleToScreenX(p2.getTime());
            return;
        }
    }

    protected TablePoint insertGraphPoint(int x, int y) {
        if (x < 5 || x > this.getWidth() - 5 || y < 5 || y > this.getHeight() - 5) {
            return null;
        }
        double min = this.table.getMin();
        double max = this.table.getMax();
        TablePoint point = new TablePoint();
        point.setLocation(this.screenToDoubleX(x), this.screenToDoubleY(y, min, max));
        int index = 1;
        for (int i = 0; i < this.table.getRowCount() - 1; ++i) {
            TablePoint p1 = this.table.getTablePoint(i);
            TablePoint p2 = this.table.getTablePoint(i + 1);
            if (!(point.getTime() >= p1.getTime()) || !(point.getTime() <= p2.getTime())) continue;
            index = i + 1;
            break;
        }
        this.table.addPoint(index, point);
        return point;
    }

    public TablePoint findGraphPoint(int x, int y) {
        double min = this.table.getMin();
        double max = this.table.getMax();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            TablePoint point = this.table.getTablePoint(i);
            int tempX = this.doubleToScreenX(point.getTime());
            int tempY = this.doubleToScreenY(point.getValue(), min, max);
            if (tempX < x - 2 || tempX > x + 2 || tempY < y - 2 || tempY > y + 2) continue;
            return point;
        }
        return null;
    }

    public TablePoint findGraphPoint(int x) {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            TablePoint point = this.table.getTablePoint(i);
            int tempX = this.doubleToScreenX(point.getTime());
            if (tempX < x - 2 || tempX > x + 2) continue;
            return point;
        }
        return null;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.table != null) {
            this.table.addTableModelListener(this.lineListener);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.table != null) {
            this.table.removeTableModelListener(this.lineListener);
        }
    }

    class EditPointsPopup
    extends JPopupMenu {
        Table table = null;

        public void setTable(Table table) {
            this.table = table;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            if (this.table != null) {
                super.show(invoker, x, y);
            }
        }
    }

    class TableCanvasMouseListener
    implements MouseListener,
    MouseMotionListener {
        TableCanvas tableCanvas;

        public TableCanvasMouseListener(TableCanvas tableEditor) {
            this.tableCanvas = tableEditor;
            tableEditor.addMouseListener(this);
            tableEditor.addMouseMotionListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (TableCanvas.this.table == null) {
                return;
            }
            if (TableCanvas.this.selectedPoint != null) {
                if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                    TablePoint first = TableCanvas.this.table.getTablePoint(0);
                    TablePoint last = TableCanvas.this.table.getTablePoint(TableCanvas.this.table.getRowCount() - 1);
                    if (TableCanvas.this.selectedPoint != first && TableCanvas.this.selectedPoint != last) {
                        TableCanvas.this.table.removePoint(TableCanvas.this.selectedPoint);
                        TableCanvas.this.selectedPoint = null;
                    }
                } else {
                    TableCanvas.this.setBoundaryXValues();
                }
            } else if (SwingUtilities.isLeftMouseButton(e)) {
                TableCanvas.this.selectedPoint = TableCanvas.this.insertGraphPoint(e.getX(), e.getY());
                TableCanvas.this.setBoundaryXValues();
            } else if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                // empty if block
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (TableCanvas.this.table == null) {
                return;
            }
            TableCanvas.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (TableCanvas.this.table == null) {
                return;
            }
            if (TableCanvas.this.selectedPoint != null) {
                int x = e.getX();
                int y = e.getY();
                int topY = 5;
                int bottomY = TableCanvas.this.getHeight() - 5;
                if (x < TableCanvas.this.leftBoundaryX) {
                    x = TableCanvas.this.leftBoundaryX;
                } else if (x > TableCanvas.this.rightBoundaryX) {
                    x = TableCanvas.this.rightBoundaryX;
                }
                if (y < topY) {
                    y = topY;
                } else if (y > bottomY) {
                    y = bottomY;
                }
                double min = TableCanvas.this.table.getMin();
                double max = TableCanvas.this.table.getMax();
                double floatYValue = TableCanvas.this.screenToDoubleY(y, min, max);
                TableCanvas.this.selectedPoint.setLocation(TableCanvas.this.screenToDoubleX(x), floatYValue);
                TableCanvas.this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int y;
            if (TableCanvas.this.table == null) {
                return;
            }
            int x = e.getX();
            TablePoint foundPoint = TableCanvas.this.findGraphPoint(x, y = e.getY());
            if (foundPoint != null) {
                if (TableCanvas.this.selectedPoint != foundPoint) {
                    TableCanvas.this.selectedPoint = foundPoint;
                    TableCanvas.this.repaint();
                }
            } else if (TableCanvas.this.selectedPoint != null) {
                TableCanvas.this.selectedPoint = null;
                TableCanvas.this.repaint();
            }
        }
    }
}

