/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.objectBuilder;

import blue.BlueSystem;
import blue.components.EditEnabledCheckBox;
import blue.orchestra.editor.blueSynthBuilder.BSBCompletionProvider;
import blue.soundObject.ObjectBuilder;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import blue.ui.utilities.SimpleDocumentListener;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoManager;
import org.openide.awt.UndoRedo;

public class ObjectBuilderCodeEditor
extends JComponent {
    MimeTypeEditorComponent codePane = new MimeTypeEditorComponent("text/x-object-builder");
    BSBCompletionProvider completionProvider = new BSBCompletionProvider();
    ObjectBuilder objBuilder = null;
    EditEnabledCheckBox editBox = new EditEnabledCheckBox();
    JComboBox<ObjectBuilder.LanguageType> languageTypeCombo = new JComboBox<ObjectBuilder.LanguageType>(ObjectBuilder.LanguageType.values());
    JTextField commandLineText = new JTextField();
    UndoManager undo = new UndoRedo.Manager();

    public ObjectBuilderCodeEditor() {
        this.languageTypeCombo.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                ObjectBuilder.LanguageType langType = (ObjectBuilder.LanguageType)e.getItem();
                this.commandLineText.setEnabled(e.getItem() == ObjectBuilder.LanguageType.EXTERNAL);
                if (this.objBuilder != null) {
                    this.objBuilder.setLanguageType(langType);
                }
            }
        });
        this.commandLineText.setEnabled(false);
        this.commandLineText.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (ObjectBuilderCodeEditor.this.objBuilder != null) {
                    ObjectBuilderCodeEditor.this.objBuilder.setCommandLine(ObjectBuilderCodeEditor.this.commandLineText.getText());
                }
            }
        });
        this.editBox.addEditModeListener(isEditing -> {
            this.codePane.getJEditorPane().setEnabled(isEditing);
            if (this.objBuilder != null) {
                this.objBuilder.setEditEnabled(isEditing);
            }
        });
        this.codePane.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (ObjectBuilderCodeEditor.this.objBuilder != null) {
                    ObjectBuilderCodeEditor.this.objBuilder.setCode(ObjectBuilderCodeEditor.this.codePane.getText());
                }
            }
        });
        JPanel topBar = new JPanel();
        topBar.setBorder(new EmptyBorder(3, 3, 3, 3));
        BoxLayout boxLayout = new BoxLayout(topBar, 0);
        topBar.setLayout(boxLayout);
        JLabel commandLabel = new JLabel(BlueSystem.getString((String)"programOptions.commandLine"));
        commandLabel.setBorder(new EmptyBorder(0, 3, 0, 0));
        topBar.add(commandLabel);
        topBar.add(this.commandLineText);
        topBar.add(this.languageTypeCombo);
        topBar.add(this.editBox);
        this.setLayout(new BorderLayout());
        this.add((Component)topBar, "North");
        this.add((Component)this.codePane, "Center");
        this.codePane.getDocument().addUndoableEditListener(this.undo);
        this.codePane.setUndoManager(this.undo);
        this.codePane.getJEditorPane().putClientProperty("bsb-completion-provider", this.completionProvider);
        this.codePane.getJEditorPane().setEnabled(false);
        this.undo.setLimit(1000);
    }

    public void editObjectBuilder(ObjectBuilder objBuilder) {
        this.objBuilder = null;
        this.codePane.setText(objBuilder.getCode());
        this.codePane.getJEditorPane().setCaretPosition(0);
        if (objBuilder != null) {
            if (this.editBox.isSelected() != objBuilder.isEditEnabled()) {
                this.editBox.doClick();
            }
        } else {
            this.editBox.setSelected(false);
        }
        this.languageTypeCombo.setSelectedItem(objBuilder.getLanguageType());
        this.commandLineText.setText(objBuilder.getCommandLine());
        this.objBuilder = objBuilder;
        this.completionProvider.setBSBGraphicInterface(objBuilder.getGraphicInterface());
        this.undo.discardAllEdits();
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        ObjectBuilderCodeEditor codeEditor = new ObjectBuilderCodeEditor();
        codeEditor.editObjectBuilder(new ObjectBuilder());
        GUI.showComponentAsStandalone((Component)codeEditor, (String)"ObjectBuilder Code Editor", (boolean)true);
    }
}

