/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.pianoRoll;

import blue.BlueSystem;
import blue.event.SelectionEvent;
import blue.event.SelectionListener;
import blue.soundObject.editor.pianoRoll.PianoNoteView;
import blue.soundObject.pianoRoll.PianoNote;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NotePropertiesEditor
extends JPanel
implements SelectionListener<PianoNoteView>,
PropertyChangeListener {
    PianoNote note = null;
    JTextField noteTemplateText = new JTextField();
    JLabel label = new JLabel(BlueSystem.getString((String)"pianoRoll.noteTemplate"));
    private boolean isUpdating = false;

    public NotePropertiesEditor() {
        this.setLayout(new BorderLayout(5, 5));
        this.label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        this.noteTemplateText.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), this.noteTemplateText.getBorder()));
        this.add((Component)this.label, "West");
        this.add((Component)this.noteTemplateText, "Center");
        this.noteTemplateText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateNoteTemplate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateNoteTemplate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateNoteTemplate();
            }

            private void updateNoteTemplate() {
                if (NotePropertiesEditor.this.note != null && !NotePropertiesEditor.this.isUpdating) {
                    NotePropertiesEditor.this.note.setNoteTemplate(NotePropertiesEditor.this.noteTemplateText.getText());
                }
            }
        });
    }

    public void selectionPerformed(SelectionEvent<PianoNoteView> e) {
        this.isUpdating = true;
        switch (e.getSelectionType()) {
            case 0: {
                PianoNoteView noteView = (PianoNoteView)e.getSelectedItem();
                this.note = noteView.getPianoNote();
                this.noteTemplateText.setEditable(true);
                this.noteTemplateText.setText(this.note.getNoteTemplate());
                break;
            }
            case -1: 
            case 1: {
                this.note = null;
                this.noteTemplateText.setEditable(false);
                this.noteTemplateText.setText("");
            }
        }
        this.isUpdating = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
}

