/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.blueShare;

import blue.BlueSystem;
import blue.tools.blueShare.BlueShareDialog;
import blue.tools.blueShare.BlueShareRemoteCaller;
import blue.tools.blueShare.effects.BlueShareEffectCategory;
import blue.tools.blueShare.instruments.BlueShareInstrumentCategory;
import blue.tools.blueShare.soundObjects.BlueShareSoundObjectCategory;
import blue.utility.GUI;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.JOptionPane;
import org.apache.xmlrpc.XmlRpcException;
import org.openide.windows.WindowManager;

public class BlueShare {
    private static BlueShareDialog dialog = null;

    private BlueShare() {
    }

    public static void runBlueShare() {
        BlueShareSoundObjectCategory[] sobjCategories;
        BlueShareEffectCategory[] effectCategories;
        BlueShareInstrumentCategory[] categories;
        String server = "http://blue.kunstmusik.com/blue_share/api";
        try {
            BlueShareRemoteCaller.setServer(server);
        }
        catch (MalformedURLException mue) {
            String error = BlueSystem.getString((String)"message.errorLabel") + " " + mue.getLocalizedMessage();
            JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
            return;
        }
        try {
            categories = BlueShareRemoteCaller.getInstrumentCategoryTree();
            effectCategories = BlueShareRemoteCaller.getEffectCategoryTree();
            sobjCategories = BlueShareRemoteCaller.getSoundObjectCategoryTree();
        }
        catch (ParseException pe) {
            String error = BlueSystem.getString((String)"blueShare.selectServer.couldNotReadResponse");
            JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
            pe.printStackTrace();
            return;
        }
        catch (XmlRpcException xre) {
            String error = BlueSystem.getString((String)"message.errorLabel") + " " + xre.getLocalizedMessage();
            JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
            return;
        }
        catch (IOException ioe) {
            String error = BlueSystem.getString((String)"message.errorLabel") + " " + ioe.getLocalizedMessage();
            JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
            return;
        }
        if (dialog == null) {
            dialog = new BlueShareDialog(WindowManager.getDefault().getMainWindow(), true);
        }
        dialog.setInstrumentCategories(categories);
        dialog.setEffectCategories(effectCategories);
        dialog.setSoundObjectCategories(sobjCategories);
        dialog.setVisible(true);
    }

    private static String selectServer() {
        String retVal = null;
        try {
            Document doc = new Document(new File(BlueSystem.getConfDir() + File.separator + "blueShare.xml"));
            Element root = doc.getRoot();
            Elements servers = root.getElements("server");
            Object[] serverOptions = new Object[servers.size()];
            int i = 0;
            while (servers.hasMoreElements()) {
                serverOptions[i] = servers.next().getTextString();
                ++i;
            }
            Object serverObj = JOptionPane.showInputDialog(null, BlueSystem.getString((String)"blueShare.selectServer.message"), BlueSystem.getString((String)"blueShare.selectServer.title"), -1, null, serverOptions, serverOptions[0]);
            if (serverObj != null) {
                retVal = serverObj.toString();
            }
        }
        catch (ParseException | HeadlessException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        BlueShare.runBlueShare();
    }
}

