/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.midi;

import blue.ui.core.midi.VirtualKeyboardPanel;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="VirtualKeyboardTopComponent", persistenceType=0)
public final class VirtualKeyboardTopComponent
extends TopComponent {
    private JSpinner channelSpinner;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSpinner octaveSpinner;
    private JSpinner velocitySpinner;
    private VirtualKeyboardPanel virtualKeyboardPanel1;

    public VirtualKeyboardTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(VirtualKeyboardTopComponent.class, (String)"CTL_VirtualKeyboardTopComponent"));
        this.setToolTipText(NbBundle.getMessage(VirtualKeyboardTopComponent.class, (String)"HINT_VirtualKeyboardTopComponent"));
        this.channelSpinner.addChangeListener(ce -> this.virtualKeyboardPanel1.setChannel((Integer)this.channelSpinner.getValue() - 1));
        this.octaveSpinner.addChangeListener(ce -> this.virtualKeyboardPanel1.setOctave((Integer)this.octaveSpinner.getValue()));
        this.velocitySpinner.addChangeListener(ce -> this.virtualKeyboardPanel1.setVelocity((Integer)this.velocitySpinner.getValue()));
        this.virtualKeyboardPanel1.addPropertyChangeListener(evt -> {
            String propertyName = evt.getPropertyName();
            if ("channel".equals(evt.getPropertyName())) {
                this.channelSpinner.setValue((Integer)evt.getNewValue() + 1);
            } else if ("octave".equals(propertyName)) {
                this.octaveSpinner.setValue(evt.getNewValue());
            }
        });
    }

    private void initComponents() {
        this.virtualKeyboardPanel1 = new VirtualKeyboardPanel();
        this.jLabel1 = new JLabel();
        this.channelSpinner = new JSpinner();
        this.jLabel2 = new JLabel();
        this.octaveSpinner = new JSpinner();
        this.jLabel3 = new JLabel();
        this.velocitySpinner = new JSpinner();
        this.jButton1 = new JButton();
        GroupLayout virtualKeyboardPanel1Layout = new GroupLayout(this.virtualKeyboardPanel1);
        this.virtualKeyboardPanel1.setLayout(virtualKeyboardPanel1Layout);
        virtualKeyboardPanel1Layout.setHorizontalGroup(virtualKeyboardPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 971, Short.MAX_VALUE));
        virtualKeyboardPanel1Layout.setVerticalGroup(virtualKeyboardPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 248, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(VirtualKeyboardTopComponent.class, (String)"VirtualKeyboardTopComponent.jLabel1.text"));
        this.channelSpinner.setModel(new SpinnerNumberModel(1, 1, 16, 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(VirtualKeyboardTopComponent.class, (String)"VirtualKeyboardTopComponent.jLabel2.text"));
        this.octaveSpinner.setModel(new SpinnerNumberModel(5, 0, 7, 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(VirtualKeyboardTopComponent.class, (String)"VirtualKeyboardTopComponent.jLabel3.text"));
        this.velocitySpinner.setModel(new SpinnerNumberModel(127, 0, 127, 1));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(VirtualKeyboardTopComponent.class, (String)"VirtualKeyboardTopComponent.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VirtualKeyboardTopComponent.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.channelSpinner, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.velocitySpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.octaveSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addContainerGap(427, Short.MAX_VALUE)).addComponent(this.virtualKeyboardPanel1, -1, -1, Short.MAX_VALUE));
        layout.linkSize(0, this.channelSpinner, this.octaveSpinner, this.velocitySpinner);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.channelSpinner, GroupLayout.Alignment.LEADING, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.velocitySpinner, GroupLayout.Alignment.LEADING, -2, -1, -2)).addComponent(this.octaveSpinner, -2, -1, -2)).addComponent(this.jButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.virtualKeyboardPanel1, -1, -1, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.virtualKeyboardPanel1.allNotesOff();
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
        p.setProperty("channel", Integer.toString(this.virtualKeyboardPanel1.getChannel()));
        p.setProperty("velocity", Integer.toString(this.virtualKeyboardPanel1.getVelocity()));
        p.setProperty("octave", Integer.toString(this.virtualKeyboardPanel1.getOctave()));
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
        this.virtualKeyboardPanel1.setChannel(Integer.parseInt(p.getProperty("channel", "0")));
        this.virtualKeyboardPanel1.setVelocity(Integer.parseInt(p.getProperty("velocity", "127")));
        this.virtualKeyboardPanel1.setOctave(Integer.parseInt(p.getProperty("octave", "5")));
        this.channelSpinner.setValue(this.virtualKeyboardPanel1.getChannel() + 1);
        this.velocitySpinner.setValue(this.virtualKeyboardPanel1.getVelocity());
        this.octaveSpinner.setValue(this.virtualKeyboardPanel1.getOctave());
    }
}

