/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra;

import blue.orchestra.Instrument;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.ui.core.orchestra.ArrangementEditPanel;
import blue.ui.core.orchestra.InstrumentEditPanel;
import blue.ui.core.orchestra.UserInstrumentLibrary;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.JSplitPane;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="OrchestraTopComponent", persistenceType=0)
public final class OrchestraTopComponent
extends TopComponent {
    private static OrchestraTopComponent instance;
    private final ArrangementEditPanel arrangementPanel = new ArrangementEditPanel();
    private final UserInstrumentLibrary userInstrumentLibrary = new UserInstrumentLibrary();
    boolean isChanging = false;
    private InstrumentEditPanel instrumentEditPanel1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;

    private OrchestraTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(OrchestraTopComponent.class, (String)"CTL_OrchestraTopComponent"));
        this.setToolTipText(NbBundle.getMessage(OrchestraTopComponent.class, (String)"HINT_OrchestraTopComponent"));
        this.jSplitPane2.setLeftComponent(this.arrangementPanel);
        this.jSplitPane2.setRightComponent(this.userInstrumentLibrary);
        BlueProjectManager.getInstance().addPropertyChangeListener(evt -> {
            if ("currentProject".equals(evt.getPropertyName())) {
                this.reinitialize();
            }
        });
        this.userInstrumentLibrary.addSelectionListener(e -> {
            Object obj = e.getSelectedItem();
            if (obj instanceof Instrument) {
                this.isChanging = true;
                this.instrumentEditPanel1.setEditingLibraryObject(true);
                this.editInstrument((Instrument)obj);
                this.arrangementPanel.deselect();
                this.isChanging = false;
            } else {
                this.isChanging = true;
                this.editInstrument(null);
                this.instrumentEditPanel1.setEditingLibraryObject(false);
                this.arrangementPanel.deselect();
                this.isChanging = false;
            }
        });
        this.arrangementPanel.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting() || this.isChanging) {
                return;
            }
            Instrument instr = this.arrangementPanel.getSelectedInstrument();
            this.editInstrument(instr);
            this.instrumentEditPanel1.setEditingLibraryObject(false);
            this.userInstrumentLibrary.deselect();
        });
        this.reinitialize();
    }

    private void reinitialize() {
        BlueProject project = BlueProjectManager.getInstance().getCurrentProject();
        if (project == null) {
            this.instrumentEditPanel1.editInstrument(null);
            this.arrangementPanel.setMixer(null);
            this.arrangementPanel.setArrangement(null);
        } else {
            this.instrumentEditPanel1.editInstrument(null);
            this.arrangementPanel.setMixer(project.getData().getMixer());
            this.arrangementPanel.setArrangement(project.getData().getArrangement());
        }
    }

    public void editInstrument(Instrument instrument) {
        this.instrumentEditPanel1.editInstrument(instrument);
    }

    public Instrument getInstrumentFromLibrary() {
        return this.userInstrumentLibrary.getSelectedInstrument();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.instrumentEditPanel1 = new InstrumentEditPanel();
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setMinimumSize(new Dimension(0, 0));
        this.jSplitPane2.setDividerLocation(200);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setMinimumSize(new Dimension(0, 0));
        this.jSplitPane1.setLeftComponent(this.jSplitPane2);
        this.jSplitPane1.setRightComponent(this.instrumentEditPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 519, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 139, Short.MAX_VALUE));
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

