/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.project;

import blue.BlueData;
import blue.ProjectProperties;
import blue.project.ProjectPluginEditor;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.ui.core.project.DiskRenderSettingsPanel;
import blue.ui.core.project.ProjectInformationPanel;
import blue.ui.core.project.RealtimeRenderSettingsPanel;
import blue.ui.nbutilities.lazyplugin.LazyPlugin;
import blue.ui.nbutilities.lazyplugin.LazyPluginFactory;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ProjectPropertiesTopComponent", persistenceType=0)
public final class ProjectPropertiesTopComponent
extends TopComponent {
    private static ProjectPropertiesTopComponent instance;
    private Map<String, ProjectPluginEditor> pluginEditors = new HashMap<String, ProjectPluginEditor>();
    private DiskRenderSettingsPanel diskRenderSettingsPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private ProjectInformationPanel projectInformationPanel1;
    private RealtimeRenderSettingsPanel realtimeRenderSettingsPanel1;
    private JTabbedPane tabs;

    public ProjectPropertiesTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ProjectPropertiesTopComponent.class, (String)"CTL_ProjectPropertiesTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ProjectPropertiesTopComponent.class, (String)"HINT_ProjectPropertiesTopComponent"));
        this.setupProjectPluginEditors();
        BlueProjectManager.getInstance().addPropertyChangeListener(evt -> {
            if ("currentProject".equals(evt.getPropertyName())) {
                this.reinitialize();
            }
        });
        this.reinitialize();
    }

    public void reinitialize() {
        BlueProject project = BlueProjectManager.getInstance().getCurrentProject();
        ProjectProperties projectProperties = null;
        BlueData data = null;
        if (project != null && (data = project.getData()) != null) {
            projectProperties = data.getProjectProperties();
        }
        for (ProjectPluginEditor editor : this.pluginEditors.values()) {
            editor.edit(data);
        }
        this.projectInformationPanel1.setProjectProperties(projectProperties);
        this.realtimeRenderSettingsPanel1.setProjectProperties(projectProperties);
        this.diskRenderSettingsPanel1.setProjectProperties(projectProperties);
    }

    private void initComponents() {
        this.tabs = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.realtimeRenderSettingsPanel1 = new RealtimeRenderSettingsPanel();
        this.jScrollPane2 = new JScrollPane();
        this.diskRenderSettingsPanel1 = new DiskRenderSettingsPanel();
        this.projectInformationPanel1 = new ProjectInformationPanel();
        this.jScrollPane1.setViewportView(this.realtimeRenderSettingsPanel1);
        this.tabs.addTab(NbBundle.getMessage(ProjectPropertiesTopComponent.class, (String)"ProjectPropertiesTopComponent.jScrollPane1.TabConstraints.tabTitle"), this.jScrollPane1);
        this.jScrollPane2.setViewportView(this.diskRenderSettingsPanel1);
        this.tabs.addTab(NbBundle.getMessage(ProjectPropertiesTopComponent.class, (String)"ProjectPropertiesTopComponent.jScrollPane2.TabConstraints.tabTitle"), this.jScrollPane2);
        this.tabs.addTab(NbBundle.getMessage(ProjectPropertiesTopComponent.class, (String)"ProjectPropertiesTopComponent.projectInformationPanel1.TabConstraints.tabTitle"), this.projectInformationPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabs, -1, 412, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabs, -1, 434, Short.MAX_VALUE));
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void setupProjectPluginEditors() {
        List plugins = LazyPluginFactory.loadPlugins((String)"blue/project/plugins/editors", ProjectPluginEditor.class);
        for (LazyPlugin plugin : plugins) {
            ProjectPluginEditor editor = (ProjectPluginEditor)plugin.getInstance();
            String displayname = plugin.getDisplayName();
            this.tabs.add(displayname, (Component)editor);
            this.pluginEditors.put(displayname, editor);
        }
    }
}

