/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score;

import blue.score.ScoreObject;
import blue.ui.core.render.RealtimeRenderManager;
import blue.ui.core.score.ModeManager;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScoreMode;
import blue.ui.core.score.ScoreObjectView;
import blue.ui.core.score.ScoreTopComponent;
import blue.ui.core.score.layers.LayerGroupPanel;
import blue.ui.core.score.mouse.BlueMouseAdapter;
import blue.ui.nbutilities.lazyplugin.LazyPlugin;
import blue.ui.nbutilities.lazyplugin.LazyPluginFactory;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.openide.util.lookup.InstanceContent;

public class ScoreMouseListener
extends MouseAdapter {
    private static final int EDGE = 5;
    private final Cursor LEFT_RESIZE_CURSOR = Cursor.getPredefinedCursor(10);
    private final Cursor RIGHT_RESIZE_CURSOR = Cursor.getPredefinedCursor(11);
    private final Cursor NORMAL_CURSOR = Cursor.getPredefinedCursor(0);
    private final Cursor MOVE_CURSOR = Cursor.getPredefinedCursor(13);
    private final ScoreTopComponent scoreTC;
    private MouseAdapter currentGestureListener = null;
    private BlueMouseAdapter[] mouseListeners;

    public ScoreMouseListener(ScoreTopComponent tc, InstanceContent content) {
        this.scoreTC = tc;
        BlueMouseAdapter.scoreTC = tc;
        BlueMouseAdapter.content = content;
        List plugins = LazyPluginFactory.loadPlugins((String)"blue/score/mouse", BlueMouseAdapter.class);
        this.mouseListeners = new BlueMouseAdapter[plugins.size()];
        for (int i = 0; i < plugins.size(); ++i) {
            this.mouseListeners[i] = (BlueMouseAdapter)((LazyPlugin)plugins.get(i)).getInstance();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        RealtimeRenderManager.getInstance().stopAuditioning();
        if (e.isConsumed()) {
            return;
        }
        this.scoreTC.getScorePanel().requestFocus();
        LayerGroupPanel lGroupPanel = this.scoreTC.getLayerGroupPanelAtPoint(e);
        ScoreObjectView<?> scoreObjView = null;
        if (lGroupPanel != null) {
            scoreObjView = lGroupPanel.getScoreObjectViewAtPoint(SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), (JComponent)((Object)lGroupPanel)));
        }
        BlueMouseAdapter.currentLayerGroupPanel = lGroupPanel;
        BlueMouseAdapter.currentScoreObjectView = scoreObjView;
        BlueMouseAdapter.content.add((Object)ScoreController.getInstance().getScorePath());
        BlueMouseAdapter current = null;
        ScoreMode mode = ModeManager.getInstance().getMode();
        try {
            for (int i = 0; i < this.mouseListeners.length && !e.isConsumed(); ++i) {
                if (!this.mouseListeners[i].acceptsMode(mode)) continue;
                current = this.mouseListeners[i];
                current.mousePressed(e);
            }
            this.currentGestureListener = e.isConsumed() ? current : null;
        }
        catch (Exception ex) {
            Logger.getLogger("ScoreMouseListener").severe("Mouse Press threw exception: " + ex.getMessage());
            this.currentGestureListener = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.isConsumed() || this.currentGestureListener == null) {
            return;
        }
        try {
            this.currentGestureListener.mouseDragged(e);
        }
        catch (Exception ex) {
            Logger.getLogger("ScoreMouseListener").severe("Mouse Dragged threw exception: " + ex.getMessage());
            this.currentGestureListener = null;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isConsumed() && this.currentGestureListener != null) {
            try {
                this.currentGestureListener.mouseReleased(e);
            }
            catch (Exception ex) {
                Logger.getLogger("ScoreMouseListener").severe("Mouse Released threw exception: " + ex.getMessage());
                this.currentGestureListener = null;
            }
        }
        this.currentGestureListener = null;
        BlueMouseAdapter.content.remove((Object)ScoreController.getInstance().getScorePath());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.isConsumed() || ModeManager.getInstance().getMode() != ScoreMode.SCORE) {
            return;
        }
        ScoreObjectView sObjView = this.scoreTC.getScoreObjectViewAtPoint(e);
        JLayeredPane scorePanel = this.scoreTC.getScorePanel();
        Collection selectedObjects = this.scoreTC.getLookup().lookupAll(ScoreObject.class);
        if (sObjView != null && selectedObjects.size() == 1 && selectedObjects.contains(sObjView.getScoreObject())) {
            Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), (JComponent)((Object)sObjView));
            JComponent comp = (JComponent)((Object)sObjView);
            if (p.x > 0 && p.x < 5) {
                scorePanel.setCursor(this.RIGHT_RESIZE_CURSOR);
            } else if (p.x > comp.getWidth() - 5 && p.x <= comp.getWidth()) {
                scorePanel.setCursor(this.LEFT_RESIZE_CURSOR);
            } else {
                scorePanel.setCursor(this.MOVE_CURSOR);
            }
        } else if (scorePanel.getCursor() != this.NORMAL_CURSOR) {
            scorePanel.setCursor(this.NORMAL_CURSOR);
        }
    }
}

