/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.mouse;

import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScoreMode;
import blue.ui.core.score.layers.LayerGroupPanel;
import blue.ui.core.score.mouse.BlueMouseAdapter;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class MarqueeSelectionListener
extends BlueMouseAdapter {
    boolean addMode = false;
    Rectangle scrollRect = new Rectangle(0, 0, 1, 1);

    @Override
    public void mousePressed(MouseEvent e) {
        if (currentScoreObjectView != null) {
            return;
        }
        e.consume();
        this.addMode = e.isShiftDown();
        if (!this.addMode) {
            ScoreController.getInstance().setSelectedScoreObjects(null);
        }
        Point point = SwingUtilities.convertPoint((JComponent)e.getSource(), e.getPoint(), scoreTC.getScorePanel());
        scoreTC.getMarquee().setStart(point);
        scoreTC.getMarquee().setVisible(true);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point point = SwingUtilities.convertPoint((JComponent)e.getSource(), e.getPoint(), scoreTC.getScorePanel());
        scoreTC.getMarquee().setDragPoint(point);
        e.consume();
        this.checkScroll(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Component[] comps;
        scoreTC.getMarquee().setVisible(false);
        for (Component c : comps = scoreTC.getLayerPanel().getComponents()) {
            if (!(c instanceof LayerGroupPanel)) continue;
            ((LayerGroupPanel)((Object)c)).marqueeSelectionPerformed(scoreTC.getMarquee());
        }
        e.consume();
    }

    private void checkScroll(MouseEvent e) {
        Point temp = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), scoreTC.getScorePanel());
        this.scrollRect.setLocation(temp);
        scoreTC.getScorePanel().scrollRectToVisible(this.scrollRect);
    }

    @Override
    public boolean acceptsMode(ScoreMode mode) {
        return mode == ScoreMode.SCORE;
    }
}

