/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.mouse;

import blue.score.ScoreObject;
import blue.score.TimeState;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScoreMode;
import blue.ui.core.score.mouse.BlueMouseAdapter;
import blue.utility.ScoreUtilities;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Collection;

public class ResizeScoreObjectsListener
extends BlueMouseAdapter {
    private static final int EDGE = 5;
    private Point startPoint;
    double[] startTimes = null;
    double[] endTimes = null;
    ResizeMode resizeMode = ResizeMode.RESIZE_LEFT;
    private ScoreObject[] selectedScoreObjects;
    private double minDiffTime;
    private double maxDiffTime;

    @Override
    public void mousePressed(MouseEvent e) {
        Cursor c = scoreTC.getScorePanel().getCursor();
        if (currentScoreObjectView == null || c == null || c.getType() != 11 && c.getType() != 10) {
            return;
        }
        e.consume();
        Object scoreObj = currentScoreObjectView.getScoreObject();
        Collection<? extends ScoreObject> temp = ScoreController.getInstance().getSelectedScoreObjects();
        if (temp.size() != 1) {
            return;
        }
        switch (c.getType()) {
            case 10: {
                this.resizeMode = ResizeMode.RESIZE_RIGHT;
                break;
            }
            case 11: {
                this.resizeMode = ResizeMode.RESIZE_LEFT;
                break;
            }
            default: {
                throw new RuntimeException("Error: Unknown resize type: " + c.getType());
            }
        }
        this.startPoint = e.getPoint();
        this.selectedScoreObjects = temp.toArray(new ScoreObject[0]);
        this.startTimes = new double[this.selectedScoreObjects.length];
        this.endTimes = new double[this.selectedScoreObjects.length];
        this.minDiffTime = Double.MAX_VALUE;
        this.maxDiffTime = Double.MIN_VALUE;
        for (int i = 0; i < this.selectedScoreObjects.length; ++i) {
            ScoreObject sObj = this.selectedScoreObjects[i];
            this.startTimes[i] = sObj.getStartTime();
            this.endTimes[i] = this.startTimes[i] + sObj.getSubjectiveDuration();
            if (sObj.getMaxResizeLeftDiff() < this.minDiffTime) {
                this.minDiffTime = sObj.getMaxResizeLeftDiff();
            }
            if (!(sObj.getMaxResizeRightDiff() > this.maxDiffTime)) continue;
            this.maxDiffTime = sObj.getMaxResizeRightDiff();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.resizeMode == ResizeMode.RESIZE_LEFT) {
            this.resizeScoreObjectLeft(e);
        } else if (this.resizeMode == ResizeMode.RESIZE_RIGHT) {
            this.resizeScoreObjectRight(e);
        }
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        e.consume();
        this.startPoint = null;
        this.startTimes = null;
        this.endTimes = null;
        this.selectedScoreObjects = null;
    }

    private void resizeScoreObjectRight(MouseEvent e) {
        double newEnd;
        if (this.selectedScoreObjects == null) {
            return;
        }
        TimeState timeState = scoreTC.getTimeState();
        int xVal = e.getX();
        if (timeState.isSnapEnabled()) {
            double minTime;
            double snapValue = timeState.getSnapValue();
            double endTime = ScoreUtilities.getSnapValueMove((double)((double)xVal / (double)timeState.getPixelSecond()), (double)snapValue);
            newEnd = endTime < (minTime = ScoreUtilities.getSnapValueMove((double)(this.startTimes[0] + snapValue / 2.0), (double)snapValue)) ? minTime : endTime;
        } else {
            double minTime;
            double endTime = (double)xVal / (double)timeState.getPixelSecond();
            double d = newEnd = endTime < (minTime = this.startTimes[0] + 5.0 / (double)timeState.getPixelSecond()) ? minTime : endTime;
        }
        if (newEnd > this.endTimes[0] + this.maxDiffTime) {
            newEnd = this.endTimes[0] + this.maxDiffTime;
        }
        this.selectedScoreObjects[0].resizeRight(newEnd);
    }

    private void resizeScoreObjectLeft(MouseEvent e) {
        double newStart;
        if (this.selectedScoreObjects == null) {
            return;
        }
        TimeState timeState = scoreTC.getTimeState();
        int xVal = e.getX();
        if (timeState.isSnapEnabled()) {
            double snapValue = timeState.getSnapValue();
            double endTime = ScoreUtilities.getSnapValueMove((double)(this.endTimes[0] - snapValue * (double)0.5001f), (double)snapValue);
            newStart = ScoreUtilities.getSnapValueMove((double)((double)xVal / (double)timeState.getPixelSecond()), (double)snapValue);
            double d = newStart = newStart < 0.0 ? 0.0 : newStart;
            if (newStart > endTime) {
                newStart = endTime;
            }
        } else {
            double maxTime = this.endTimes[0] - 5.0 / (double)timeState.getPixelSecond();
            if (xVal < 0) {
                xVal = 0;
            }
            if ((newStart = (double)xVal / (double)timeState.getPixelSecond()) > maxTime) {
                newStart = maxTime;
            }
        }
        if (newStart < this.startTimes[0] + this.minDiffTime) {
            newStart = this.startTimes[0] + this.minDiffTime;
        }
        this.selectedScoreObjects[0].resizeLeft(newStart);
    }

    @Override
    public boolean acceptsMode(ScoreMode mode) {
        return mode == ScoreMode.SCORE;
    }

    protected static enum ResizeMode {
        RESIZE_RIGHT,
        RESIZE_LEFT;

    }
}

