/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.undo;

import blue.BlueSystem;
import blue.score.ScoreObject;
import blue.score.layers.ScoreObjectLayer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class MoveScoreObjectsEdit
extends AbstractUndoableEdit {
    private ScoreObject[] scoreObjects;
    private ScoreObjectLayer[] startLayers;
    private ScoreObjectLayer[] endLayers;
    private double[] initialStartTimes;
    private double[] endingStartTimes;
    private String presentationName = null;

    public MoveScoreObjectsEdit(ScoreObject[] soundObjects, ScoreObjectLayer[] startLayers, ScoreObjectLayer[] endLayers, double[] initialStartTimes, double[] endingStarttimes) {
        this.scoreObjects = soundObjects;
        this.startLayers = startLayers;
        this.endLayers = endLayers;
        this.initialStartTimes = initialStartTimes;
        this.endingStartTimes = endingStarttimes;
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        for (int i = 0; i < this.scoreObjects.length; ++i) {
            ScoreObject scoreObj = this.scoreObjects[i];
            if (this.endingStartTimes != null) {
                scoreObj.setStartTime(this.endingStartTimes[i]);
            }
            if (this.startLayers == null || this.endLayers == null || this.startLayers[i] == this.endLayers[i]) continue;
            this.startLayers[i].remove(scoreObj);
            this.endLayers[i].add((Object)scoreObj);
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        for (int i = 0; i < this.scoreObjects.length; ++i) {
            ScoreObject scoreObj = this.scoreObjects[i];
            if (this.initialStartTimes != null) {
                scoreObj.setStartTime(this.initialStartTimes[i]);
            }
            if (this.startLayers == null || this.endLayers == null || this.startLayers[i] == this.endLayers[i]) continue;
            this.endLayers[i].remove(scoreObj);
            this.startLayers[i].add((Object)scoreObj);
        }
    }

    @Override
    public String getPresentationName() {
        if (this.presentationName != null) {
            return this.presentationName;
        }
        if (this.scoreObjects.length > 1) {
            return BlueSystem.getString((String)"scoreGUI.action.moveSoundObjects");
        }
        return BlueSystem.getString((String)"scoreGUI.action.moveSoundObject");
    }

    public void setPresentationName(String presentationName) {
        this.presentationName = presentationName;
    }
}

