/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.soundObject.renderer;

import blue.soundObject.SoundObject;
import blue.ui.core.score.layers.soundObject.SoundObjectView;
import blue.ui.core.soundObject.renderer.BarRenderer;
import blue.ui.utilities.BlueGradientFactory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class GenericRenderer
implements BarRenderer {
    protected int labelOffset = 5;
    private static Font renderFont = new Font("Dialog", 1, 12);
    protected static Color selectedBgColor = Color.white;
    protected static Color selectedBorder1 = selectedBgColor.brighter().brighter();
    protected static Color selectedBorder2 = selectedBgColor.darker().darker();
    protected static Color selectedFontColor = Color.darkGray;

    public GenericRenderer() {
    }

    public GenericRenderer(Color bgColor) {
    }

    @Override
    public void render(Graphics graphics, SoundObjectView sObjView, int pixelSeconds) {
        Color fontColor;
        Color border2;
        Color border1;
        Color bgColor;
        Graphics2D g = (Graphics2D)graphics;
        int w = sObjView.getSize().width;
        int h = sObjView.getSize().height;
        SoundObject sObj = sObjView.getSoundObject();
        if (sObjView.isSelected()) {
            bgColor = selectedBgColor;
            border1 = selectedBorder1;
            border2 = selectedBorder2;
            fontColor = selectedFontColor;
        } else {
            bgColor = sObj.getBackgroundColor();
            border1 = bgColor.brighter().brighter();
            border2 = bgColor.darker().darker();
            int total = bgColor.getRed() + bgColor.getGreen() + bgColor.getBlue();
            fontColor = total > 384 ? Color.black : Color.white;
        }
        g.setPaint(BlueGradientFactory.getGradientPaint((Color)bgColor));
        g.fillRect(0, 2, w, h - 4);
        g.setColor(border1);
        g.drawLine(0, 2, w - 1, 2);
        g.drawLine(0, 2, 0, h - 4);
        g.setColor(border2);
        g.drawLine(0, h - 3, w, h - 3);
        g.drawLine(w - 1, h - 3, w - 1, 2);
        double repeatPoint = sObj.getRepeatPoint();
        if (sObj.getTimeBehavior() == 1 && repeatPoint > 0.0) {
            double dur = sObj.getSubjectiveDuration();
            int[] x = new int[3];
            int[] y = new int[3];
            for (double lineTime = repeatPoint; lineTime <= dur; lineTime += repeatPoint) {
                g.setColor(border2);
                int lineX = (int)(lineTime * (double)pixelSeconds);
                x[0] = lineX - 5;
                x[1] = lineX;
                x[2] = lineX;
                y[0] = 3;
                y[1] = 8;
                y[2] = 3;
                g.fillPolygon(x, y, 3);
                y[0] = h - 3;
                y[1] = h - 8;
                y[2] = h - 3;
                g.fillPolygon(x, y, 3);
            }
        }
        g.setPaint(fontColor);
        if (h >= 20) {
            g.setComposite(AlphaComposite.Src);
            g.setFont(renderFont);
            String[] parts = sObjView.getSoundObject().getName().split("\\\\[n]");
            for (int i = 0; i < parts.length; ++i) {
                int y = 15 + i * 22;
                g.drawString(parts[i], this.labelOffset, y);
            }
        }
    }

    @Override
    public void cleanup(SoundObjectView sObjView) {
    }
}

