/*
 * Decompiled with CFR 0.152.
 */
package blue.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class BlueScrollBarUI
extends BasicScrollBarUI {
    private static Color shadowColor;
    private static Color highlightColor;
    private static Color darkShadowColor;
    private static Color thumbColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;
    protected int scrollBarWidth;
    public static final String FREE_STANDING_PROP = "JScrollBar.isFreeStanding";
    protected boolean isFreeStanding = true;

    public static ComponentUI createUI(JComponent c) {
        return new BlueScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        this.scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
        super.installDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        ((ScrollBarListener)this.propertyChangeListener).handlePropertyChange(this.scrollbar.getClientProperty(FREE_STANDING_PROP));
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new ScrollBarListener();
    }

    @Override
    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        shadowColor = UIManager.getColor("ScrollBar.shadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        darkShadowColor = UIManager.getColor("ScrollBar.darkShadow");
        thumbColor = UIManager.getColor("ScrollBar.thumb");
        thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
        thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, this.scrollBarWidth * 3 + 10);
        }
        return new Dimension(this.scrollBarWidth * 3 + 10, this.scrollBarWidth);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return this.createButton();
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return this.createButton();
    }

    private JButton createButton() {
        JButton jbutton = new JButton();
        jbutton.setPreferredSize(new Dimension(0, 0));
        jbutton.setMinimumSize(new Dimension(0, 0));
        jbutton.setMaximumSize(new Dimension(0, 0));
        return jbutton;
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        boolean leftToRight = c.getComponentOrientation().isLeftToRight();
        g.translate(thumbBounds.x, thumbBounds.y);
        if (this.scrollbar.getOrientation() == 1) {
            g.setColor(thumbColor);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.fillRoundRect(3, 0, thumbBounds.width - 6, thumbBounds.height - 1, thumbBounds.width - 6, thumbBounds.width - 6);
        } else {
            g.setColor(thumbColor);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.fillRoundRect(0, 3, thumbBounds.width - 1, thumbBounds.height - 6, thumbBounds.height - 6, thumbBounds.height - 6);
        }
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        return new Dimension(this.scrollBarWidth, this.scrollBarWidth);
    }

    @Override
    protected void setThumbBounds(int x, int y, int width, int height) {
        if (this.thumbRect.x == x && this.thumbRect.y == y && this.thumbRect.width == width && this.thumbRect.height == height) {
            return;
        }
        int minX = Math.min(x, this.thumbRect.x);
        int minY = Math.min(y, this.thumbRect.y);
        int maxX = Math.max(x + width, this.thumbRect.x + this.thumbRect.width);
        int maxY = Math.max(y + height, this.thumbRect.y + this.thumbRect.height);
        this.thumbRect.setBounds(x, y, width, height);
        this.scrollbar.repaint(minX, minY, maxX - minX + 1, maxY - minY + 1);
    }

    class ScrollBarListener
    extends BasicScrollBarUI.PropertyChangeHandler {
        ScrollBarListener() {
            super(BlueScrollBarUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals(BlueScrollBarUI.FREE_STANDING_PROP)) {
                this.handlePropertyChange(e.getNewValue());
            } else {
                super.propertyChange(e);
            }
        }

        public void handlePropertyChange(Object newValue) {
            if (newValue != null) {
                boolean temp = (Boolean)newValue;
                boolean becameFlush = !temp && BlueScrollBarUI.this.isFreeStanding;
                boolean becameNormal = temp && !BlueScrollBarUI.this.isFreeStanding;
                BlueScrollBarUI.this.isFreeStanding = temp;
                if (becameFlush) {
                    this.toFlush();
                } else if (becameNormal) {
                    this.toFreeStanding();
                }
            } else if (!BlueScrollBarUI.this.isFreeStanding) {
                BlueScrollBarUI.this.isFreeStanding = true;
                this.toFreeStanding();
            }
        }

        protected void toFlush() {
            BlueScrollBarUI.this.scrollBarWidth -= 2;
        }

        protected void toFreeStanding() {
            BlueScrollBarUI.this.scrollBarWidth += 2;
        }
    }
}

