/*
 * Decompiled with CFR 0.152.
 */
package blue.plaf;

import blue.plaf.BlueTabControlButton;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabListPopupAction;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;

public class BlueTabControlButtonFactory {
    private static IconLoader iconCache = null;

    public static Icon getIcon(String iconPath) {
        if (null == iconCache) {
            iconCache = new IconLoader();
        }
        return iconCache.obtainIcon(iconPath);
    }

    public static BlueTabControlButton createMaximizeRestoreButton(TabDisplayer displayer, boolean showBorder) {
        return new MaximizeRestoreButton(displayer, showBorder);
    }

    public static BlueTabControlButton createScrollLeftButton(TabDisplayer displayer, Action scrollAction, boolean showBorder) {
        TimerButton button = new TimerButton(9, displayer, scrollAction, showBorder);
        button.setToolTipText(ResourceBundle.getBundle("blue/plaf/Bundle").getString("Tip_Scroll_Documents_Left"));
        return button;
    }

    public static BlueTabControlButton createScrollRightButton(TabDisplayer displayer, Action scrollAction, boolean showBorder) {
        TimerButton button = new TimerButton(10, displayer, scrollAction, showBorder);
        button.setToolTipText(ResourceBundle.getBundle("blue/plaf/Bundle").getString("Tip_Scroll_Documents_Right"));
        return button;
    }

    public static BlueTabControlButton createDropDownButton(TabDisplayer displayer, boolean showBorder) {
        return new DropDownButton(displayer, showBorder);
    }

    private static Component getActiveTab(TabDisplayer displayer) {
        Component res = null;
        int selIndex = displayer.getSelectionModel().getSelectedIndex();
        if (selIndex >= 0) {
            TabData tab = displayer.getModel().getTab(selIndex);
            res = tab.getComponent();
        }
        return res;
    }

    private static Image loadImage(String path) {
        try {
            URL url = BlueTabControlButtonFactory.class.getResource("/" + path);
            return ImageIO.read(url);
        }
        catch (Exception e) {
            Logger.getLogger(BlueTabControlButtonFactory.class.getName()).log(Level.WARNING, "Cannot load image", e);
            return null;
        }
    }

    private static final class IconLoader {
        private Map<String, Icon> paths2Icons;

        private IconLoader() {
        }

        public Icon obtainIcon(String iconPath) {
            Icon icon;
            if (this.paths2Icons == null) {
                this.paths2Icons = new HashMap<String, Icon>(6);
            }
            if ((icon = this.paths2Icons.get(iconPath)) == null) {
                Image image = BlueTabControlButtonFactory.loadImage(iconPath);
                if (image == null) {
                    throw new IllegalArgumentException("Icon with resource path: " + iconPath + " can't be loaded, probably wrong path.");
                }
                icon = new ImageIcon(image);
                this.paths2Icons.put(iconPath, icon);
            }
            return icon;
        }
    }

    private static class DropDownButton
    extends BlueTabControlButton {
        private boolean forcePressedIcon = false;

        public DropDownButton(TabDisplayer displayer, boolean showBorder) {
            super(8, displayer, showBorder);
            this.setAction((Action)new TabListPopupAction(displayer));
            this.setToolTipText(ResourceBundle.getBundle("blue/plaf/Bundle").getString("Tip_Show_Opened_Documents_List"));
        }

        @Override
        protected void processMouseEvent(MouseEvent me) {
            super.processMouseEvent(me);
            if (this.isEnabled() && me.getID() == 501) {
                this.forcePressedIcon = true;
                this.repaint();
                this.getAction().actionPerformed(new ActionEvent(this, 1001, "pressed"));
            } else if (this.isEnabled() && me.getID() == 502) {
                this.forcePressedIcon = false;
                this.repaint();
            }
        }

        @Override
        protected String getTabActionCommand(ActionEvent e) {
            return null;
        }

        @Override
        void performAction(ActionEvent e) {
        }

        @Override
        public Icon getRolloverIcon() {
            if (this.forcePressedIcon) {
                return this.getPressedIcon();
            }
            return super.getRolloverIcon();
        }

        @Override
        public Icon getIcon() {
            if (this.forcePressedIcon) {
                return this.getPressedIcon();
            }
            return super.getIcon();
        }
    }

    private static class TimerButton
    extends BlueTabControlButton
    implements ActionListener {
        Timer timer = null;
        int count = 0;

        public TimerButton(int buttonId, TabDisplayer displayer, Action a, boolean showBorder) {
            super(buttonId, displayer, showBorder);
            this.setAction(a);
        }

        private Timer getTimer() {
            if (this.timer == null) {
                this.timer = new Timer(400, this);
                this.timer.setRepeats(true);
            }
            return this.timer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ++this.count;
            if (this.count > 2) {
                if (this.count > 5) {
                    this.timer.setDelay(75);
                } else {
                    this.timer.setDelay(200);
                }
            }
            this.performAction();
        }

        private void performAction() {
            if (!this.isEnabled()) {
                this.stopTimer();
                return;
            }
            this.getAction().actionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }

        private void startTimer() {
            Timer t = this.getTimer();
            if (t.isRunning()) {
                return;
            }
            this.repaint();
            t.setDelay(400);
            t.start();
        }

        private void stopTimer() {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.repaint();
            this.count = 0;
        }

        @Override
        protected void processMouseEvent(MouseEvent me) {
            if (this.isEnabled() && me.getID() == 501) {
                this.startTimer();
            } else if (me.getID() == 502) {
                this.stopTimer();
            }
            super.processMouseEvent(me);
        }

        @Override
        protected void processFocusEvent(FocusEvent fe) {
            super.processFocusEvent(fe);
            if (fe.getID() == 1005) {
                this.stopTimer();
            }
        }

        @Override
        protected String getTabActionCommand(ActionEvent e) {
            return null;
        }
    }

    private static class MaximizeRestoreButton
    extends BlueTabControlButton {
        public MaximizeRestoreButton(TabDisplayer displayer, boolean showBorder) {
            super(-1, displayer, showBorder);
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.registerComponent(this);
        }

        @Override
        protected String getTabActionCommand(ActionEvent e) {
            return "maximize";
        }

        @Override
        protected int getButtonId() {
            WinsysInfoForTabbedContainer winsysInfo;
            int retValue = 3;
            Component currentTab = BlueTabControlButtonFactory.getActiveTab(this.getTabDisplayer());
            if (null != currentTab && null != (winsysInfo = this.getTabDisplayer().getContainerWinsysInfo()) && winsysInfo.inMaximizedMode(currentTab)) {
                retValue = 4;
            }
            return retValue;
        }

        @Override
        public String getToolTipText() {
            if (this.getButtonId() == 3) {
                return ResourceBundle.getBundle("blue/plaf/Bundle").getString("Tip_Maximize_Window");
            }
            return ResourceBundle.getBundle("blue/plaf/Bundle").getString("Tip_Restore_Window");
        }
    }
}

