/*
 * Decompiled with CFR 0.152.
 */
package blue.plaf;

import blue.plaf.BlueLookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class BlueTabbedPaneUI
extends BasicTabbedPaneUI {
    private Color outerHighlight = BlueLookAndFeel.getControlDisabled();
    private Color innerHighlight = BlueLookAndFeel.getPrimaryControlHighlight();
    private Color outerShadow = BlueLookAndFeel.getControlDarkShadow();
    private Color innerShadow = BlueLookAndFeel.getDesktopColor();

    public static ComponentUI createUI(JComponent c) {
        return new BlueTabbedPaneUI();
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(UIManager.getColor("TabbedPane.selected"));
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x + 1, y + 1, w - 2, h - 3);
                break;
            }
            case 4: {
                g.fillRect(x, y + 1, w - 2, h - 3);
                break;
            }
            case 3: {
                g.fillRect(x + 1, y, w - 3, h - 1);
                break;
            }
            default: {
                g.fillRect(x + 1, y + 1, w - 3, h - 1);
            }
        }
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (tabPlacement != 1 || selectedIndex < 0 || this.rects[selectedIndex].y + this.rects[selectedIndex].height + 1 < y) {
            g.setColor(this.outerHighlight);
            g.drawLine(x, y, x + w - 2, y);
            g.setColor(this.innerHighlight);
            g.drawLine(x, y + 1, x + w - 2, y + 1);
        } else {
            Rectangle selRect = this.rects[selectedIndex];
            g.setColor(this.outerHighlight);
            g.drawLine(x, y, selRect.x - 1, y);
            g.setColor(this.innerHighlight);
            g.drawLine(x, y + 1, selRect.x - 2, y + 1);
            if (selRect.x + selRect.width < x + w - 2) {
                g.setColor(this.outerHighlight);
                g.drawLine(selRect.x + selRect.width, y, x + w - 2, y);
                g.setColor(this.innerHighlight);
                g.drawLine(selRect.x + selRect.width, y + 1, x + w - 2, y + 1);
            } else {
                g.setColor(this.shadow);
                g.setColor(Color.red);
                g.drawLine(x + w - 2, y, x + w - 2, y);
            }
        }
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (tabPlacement != 2 || selectedIndex < 0 || this.rects[selectedIndex].x + this.rects[selectedIndex].width + 1 < x) {
            g.setColor(this.outerHighlight);
            g.drawLine(x, y, x, y + h - 2);
            g.setColor(this.innerHighlight);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 2);
        } else {
            Rectangle selRect = this.rects[selectedIndex];
            g.setColor(this.outerHighlight);
            g.drawLine(x, y, x, selRect.y - 1);
            g.setColor(this.innerHighlight);
            g.drawLine(x + 1, y + 1, x + 1, selRect.y - 2);
            if (selRect.y + selRect.height < y + h - 2) {
                g.setColor(this.outerHighlight);
                g.drawLine(x, selRect.y + selRect.height, x, y + h - 2);
                g.setColor(this.innerHighlight);
                g.drawLine(x + 1, selRect.y + selRect.height, x + 1, y + h - 2);
            }
        }
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(this.innerShadow);
        if (tabPlacement != 3 || selectedIndex < 0 || this.rects[selectedIndex].y - 1 > h) {
            g.drawLine(x + 2, y + h - 2, x + w - 2, y + h - 2);
            g.setColor(this.outerShadow);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        } else {
            Rectangle selRect = this.rects[selectedIndex];
            g.drawLine(x + 2, y + h - 2, selRect.x - 1, y + h - 2);
            g.setColor(this.outerShadow);
            g.drawLine(x, y + h - 1, selRect.x - 1, y + h - 1);
            if (selRect.x + selRect.width < x + w - 2) {
                g.setColor(this.innerShadow);
                g.drawLine(selRect.x + selRect.width, y + h - 2, x + w - 2, y + h - 2);
                g.setColor(this.outerShadow);
                g.drawLine(selRect.x + selRect.width, y + h - 1, x + w - 1, y + h - 1);
            }
        }
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(this.innerShadow);
        if (tabPlacement != 4 || selectedIndex < 0 || this.rects[selectedIndex].x - 1 > w) {
            g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 3);
            g.setColor(this.outerShadow);
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        } else {
            Rectangle selRect = this.rects[selectedIndex];
            g.drawLine(x + w - 2, y + 1, x + w - 2, selRect.y - 1);
            g.setColor(this.outerShadow);
            g.drawLine(x + w - 1, y, x + w - 1, selRect.y - 1);
            if (selRect.y + selRect.height < y + h - 2) {
                g.setColor(this.innerShadow);
                g.drawLine(x + w - 2, selRect.y + selRect.height, x + w - 2, y + h - 2);
                g.setColor(this.outerShadow);
                g.drawLine(x + w - 1, selRect.y + selRect.height, x + w - 1, y + h - 2);
            }
        }
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(this.outerHighlight);
        switch (tabPlacement) {
            case 2: {
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                g.drawLine(x, y + 2, x, y + h - 3);
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x + 2, y, x + w - 1, y);
                g.setColor(this.shadow);
                g.drawLine(x + 2, y + h - 2, x + w - 1, y + h - 2);
                g.setColor(this.darkShadow);
                g.drawLine(x + 2, y + h - 1, x + w - 1, y + h - 1);
                break;
            }
            case 4: {
                g.drawLine(x, y, x + w - 3, y);
                g.setColor(this.shadow);
                g.drawLine(x, y + h - 2, x + w - 3, y + h - 2);
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 3);
                g.setColor(this.darkShadow);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 3);
                g.drawLine(x, y + h - 1, x + w - 3, y + h - 1);
                break;
            }
            case 3: {
                g.drawLine(x, y, x, y + h - 3);
                g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                g.setColor(this.shadow);
                g.drawLine(x + 2, y + h - 2, x + w - 3, y + h - 2);
                g.drawLine(x + w - 2, y, x + w - 2, y + h - 3);
                g.setColor(this.darkShadow);
                g.drawLine(x + 2, y + h - 1, x + w - 3, y + h - 1);
                g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + h - 2);
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 3);
                break;
            }
            default: {
                boolean bla;
                int yoffset = isSelected ? -1 : 0;
                boolean bl = bla = !isSelected && tabIndex > 0;
                if (bla) {
                    --x;
                    ++w;
                } else {
                    g.drawLine(x, y + 2, x, y + h - 1 + yoffset);
                }
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x + 2, y, x + w - 3, y);
                g.setColor(this.innerHighlight);
                g.drawLine(x + 1, y + 2, x + 1, y + h - 1 + yoffset);
                g.drawLine(x + 1, y + 2, x + 1, y + 2);
                g.drawLine(x + 2, y + 1, x + w - 3, y + 1);
                g.drawLine(x + w - 1, y + h + yoffset, x + w - 1, y + h + yoffset);
                g.setColor(this.innerShadow);
                g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 1 + yoffset);
                if (!isSelected) {
                    g.setColor(this.outerHighlight);
                } else {
                    g.setColor(this.outerShadow);
                }
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1 + yoffset);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
            }
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
    }
}

