/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.editor.clojure;

import blue.ui.editor.clojure.ClojureLexUtilities;
import blue.ui.editor.clojure.ClojureTokenId;
import blue.ui.editor.support.OffsetRange;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;

public class ClojureBracesMatcher
implements BracesMatcher {
    private final MatcherContext context;
    BracePair[] bracePairs = new BracePair[]{new BracePair(24, 10), new BracePair(17, 27), new BracePair(18, 28)};

    public ClojureBracesMatcher(MatcherContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws InterruptedException, BadLocationException {
        int[] ret;
        block6: {
            ret = null;
            ((AbstractDocument)this.context.getDocument()).readLock();
            try {
                Token token;
                BaseDocument doc = (BaseDocument)this.context.getDocument();
                int offset = this.context.getSearchOffset();
                TokenSequence<ClojureTokenId> ts = ClojureLexUtilities.getClojureTokenSequence((Document)doc, offset);
                if (ts == null) break block6;
                ts.move(offset);
                if (!ts.moveNext() || (token = ts.token()) == null) break block6;
                TokenId id = token.id();
                int ordinal = id.ordinal();
                for (BracePair bp : this.bracePairs) {
                    if (ordinal == bp.open) {
                        ret = new int[]{ts.offset(), ts.offset() + token.length()};
                    } else {
                        if (ordinal != bp.close) continue;
                        ret = new int[]{ts.offset(), ts.offset() + token.length()};
                    }
                    break;
                }
            }
            finally {
                ((AbstractDocument)this.context.getDocument()).readUnlock();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        int[] ret;
        block6: {
            ret = null;
            ((AbstractDocument)this.context.getDocument()).readLock();
            try {
                Token token;
                BaseDocument doc = (BaseDocument)this.context.getDocument();
                int offset = this.context.getSearchOffset();
                TokenSequence<ClojureTokenId> ts = ClojureLexUtilities.getClojureTokenSequence((Document)doc, offset);
                if (ts == null) break block6;
                ts.move(offset);
                if (!ts.moveNext() || (token = ts.token()) == null) break block6;
                TokenId id = token.id();
                int ordinal = id.ordinal();
                for (BracePair bp : this.bracePairs) {
                    if (ordinal == bp.open) {
                        OffsetRange r = ClojureLexUtilities.findFwd(ts, bp.open, bp.close);
                        ret = new int[]{r.getStart(), r.getEnd()};
                    } else {
                        if (ordinal != bp.close) continue;
                        OffsetRange r = ClojureLexUtilities.findBwd(ts, bp.open, bp.close);
                        ret = new int[]{r.getStart(), r.getEnd()};
                    }
                    break;
                }
            }
            finally {
                ((AbstractDocument)this.context.getDocument()).readUnlock();
            }
        }
        return ret;
    }

    private class BracePair {
        int open;
        int close;

        private BracePair(int op, int cl) {
            this.open = op;
            this.close = cl;
        }
    }
}

