/*
 * Decompiled with CFR 0.152.
 */
package blue.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;

public final class ProcessRunner {
    transient OutputThread stdoutThread = null;
    transient OutputThread stderrThread = null;
    transient BufferedReader bufferedReaderStdout = null;
    transient BufferedReader bufferedReaderStderr = null;
    public transient Process process = null;
    String commandLine = null;
    transient PrintWriter stdin = null;
    StringBuffer buffer = null;
    private int lastExitValue = 0;

    public void execWait(String commandLine, File currentWorkingDirectory) throws IOException {
        try {
            this.exec(commandLine, currentWorkingDirectory, false);
            this.process.waitFor();
            this.destroy(true, false);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void execWaitAndCollect(String commandLine, File currentWorkingDirectory) throws IOException {
        try {
            this.exec(commandLine, currentWorkingDirectory, true);
            this.process.waitFor();
            while (this.stderrThread != null && this.stderrThread.isCollecting || this.stdoutThread != null && this.stdoutThread.isCollecting) {
                Thread.yield();
                Thread.sleep(50L);
            }
            this.destroy(true, false);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void execWaitForDisk(String commandLine, File currentWorkingDirectory) throws IOException {
        try {
            this.execDisk(commandLine, currentWorkingDirectory);
            this.process.waitFor();
            this.destroy(true, true);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static String[] splitCommandString(String in) {
        int mode = 0;
        ArrayList<String> parts = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        block5: for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            switch (mode) {
                case 0: {
                    if (c == '\n' || c == '\t' || c == ' ') continue block5;
                    if (c == '\"') {
                        mode = 2;
                        continue block5;
                    }
                    buffer.append(c);
                    mode = 1;
                    continue block5;
                }
                case 1: {
                    if (c == '\n' || c == '\t' || c == ' ') {
                        parts.add(buffer.toString());
                        buffer = new StringBuffer();
                        mode = 0;
                        continue block5;
                    }
                    buffer.append(c);
                    continue block5;
                }
                case 2: {
                    if (c == '\"') {
                        parts.add(buffer.toString());
                        buffer = new StringBuffer();
                        mode = 0;
                        continue block5;
                    }
                    buffer.append(c);
                }
            }
        }
        if (buffer.length() != 0) {
            parts.add(buffer.toString());
        }
        String[] retVal = parts.toArray(new String[parts.size()]);
        return retVal;
    }

    private void exec(String commandLine, File currentWorkingdirectory, boolean collecting) throws IOException {
        this.destroy(false);
        this.buffer = collecting ? new StringBuffer() : null;
        System.out.println("Began Exec(" + commandLine + ").");
        this.commandLine = commandLine;
        if (System.getProperty("os.name").contains("Windows")) {
            this.process = Runtime.getRuntime().exec(commandLine, null, currentWorkingdirectory);
        } else {
            String[] cmdArray = ProcessRunner.splitCommandString(this.commandLine);
            this.process = Runtime.getRuntime().exec(cmdArray, null, currentWorkingdirectory);
        }
        this.bufferedReaderStderr = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        this.stderrThread = new OutputThread(this.bufferedReaderStderr);
        this.bufferedReaderStdout = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        this.stdoutThread = new OutputThread(this.bufferedReaderStdout);
        this.stderrThread.start();
        this.stdoutThread.start();
        this.stdin = new PrintWriter(this.process.getOutputStream());
    }

    private void execDisk(String commandLine, File currentWorkingdirectory) throws IOException {
        this.destroy(false);
        System.out.println("Began Exec(" + commandLine + ").");
        this.commandLine = commandLine;
        if (System.getProperty("os.name").contains("Windows")) {
            this.process = Runtime.getRuntime().exec(commandLine, null, currentWorkingdirectory);
        } else {
            String[] cmdArray = ProcessRunner.splitCommandString(this.commandLine);
            this.process = Runtime.getRuntime().exec(cmdArray, null, currentWorkingdirectory);
        }
        this.bufferedReaderStderr = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        this.stderrThread = new OutputThread(this.bufferedReaderStderr);
        this.bufferedReaderStdout = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        this.stdoutThread = new OutputThread(this.bufferedReaderStdout);
        this.stderrThread.start();
        this.stdoutThread.start();
        this.stdin = new PrintWriter(this.process.getOutputStream());
    }

    public boolean isRunning() {
        return this.process != null;
    }

    public void destroy(boolean notifyListeners) {
        this.destroy(notifyListeners, true);
    }

    public void destroy(boolean notifyListeners, boolean killProcess) {
        if (killProcess) {
            try {
                if (this.stderrThread != null) {
                    this.stderrThread.killThread = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.stdoutThread != null) {
                    this.stdoutThread.killThread = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.process != null && killProcess) {
                    this.process.destroy();
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        } else if (this.process != null) {
            try {
                this.process.waitFor();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        if (this.process != null) {
            try {
                this.setLastExitValue(this.process.exitValue());
            }
            catch (IllegalThreadStateException itse) {
                this.setLastExitValue(0);
            }
        }
        this.stderrThread = null;
        this.stdoutThread = null;
        this.process = null;
        this.stdin = null;
        if (this.commandLine != null) {
            System.out.println("End Exec(" + this.commandLine + ").");
        }
        this.commandLine = null;
    }

    public void passToStdin(String text) {
        if (this.stdin != null) {
            this.stdin.print(text + "\n");
            this.stdin.flush();
        }
    }

    public String getCollectedOutput() {
        if (this.buffer == null) {
            return null;
        }
        return this.buffer.toString();
    }

    private void setLastExitValue(int lastExitValue) {
        this.lastExitValue = lastExitValue;
    }

    public int getLastExitValue() {
        return this.lastExitValue;
    }

    public class OutputThread
    extends Thread {
        BufferedReader reader = null;
        volatile boolean killThread = false;
        public boolean isCollecting = true;

        OutputThread(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public void run() {
            try {
                String line = null;
                int counter = 100;
                while ((line = this.reader.readLine()) != null && counter >= 0) {
                    if (this.killThread) {
                        --counter;
                    }
                    if (line.startsWith("blueTimePointer")) {
                        float time = Float.parseFloat(line.substring(line.indexOf("=") + 1));
                    } else if (ProcessRunner.this.buffer != null) {
                        ProcessRunner.this.buffer.append(line).append("\n");
                    }
                    OutputThread.yield();
                }
            }
            catch (IOException iOException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.isCollecting = false;
        }
    }
}

