/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.audio.core;

import blue.score.ScoreObject;
import blue.score.ScoreObjectEvent;
import blue.score.ScoreObjectListener;
import blue.score.layers.audio.core.FadeType;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.openide.util.Exceptions;

public final class AudioClip
implements ScoreObject,
Comparable<AudioClip> {
    private StringProperty name = new SimpleStringProperty();
    private DoubleProperty start = new SimpleDoubleProperty();
    private DoubleProperty duration = new SimpleDoubleProperty();
    private ObjectProperty<Color> color = new SimpleObjectProperty((Object)Color.DARK_GRAY);
    private ObjectProperty<File> audioFile = new SimpleObjectProperty();
    int numChannels = 0;
    double audioDuration = 0.0;
    private DoubleProperty fileStartTime = new SimpleDoubleProperty(0.0);
    private DoubleProperty fadeIn = new SimpleDoubleProperty(0.0);
    private ObjectProperty<FadeType> fadeInType = new SimpleObjectProperty((Object)FadeType.LINEAR);
    private DoubleProperty fadeOut = new SimpleDoubleProperty(0.0);
    private ObjectProperty<FadeType> fadeOutType = new SimpleObjectProperty((Object)FadeType.LINEAR);
    transient List<ScoreObjectListener> scoreObjListeners = null;

    public AudioClip() {
        this.name.addListener((obs, old, newVal) -> this.fireScoreObjectEvent(new ScoreObjectEvent((ScoreObject)this, 0)));
        this.start.addListener((obs, old, newVal) -> this.fireScoreObjectEvent(new ScoreObjectEvent((ScoreObject)this, 1)));
        this.duration.addListener((obs, old, newVal) -> this.fireScoreObjectEvent(new ScoreObjectEvent((ScoreObject)this, 2)));
        this.color.addListener((obs, old, newVal) -> this.fireScoreObjectEvent(new ScoreObjectEvent((ScoreObject)this, 3)));
    }

    public AudioClip(AudioClip ac) {
        this();
        this.setName(ac.getName());
        this.setStart(ac.getStart());
        this.setBackgroundColor(ac.getBackgroundColor());
        this.setAudioFile(ac.getAudioFile());
        this.setDuration(ac.getDuration());
        this.setFileStartTime(ac.getFileStartTime());
        this.setFadeIn(ac.getFadeIn());
        this.setFadeInType(ac.getFadeInType());
        this.setFadeOut(ac.getFadeOut());
        this.setFadeOutType(ac.getFadeOutType());
    }

    protected void readAudioFileProperties() {
        try {
            AudioFileFormat aFormat = AudioSystem.getAudioFileFormat((File)this.audioFile.get());
            AudioFormat format = aFormat.getFormat();
            this.numChannels = format.getChannels();
            this.audioDuration = (float)aFormat.getByteLength() / (format.getSampleRate() * (float)(format.getSampleSizeInBits() / 8) * (float)format.getChannels());
        }
        catch (IOException | UnsupportedAudioFileException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void setName(String value) {
        this.name.set((Object)value);
    }

    public String getName() {
        return (String)this.name.get();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public void setStart(double value) {
        this.start.set(value);
    }

    public double getStart() {
        return this.start.get();
    }

    public DoubleProperty startProperty() {
        return this.start;
    }

    public void setDuration(double value) {
        this.duration.set(value);
    }

    public double getDuration() {
        return this.duration.get();
    }

    public DoubleProperty durationProperty() {
        return this.duration;
    }

    public void setFileStartTime(double value) {
        this.fileStartTime.set(value);
    }

    public double getFileStartTime() {
        return this.fileStartTime.get();
    }

    public DoubleProperty fileStartTimeProperty() {
        return this.fileStartTime;
    }

    public void setFadeIn(double value) {
        this.fadeIn.set(value);
    }

    public double getFadeIn() {
        return this.fadeIn.get();
    }

    public DoubleProperty fadeInProperty() {
        return this.fadeIn;
    }

    public void setFadeOut(double value) {
        this.fadeOut.set(value);
    }

    public double getFadeOut() {
        return this.fadeOut.get();
    }

    public DoubleProperty fadeOutProperty() {
        return this.fadeOut;
    }

    public File getAudioFile() {
        return (File)this.audioFile.get();
    }

    public void setAudioFile(File audioFile) {
        this.audioFile.set((Object)audioFile);
        this.readAudioFileProperties();
        this.duration.set(this.audioDuration);
    }

    public ObjectProperty<File> audioFileProperty() {
        return this.audioFile;
    }

    public double getAudioDuration() {
        return this.audioDuration;
    }

    public void setAudioDuration(double originalDuration) {
        this.setDuration(originalDuration);
    }

    public double getStartTime() {
        return this.getStart();
    }

    public void setStartTime(double start) {
        this.setStart(start);
    }

    public double getSubjectiveDuration() {
        return this.getDuration();
    }

    public void setSubjectiveDuration(double duration) {
        double dur = Math.min(duration, this.getAudioDuration() - this.getFileStartTime());
        this.setDuration(dur);
    }

    public double getMaxResizeRightDiff() {
        return this.audioDuration - (this.getFileStartTime() + this.getDuration());
    }

    public double getMaxResizeLeftDiff() {
        return this.getStart() < this.getFileStartTime() ? -this.getStart() : -this.getFileStartTime();
    }

    public void resizeLeft(double newStartTime) {
        double maxDurDiff;
        double maxFileStartDiff;
        if (newStartTime >= this.getStart() + this.getDuration()) {
            return;
        }
        double diff = newStartTime - this.getStart();
        if (diff < (maxFileStartDiff = -this.getFileStartTime())) {
            diff = maxFileStartDiff;
        }
        if (-diff > (maxDurDiff = this.getAudioDuration() - this.getDuration())) {
            diff = -maxDurDiff;
        }
        this.setFileStartTime(this.getFileStartTime() + diff);
        this.setStartTime(this.getStart() + diff);
        this.setSubjectiveDuration(this.getDuration() - diff);
    }

    public void resizeRight(double newEndTime) {
        if (newEndTime <= this.getStart()) {
            return;
        }
        double newDur = newEndTime - this.getStart();
        newDur = newDur > this.getAudioDuration() ? this.getAudioDuration() : newDur;
        this.setSubjectiveDuration(newDur);
    }

    @Override
    public int compareTo(AudioClip o) {
        double diff = o.getStart() - this.getStart();
        if (diff != 0.0) {
            return (int)diff;
        }
        return (int)(o.getDuration() - this.getDuration());
    }

    public Color getBackgroundColor() {
        return (Color)this.color.get();
    }

    public void setBackgroundColor(Color color) {
        this.color.set((Object)color);
        ScoreObjectEvent event = new ScoreObjectEvent((ScoreObject)this, 3);
        this.fireScoreObjectEvent(event);
    }

    public ObjectProperty<Color> backgroundColorProperty() {
        return this.color;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public FadeType getFadeInType() {
        return (FadeType)((Object)this.fadeInType.getValue());
    }

    public void setFadeInType(FadeType fadeType) {
        this.fadeInType.setValue((Object)fadeType);
    }

    public ObjectProperty<FadeType> fadeInTypeProperty() {
        return this.fadeInType;
    }

    public FadeType getFadeOutType() {
        return (FadeType)((Object)this.fadeOutType.getValue());
    }

    public void setFadeOutType(FadeType fadeType) {
        this.fadeOutType.setValue((Object)fadeType);
    }

    public ObjectProperty<FadeType> fadeOutTypeProperty() {
        return this.fadeOutType;
    }

    public Element saveAsXML() {
        Element root = new Element("audioClip");
        root.addElement("name").setText(this.getName());
        root.addElement("audioFile").setText(this.getAudioFile().getAbsolutePath());
        root.addElement(XMLUtilities.writeInt((String)"numChannels", (int)this.getNumChannels()));
        root.addElement(XMLUtilities.writeDouble((String)"audioDuration", (double)this.getAudioDuration()));
        root.addElement(XMLUtilities.writeDouble((String)"fileStart", (double)this.getFileStartTime()));
        root.addElement(XMLUtilities.writeDouble((String)"start", (double)this.getStart()));
        root.addElement(XMLUtilities.writeDouble((String)"duration", (double)this.getDuration()));
        root.addElement(XMLUtilities.writeDouble((String)"fadeIn", (double)this.getFadeIn()));
        root.addElement("fadeInType").setText(this.getFadeInType().toString());
        root.addElement(XMLUtilities.writeDouble((String)"fadeOut", (double)this.getFadeOut()));
        root.addElement("fadeOutType").setText(this.getFadeOutType().toString());
        String colorStr = Integer.toString(this.getBackgroundColor().getRGB());
        root.addElement("backgroundColor").setText(colorStr);
        return root;
    }

    public static AudioClip loadFromXML(Element data) {
        AudioClip clip = new AudioClip();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeText = node.getTextString();
            switch (node.getName()) {
                case "name": {
                    clip.setName(nodeText);
                    break;
                }
                case "audioFile": {
                    clip.setAudioFile(new File(nodeText));
                    break;
                }
                case "numChannels": {
                    clip.numChannels = XMLUtilities.readInt((Element)node);
                    break;
                }
                case "audioDuration": {
                    clip.setAudioDuration(XMLUtilities.readDouble((Element)node));
                    break;
                }
                case "fileStart": {
                    clip.setFileStartTime(XMLUtilities.readDouble((Element)node));
                    break;
                }
                case "start": {
                    clip.setStart(XMLUtilities.readDouble((Element)node));
                    break;
                }
                case "duration": {
                    clip.setDuration(XMLUtilities.readDouble((Element)node));
                    break;
                }
                case "backgroundColor": {
                    String colorStr = data.getTextString("backgroundColor");
                    clip.setBackgroundColor(new Color(Integer.parseInt(colorStr)));
                    break;
                }
                case "fadeIn": {
                    clip.setFadeIn(XMLUtilities.readDouble((Element)node));
                    break;
                }
                case "fadeInType": {
                    clip.setFadeInType(FadeType.fromString(nodeText));
                    break;
                }
                case "fadeOut": {
                    clip.setFadeOut(XMLUtilities.readDouble((Element)node));
                    break;
                }
                case "fadeOutType": {
                    clip.setFadeOutType(FadeType.fromString(nodeText));
                }
            }
        }
        return clip;
    }

    public void addScoreObjectListener(ScoreObjectListener listener) {
        if (this.scoreObjListeners == null) {
            this.scoreObjListeners = new ArrayList<ScoreObjectListener>();
        }
        this.scoreObjListeners.add(listener);
    }

    public void removeScoreObjectListener(ScoreObjectListener listener) {
        if (this.scoreObjListeners != null) {
            this.scoreObjListeners.remove(listener);
        }
    }

    protected void fireScoreObjectEvent(ScoreObjectEvent event) {
        if (this.scoreObjListeners != null) {
            for (ScoreObjectListener listener : this.scoreObjListeners) {
                listener.scoreObjectChanged(event);
            }
        }
    }

    public AudioClip deepCopy() {
        return new AudioClip(this);
    }
}

