/*
 * Decompiled with CFR 0.152.
 */
package blue.settings;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ColorSelectionPanel
extends JPanel {
    private Color color = Color.BLACK;

    public ColorSelectionPanel() {
        this.setBackground(this.color);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ColorSelectionPanel.this.isEnabled()) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    ColorSelectionPanel.this.chooseColor();
                }
            }
        });
    }

    private void chooseColor() {
        Color retVal = JColorChooser.showDialog(SwingUtilities.getRoot(this), "Choose Color", this.color);
        if (retVal != null) {
            Color oldVal = this.color;
            this.setColor(retVal);
            this.firePropertyChange("colorSelectionValue", oldVal, retVal);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        Color oldVal = this.color;
        this.color = color;
        this.setBackground(color);
    }
}

