/*
 * Decompiled with CFR 0.152.
 */
package blue.settings;

import blue.services.render.DeviceInfo;
import blue.services.render.DiskRenderService;
import blue.utilities.ProcessRunner;
import blue.utility.FileUtilities;
import blue.utility.TextUtilities;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class DriverUtilities {
    private static MessageFormat ALSA_MIDI_FORMAT = new MessageFormat("{0} : {1} - {2}");

    public static List<DeviceInfo> getAudioDevices(String csoundCommand, String driver, DiskRenderService service, boolean isInput) {
        String driverLow;
        if (driver == null || csoundCommand == null || service == null) {
            return null;
        }
        List<DeviceInfo> devices = null;
        switch (driverLow = driver.toLowerCase().trim()) {
            case "pulse": {
                devices = DriverUtilities.getAudioDevicesPulse(isInput);
                break;
            }
            case "alsa": {
                devices = DriverUtilities.getAudioDevicesAlsa(isInput);
                break;
            }
            case "jack": {
                devices = DriverUtilities.getAudioDevicesJack(csoundCommand, service, isInput);
                break;
            }
            case "portaudio": 
            case "pa": 
            case "pa_cb": 
            case "pa_bl": 
            case "winmm": 
            case "mme": 
            case "coreaudio": 
            case "auhal": {
                devices = DriverUtilities.getAudioDevicesGeneric(csoundCommand, driver, service, isInput);
                break;
            }
            default: {
                devices = null;
            }
        }
        return devices;
    }

    public static List<DeviceInfo> getMidiDevices(String csoundCommand, String driver, DiskRenderService service, boolean isInput) {
        List<DeviceInfo> devices;
        String driverLow;
        switch (driverLow = driver.toLowerCase().trim()) {
            case "alsa": {
                devices = DriverUtilities.getMidiDevicesAlsa(isInput);
                break;
            }
            case "alsaseq": {
                devices = DriverUtilities.getMidiDevicesAlsaSeq(isInput);
                break;
            }
            default: {
                devices = DriverUtilities.getMidiDevicesGeneric(csoundCommand, driver, service, isInput);
            }
        }
        return devices;
    }

    protected static List<DeviceInfo> getMidiDevicesAlsa(boolean isInput) {
        List<DeviceInfo> devices = null;
        String portType = isInput ? "R" : "W";
        File f = new File("/proc/asound/seq/clients");
        try {
            String values = TextUtilities.getTextFromFile((File)f);
            devices = DriverUtilities.parseAlsaMidiDevices(values, portType, "hw:%d,%d");
        }
        catch (IOException | NumberFormatException ex) {
            return null;
        }
        return devices;
    }

    protected static List<DeviceInfo> getMidiDevicesAlsaSeq(boolean isInput) {
        List<DeviceInfo> devices = null;
        String portType = isInput ? "R" : "W";
        File f = new File("/proc/asound/seq/clients");
        try {
            String values = TextUtilities.getTextFromFile((File)f);
            devices = DriverUtilities.parseAlsaMidiDevices(values, portType, "%d:%d");
        }
        catch (IOException | NumberFormatException ex) {
            return null;
        }
        return devices;
    }

    protected static List<DeviceInfo> getMidiDevicesGeneric(String csoundCommand, String driver, DiskRenderService service, boolean isInput) {
        int csVersion = service.getCsoundVersion(csoundCommand);
        if (csVersion < 5) {
            return null;
        }
        String output = DriverUtilities.getCsoundMidiOutput(csoundCommand, driver, service, isInput);
        return DriverUtilities.parseCsoundMidiOutput(output, isInput);
    }

    protected static List<DeviceInfo> parseAlsaMidiDevices(String seqClients, String portType, String deviceIdFormat) {
        if (seqClients == null || seqClients.isEmpty() || portType == null || portType.isEmpty()) {
            return null;
        }
        ArrayList<DeviceInfo> devices = new ArrayList<DeviceInfo>();
        String[] lines = seqClients.split("\\r?\\n");
        block0: for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (!line.startsWith("Client") || !line.contains(":")) continue;
            String[] parts = line.split("\"");
            String clientName = parts[1];
            String clientType = parts[2].substring(1);
            int clientNum = Integer.parseInt(line.substring(7, line.indexOf(":")).trim());
            while (i < lines.length - 2) {
                String tempLine;
                if ((tempLine = lines[++i].trim()).startsWith("Port")) {
                    String capabilities = tempLine.substring(tempLine.lastIndexOf("("));
                    if (!capabilities.contains(portType)) continue;
                    String[] portParts = tempLine.split("\"");
                    int portNum = Integer.parseInt(tempLine.substring(5, tempLine.indexOf(":")).trim());
                    String portName = portParts[1];
                    Object[] nameArgs = new Object[]{clientName, portName, clientType};
                    String deviceId = String.format(deviceIdFormat, clientNum, portNum);
                    devices.add(new DeviceInfo(ALSA_MIDI_FORMAT.format(nameArgs), deviceId));
                    continue;
                }
                if (!tempLine.startsWith("Client")) continue;
                --i;
                continue block0;
            }
        }
        return devices;
    }

    protected static String getCsoundMidiOutput(String csoundCommand, String driver, DiskRenderService service, boolean isInput) {
        String val = TextUtilities.getTextFromSystemResource(DriverUtilities.class, (String)"temp.csd");
        File tempFile = FileUtilities.createTempTextFile((String)"temp", (String)".csd", null, (String)val);
        String ioFlag = isInput ? "-M999" : "-M999";
        String[] args = new String[]{csoundCommand, ioFlag, "-+msg_color=false", "-+rtmidi=" + driver, "-m1024", tempFile.getAbsolutePath()};
        return service.execWaitAndCollect(args, null);
    }

    protected static List<DeviceInfo> parseCsoundMidiOutput(String text, boolean isInput) {
        String[] lines;
        ArrayList<DeviceInfo> devices = new ArrayList<DeviceInfo>();
        boolean collect = false;
        String startToken = "sorting score";
        String endToken = "***";
        for (String line : lines = text.split("\\r?\\n")) {
            if (collect) {
                if (endToken.length() > 0 && line.contains(endToken)) {
                    collect = false;
                    continue;
                }
                if (!line.contains(":")) continue;
                try {
                    int cardNum = Integer.parseInt(line.substring(0, line.indexOf(":")).trim());
                    String desc = line.substring(line.indexOf(":") + 1).trim();
                    devices.add(new DeviceInfo(desc, Integer.toString(cardNum)));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!line.toLowerCase().contains(startToken)) continue;
            collect = true;
        }
        return devices;
    }

    protected static List<DeviceInfo> getAudioDevicesPulse(boolean isInput) {
        ArrayList<DeviceInfo> devices = new ArrayList<DeviceInfo>();
        if (isInput) {
            devices.add(new DeviceInfo("PulseAudio", "adc"));
        } else {
            devices.add(new DeviceInfo("PulseAudio", "dac"));
        }
        return devices;
    }

    protected static List<DeviceInfo> getAudioDevicesAlsa(boolean isInput) {
        ArrayList<DeviceInfo> devices = new ArrayList<DeviceInfo>();
        String searchVal = isInput ? "capture" : "playback";
        String prepend = isInput ? "adc:hw:" : "dac:hw:";
        File f = new File("/proc/asound/pcm");
        try {
            String values = TextUtilities.getTextFromFile((File)f);
            StringTokenizer st = new StringTokenizer(values, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                if (!line.contains(searchVal)) continue;
                String[] parts = line.split(":");
                String[] cardId = parts[0].split("-");
                int card = Integer.parseInt(cardId[0]);
                int num = Integer.parseInt(cardId[1]);
                String displayName = String.format("(%d:%d) %s : %s", card, num, parts[1], parts[2]);
                String deviceId = String.format("%s%d:%d", prepend, card, num);
                DeviceInfo info = new DeviceInfo(displayName, deviceId);
                devices.add(info);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        return devices;
    }

    protected static List<DeviceInfo> getAudioDevicesJack(String csoundCommand, DiskRenderService service, boolean isInput) {
        List<DeviceInfo> retVal = DriverUtilities.getAudioDevicesJackCsound(csoundCommand, service, isInput);
        if (retVal == null || retVal.size() == 0) {
            retVal = DriverUtilities.getAudioDevicesJackLsp(isInput);
        }
        return retVal;
    }

    protected static List<DeviceInfo> getAudioDevicesGeneric(String csoundCommand, String driver, DiskRenderService service, boolean isInput) {
        int csVersion = service.getCsoundVersion(csoundCommand);
        if (csVersion < 5) {
            return null;
        }
        String output = DriverUtilities.getCsoundOutput(csoundCommand, driver, service, isInput);
        return DriverUtilities.parseCsoundOutput(output, isInput);
    }

    protected static List<DeviceInfo> parseCsoundOutput(String text, boolean isInput) {
        String[] lines;
        ArrayList<DeviceInfo> devices = new ArrayList<DeviceInfo>();
        boolean collect = false;
        String prepend = isInput ? "adc" : "dac";
        String startToken = "audio buffered in";
        String endToken = "inactive allocs";
        for (String line : lines = text.split("\\r?\\n")) {
            if (collect) {
                if (endToken.length() > 0 && line.contains(endToken)) {
                    collect = false;
                    continue;
                }
                if (!line.contains(":")) continue;
                try {
                    int cardNum = Integer.parseInt(line.substring(0, line.indexOf(":")).trim());
                    String desc = line.substring(line.indexOf(":") + 1).trim();
                    devices.add(new DeviceInfo(desc, prepend + cardNum));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!line.contains(startToken)) continue;
            collect = true;
        }
        return devices;
    }

    protected static String getCsoundOutput(String csoundCommand, String driver, DiskRenderService service, boolean isInput) {
        String val = TextUtilities.getTextFromSystemResource(DriverUtilities.class, (String)"temp.csd");
        File tempFile = FileUtilities.createTempTextFile((String)"temp", (String)".csd", null, (String)val);
        String ioFlag = isInput ? "-iadc999" : "-odac999";
        String[] args = new String[]{csoundCommand, ioFlag, "-+msg_color=false", "-+rtaudio=" + driver, "-m1024", tempFile.getAbsolutePath()};
        return service.execWaitAndCollect(args, null);
    }

    protected static List<DeviceInfo> getAudioDevicesJackCsound(String csoundCommand, DiskRenderService service, boolean isInput) {
        String line;
        int csVersion = service.getCsoundVersion(csoundCommand);
        if (csVersion < 5) {
            return null;
        }
        ArrayList<DeviceInfo> devices = new ArrayList<DeviceInfo>();
        String jackCSD = TextUtilities.getTextFromSystemResource(DriverUtilities.class, (String)"tempJack.csd");
        String retVal = null;
        String tempText = jackCSD.replaceAll("\\$SR", "1000");
        File tempFile = FileUtilities.createTempTextFile((String)"temp", (String)".csd", null, (String)tempText);
        String ioFlag = isInput ? "-iadc:xxx" : "-odac:xxx";
        String[] args = new String[]{csoundCommand, ioFlag, "-B4096", "-+msg_color=false", "-+rtaudio=jack", tempFile.getAbsolutePath()};
        retVal = service.execWaitAndCollect(args, null);
        String sr = null;
        if (retVal != null && retVal.contains("does not match JACK sample rate")) {
            String[] lines = retVal.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                line = lines[i];
                if (!line.contains("does not match JACK sample rate")) continue;
                sr = line.substring(line.lastIndexOf(" ") + 1);
                break;
            }
        } else {
            return null;
        }
        if (sr == null) {
            return null;
        }
        tempText = jackCSD.replaceAll("\\$SR", sr);
        tempFile = FileUtilities.createTempTextFile((String)"temp", (String)".csd", null, (String)tempText);
        args[args.length - 1] = tempFile.getAbsolutePath();
        retVal = service.execWaitAndCollect(args, null);
        if (retVal == null) {
            return null;
        }
        if (csVersion == 5) {
            String prepend;
            StringTokenizer st = new StringTokenizer(retVal, "\n");
            String string = prepend = isInput ? "adc:" : "dac:";
            while (st.hasMoreTokens()) {
                line = st.nextToken().trim();
                if (!line.endsWith("channel)") && !line.endsWith("channels)")) continue;
                String deviceName = prepend + line.substring(1, line.lastIndexOf("\""));
                String description = deviceName + " " + line.substring(line.indexOf("("));
                DeviceInfo info = new DeviceInfo(description, deviceName);
                devices.add(info);
            }
        } else {
            List<DeviceInfo> temp = DriverUtilities.parseCsoundOutput(retVal, isInput);
            for (DeviceInfo info : temp) {
                String[] parts = info.toString().split("\\s+");
                devices.add(new DeviceInfo(info.toString(), parts[0]));
            }
        }
        return devices;
    }

    protected static List<DeviceInfo> getAudioDevicesJackLsp(boolean isInput) {
        String[] paths;
        String jackLspPath;
        ArrayList<DeviceInfo> devices = new ArrayList<DeviceInfo>();
        ProcessRunner pc = new ProcessRunner();
        String retVal = null;
        String portType = "audio";
        String subType = isInput ? "output" : "input";
        String prepend = isInput ? "adc:" : "dac:";
        String path = System.getenv("PATH");
        if (!File.pathSeparator.equals(";")) {
            path = path + File.pathSeparator + "/usr/local/bin";
        }
        if ((jackLspPath = DriverUtilities.findExecutableInPath("jack_lsp", paths = path.split(File.pathSeparator))) == null || jackLspPath.length() == 0) {
            return null;
        }
        try {
            pc.execWaitAndCollect(jackLspPath + " -t -p", null);
            retVal = pc.getCollectedOutput();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (retVal == null || retVal.length() == 0) {
            return null;
        }
        DriverUtilities.parseJackLspOutput(retVal, portType, subType, prepend, devices);
        return devices;
    }

    protected static void parseJackLspOutput(String output, String portType, String subType, String prepend, List<DeviceInfo> vals) throws NumberFormatException {
        String[] lines = output.split("\\n");
        ArrayList ports = new ArrayList();
        HashMap<String, Integer> portMap = new HashMap<String, Integer>();
        for (int i = 0; i < lines.length; i += 3) {
            int end;
            if (!lines[i + 2].contains(portType) || !lines[i + 1].contains(subType)) continue;
            String port = lines[i].trim();
            for (end = port.length() - 1; end >= 0 && Character.isDigit(port.charAt(end)); --end) {
            }
            String portName = port.substring(0, ++end);
            String chn = port.substring(end);
            if (portMap.containsKey(portName)) {
                portMap.put(portName, (Integer)portMap.get(portName) + 1);
                continue;
            }
            portMap.put(portName, 1);
        }
        portMap.entrySet().stream().forEach(entry -> {
            String displayName = (String)entry.getKey();
            String deviceId = prepend + displayName;
            displayName = (Integer)entry.getValue() == 1 ? displayName + "(1 channel)" : displayName + " (" + entry.getValue() + " channels)";
            vals.add(new DeviceInfo(displayName, deviceId));
        });
    }

    protected static String findExecutableInPath(String exe, String[] paths) {
        for (String p : paths) {
            System.out.println(new File(p + File.separator + exe));
            if (!new File(p + File.separator + exe).exists()) continue;
            return p + File.separator + exe;
        }
        return null;
    }
}

