/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.Interp;
import tcl.lang.NamespaceCmd;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;
import tcl.lang.Var;

class CallFrame {
    protected Interp interp;
    NamespaceCmd.Namespace ns;
    boolean isProcCallFrame;
    TclObject[] objv;
    protected CallFrame caller;
    protected CallFrame callerVar;
    protected int level;
    protected Hashtable varTable;

    CallFrame(Interp i) {
        this.interp = i;
        this.ns = i.globalNs;
        this.varTable = new Hashtable();
        this.caller = null;
        this.callerVar = null;
        this.objv = null;
        this.level = 0;
        this.isProcCallFrame = true;
    }

    CallFrame(Interp i, Procedure proc, TclObject[] objv) throws TclException {
        this(i);
        try {
            this.chain(proc, objv);
        }
        catch (TclException e) {
            this.dispose();
            throw e;
        }
    }

    void chain(Procedure proc, TclObject[] objv) throws TclException {
        this.ns = proc.ns;
        this.objv = objv;
        this.level = this.interp.varFrame == null ? 1 : this.interp.varFrame.level + 1;
        this.caller = this.interp.frame;
        this.callerVar = this.interp.varFrame;
        this.interp.frame = this;
        this.interp.varFrame = this;
        int numArgs = proc.argList.length;
        if (!proc.isVarArgs && objv.length - 1 > numArgs) {
            this.wrongNumProcArgs(objv[0], proc);
        }
        int i = 0;
        int j = 1;
        while (i < numArgs) {
            TclObject varName = proc.argList[i][0];
            TclObject value = null;
            if (i == numArgs - 1 && proc.isVarArgs) {
                value = TclList.newInstance();
                value.preserve();
                for (int k = j; k < objv.length; ++k) {
                    TclList.append(this.interp, value, objv[k]);
                }
                this.interp.setVar(varName, value, 0);
                value.release();
            } else {
                if (j < objv.length) {
                    value = objv[j];
                } else if (proc.argList[i][1] != null) {
                    value = proc.argList[i][1];
                } else {
                    this.wrongNumProcArgs(objv[0], proc);
                }
                this.interp.setVar(varName, value, 0);
            }
            ++i;
            ++j;
        }
    }

    private String wrongNumProcArgs(TclObject name, Procedure proc) throws TclException {
        StringBuffer sbuf = new StringBuffer(200);
        sbuf.append("wrong # args: should be \"");
        sbuf.append(name.toString());
        for (int i = 0; i < proc.argList.length; ++i) {
            TclObject arg = proc.argList[i][0];
            TclObject def = proc.argList[i][1];
            sbuf.append(" ");
            if (def != null) {
                sbuf.append("?");
            }
            sbuf.append(arg.toString());
            if (def == null) continue;
            sbuf.append("?");
        }
        sbuf.append("\"");
        throw new TclException(this.interp, sbuf.toString());
    }

    static boolean exists(Interp interp, String name) {
        try {
            Var[] result = Var.lookupVar(interp, name, null, 0, "lookup", false, false);
            if (result == null) {
                return false;
            }
            return !result[0].isVarUndefined();
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
    }

    Vector getVarNames() {
        Vector<String> vector = new Vector<String>();
        if (this.varTable == null) {
            return vector;
        }
        Enumeration e1 = this.varTable.elements();
        while (e1.hasMoreElements()) {
            Var v = (Var)e1.nextElement();
            if (v.isVarUndefined()) continue;
            vector.addElement(v.hashKey);
        }
        return vector;
    }

    Vector getLocalVarNames() {
        Vector<String> vector = new Vector<String>();
        if (this.varTable == null) {
            return vector;
        }
        Enumeration e1 = this.varTable.elements();
        while (e1.hasMoreElements()) {
            Var v = (Var)e1.nextElement();
            if (v.isVarUndefined() || v.isVarLink()) continue;
            vector.addElement(v.hashKey);
        }
        return vector;
    }

    static int getFrame(Interp interp, String string, CallFrame[] frameArr) throws TclException {
        CallFrame frame;
        int level;
        int curLevel;
        int result = 1;
        int n = curLevel = interp.varFrame == null ? 0 : interp.varFrame.level;
        if (string.length() > 0 && string.charAt(0) == '#') {
            level = Util.getInt(interp, string.substring(1));
            if (level < 0) {
                throw new TclException(interp, "bad level \"" + string + "\"");
            }
        } else if (string.length() > 0 && Character.isDigit(string.charAt(0))) {
            level = Util.getInt(interp, string);
            level = curLevel - level;
        } else {
            level = curLevel - 1;
            result = 0;
        }
        if (level == 0) {
            frame = null;
        } else {
            frame = interp.varFrame;
            while (frame != null && frame.level != level) {
                frame = frame.callerVar;
            }
            if (frame == null) {
                throw new TclException(interp, "bad level \"" + string + "\"");
            }
        }
        frameArr[0] = frame;
        return result;
    }

    protected void dispose() {
        this.interp.frame = this.caller;
        this.interp.varFrame = this.callerVar;
        this.caller = null;
        this.callerVar = null;
        if (this.varTable != null) {
            Var.deleteVars(this.interp, this.varTable);
            this.varTable.clear();
            this.varTable = null;
        }
    }
}

