/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import tcl.lang.ClockRelTimespan;
import tcl.lang.ClockToken;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class ClockCmd
implements Command {
    private static final String[] validCmds = new String[]{"clicks", "format", "scan", "seconds"};
    private static final int CMD_CLICKS = 0;
    private static final int CMD_FORMAT = 1;
    private static final int CMD_SCAN = 2;
    private static final int CMD_SECONDS = 3;
    private static final String[] clicksOpts = new String[]{"-milliseconds"};
    private static final int OPT_CLICKS_MILLISECONDS = 0;
    private static final String[] formatOpts = new String[]{"-format", "-gmt"};
    private static final int OPT_FORMAT_FORMAT = 0;
    private static final int OPT_FORMAT_GMT = 1;
    private static final String[] scanOpts = new String[]{"-base", "-gmt"};
    private static final int OPT_SCAN_BASE = 0;
    private static final int OPT_SCAN_GMT = 1;
    static final int EPOCH_YEAR = 1970;
    static final int MILLIS_PER_HOUR = 3600000;

    ClockCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        String format = null;
        boolean useGmt = false;
        TclObject baseObj = null;
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 1, objv, "option ?arg ...?");
        }
        int cmd = TclIndex.get((Interp)interp, (TclObject)objv[1], (String[])validCmds, (String)"option", (int)0);
        switch (cmd) {
            case 0: {
                if (objv.length > 3) {
                    throw new TclNumArgsException(interp, 2, objv, "?-milliseconds?");
                }
                if (objv.length == 3) {
                    int clicksOpt = TclIndex.get((Interp)interp, (TclObject)objv[2], (String[])clicksOpts, (String)"switch", (int)0);
                }
                long millis = System.currentTimeMillis();
                int clicks = (int)(millis % Integer.MAX_VALUE);
                interp.setResult(clicks);
                break;
            }
            case 1: {
                if (objv.length < 3 || objv.length > 7) {
                    throw new TclNumArgsException(interp, 2, objv, "clockval ?-format string? ?-gmt boolean?");
                }
                int clockVal = TclInteger.get((Interp)interp, (TclObject)objv[2]);
                int argIx = 3;
                while (argIx + 1 < objv.length) {
                    int formatOpt = TclIndex.get((Interp)interp, (TclObject)objv[argIx], (String[])formatOpts, (String)"switch", (int)0);
                    switch (formatOpt) {
                        case 0: {
                            format = objv[argIx + 1].toString();
                            break;
                        }
                        case 1: {
                            useGmt = TclBoolean.get((Interp)interp, (TclObject)objv[argIx + 1]);
                        }
                    }
                    argIx += 2;
                }
                if (argIx < objv.length) {
                    throw new TclNumArgsException(interp, 2, objv, "clockval ?-format string? ?-gmt boolean?");
                }
                this.FormatClock(interp, clockVal, useGmt, format);
                break;
            }
            case 2: {
                Date baseClock;
                if (objv.length < 3 || objv.length > 7) {
                    throw new TclNumArgsException(interp, 2, objv, "dateString ?-base clockValue? ?-gmt boolean?");
                }
                String dateString = objv[2].toString();
                int argIx = 3;
                while (argIx + 1 < objv.length) {
                    int scanOpt = TclIndex.get((Interp)interp, (TclObject)objv[argIx], (String[])scanOpts, (String)"switch", (int)0);
                    switch (scanOpt) {
                        case 0: {
                            baseObj = objv[argIx + 1];
                            break;
                        }
                        case 1: {
                            useGmt = TclBoolean.get((Interp)interp, (TclObject)objv[argIx + 1]);
                        }
                    }
                    argIx += 2;
                }
                if (argIx < objv.length) {
                    throw new TclNumArgsException(interp, 2, objv, "clockval ?-format string? ?-gmt boolean?");
                }
                if (baseObj != null) {
                    long seconds = TclInteger.get((Interp)interp, baseObj);
                    baseClock = new Date(seconds * 1000L);
                } else {
                    baseClock = new Date();
                }
                Date date = this.GetDate(dateString, baseClock, useGmt);
                if (date == null) {
                    throw new TclException(interp, "unable to convert date-time string \"" + dateString + "\"");
                }
                int seconds = (int)(date.getTime() / 1000L);
                interp.setResult(seconds);
                break;
            }
            case 3: {
                if (objv.length != 2) {
                    throw new TclNumArgsException(interp, 2, objv, null);
                }
                long millis = System.currentTimeMillis();
                int seconds = (int)(millis / 1000L);
                interp.setResult(seconds);
                break;
            }
        }
    }

    private void FormatClock(Interp interp, int clockVal, boolean useGMT, String format) throws TclException {
        Date date = new Date((long)clockVal * 1000L);
        GregorianCalendar calendar = new GregorianCalendar();
        FieldPosition fp = new FieldPosition(0);
        StringBuffer result = new StringBuffer();
        if (format == null) {
            format = new String("%a %b %d %H:%M:%S %Z %Y");
        }
        if (useGMT) {
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        calendar.setTime(date);
        SimpleDateFormat fmt = new SimpleDateFormat("mm.dd.yy", Locale.US);
        fmt.setCalendar(calendar);
        if (format.equals("%Q")) {
            int trekYear = calendar.get(1) + 377 - 2323;
            int trekDay = calendar.get(6) * 1000 / (calendar.isLeapYear(calendar.get(1)) ? 366 : 365);
            int trekHour = (calendar.get(11) * 60 + calendar.get(12)) / 144;
            interp.setResult("Stardate " + (trekYear < 10 ? "0" : "") + (trekYear * 1000 + trekDay) + '.' + trekHour);
            return;
        }
        for (int ix = 0; ix < format.length(); ++ix) {
            if (format.charAt(ix) == '%' && ix + 1 < format.length()) {
                switch (format.charAt(++ix)) {
                    case '%': {
                        result.append('%');
                        break;
                    }
                    case 'a': {
                        fmt.applyPattern("EEE");
                        fmt.format(date, result, fp);
                        break;
                    }
                    case 'A': {
                        fmt.applyPattern("EEEE");
                        fmt.format(date, result, fp);
                        break;
                    }
                    case 'b': 
                    case 'h': {
                        fmt.applyPattern("MMM");
                        fmt.format(date, result, fp);
                        break;
                    }
                    case 'B': {
                        fmt.applyPattern("MMMM");
                        fmt.format(date, result, fp);
                        break;
                    }
                    case 'c': {
                        SimpleDateFormat locFmt = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3);
                        locFmt.setCalendar(calendar);
                        locFmt.format(date, result, fp);
                        break;
                    }
                    case 'C': {
                        int century = calendar.get(1) / 100;
                        result.append((century < 10 ? "0" : "") + century);
                        break;
                    }
                    case 'd': {
                        fmt.applyPattern("dd");
                        fmt.format(date, result, fp);
                        break;
                    }
                    case 'D': {
                        fmt.applyPattern("MM/dd/yy");
                        fmt.format(date, result, fp);
                        break;
                    }
                    case 'e': {
                        fmt.applyPattern("d");
                        String day = fmt.format(date);
                        result.append((day.length() < 2 ? " " : "") + day);
                        break;
                    }
                    case 'H': {
                        fmt.applyPattern("HH");
                        fmt.format(date, result, fp);
                        break;
                    }
                    case 'I': {
                        fmt.applyPattern("hh");
                        fmt.format(date, result, fp);
                        break;
                    }
                    case 'j': {
                        fmt.applyPattern("DDD");
                        fmt.format(date, result, fp);
                        break;
                    }
                    case 'k': {
                        fmt.applyPattern("H");
                        String h24 = fmt.format(date);
                        result.append((h24.length() < 2 ? " " : "") + h24);
                        break;
                    }
                    case 'l': {
                        fmt.applyPattern("h");
                        String h12 = fmt.format(date);
                        result.append((h12.length() < 2 ? " " : "") + h12);
                        break;
                    }
                    case 'm': {
                        fmt.applyPattern("MM");
                        fmt.format(date, result, fp);
                        break;
                    }
                    case 'M': {
                        fmt.applyPattern("mm");
                        fmt.format(date, result, fp);
                        break;
                    }
                    case 'n': {
                        result.append('\n');
                        break;
                    }
                    case 'p': {
                        fmt.applyPattern("aa");
                        fmt.format(date, result, fp);
                        break;
                    }
                    case 'r': {
                        fmt.applyPattern("KK:mm:ss aaaa");
                        fmt.format(date, result, fp);
                        break;
                    }
                    case 'R': {
                        fmt.applyPattern("hh:mm");
                        fmt.format(date, result, fp);
                        break;
                    }
                    case 's': {
                        long millis = calendar.getTime().getTime();
                        if (useGMT) {
                            Calendar localCalendar = Calendar.getInstance();
                            localCalendar.setTime(calendar.getTime());
                            millis -= (long)(localCalendar.get(15) + localCalendar.get(16));
                        }
                        result.append((int)(millis / 1000L));
                        break;
                    }
                    case 'S': {
                        fmt.applyPattern("ss");
                        fmt.format(date, result, fp);
                        break;
                    }
                    case 't': {
                        result.append('\t');
                        break;
                    }
                    case 'T': {
                        fmt.applyPattern("hh:mm:ss");
                        fmt.format(date, result, fp);
                        break;
                    }
                    case 'u': {
                        int dayOfWeek17 = calendar.get(7);
                        if (dayOfWeek17 == 1) {
                            result.append(7);
                            break;
                        }
                        result.append(dayOfWeek17 - 1);
                        break;
                    }
                    case 'U': {
                        int weekS = this.GetWeek(calendar, 1, false);
                        result.append((weekS < 10 ? "0" : "") + weekS);
                        break;
                    }
                    case 'V': {
                        int isoWeek = this.GetWeek(calendar, 2, true);
                        result.append((isoWeek < 10 ? "0" : "") + isoWeek);
                        break;
                    }
                    case 'w': {
                        int dayOfWeek06 = calendar.get(7);
                        result.append(dayOfWeek06 - 1);
                        break;
                    }
                    case 'W': {
                        int weekM = this.GetWeek(calendar, 2, false);
                        result.append((weekM < 10 ? "0" : "") + weekM);
                        break;
                    }
                    case 'x': {
                        SimpleDateFormat locFmt = (SimpleDateFormat)DateFormat.getDateInstance(3);
                        locFmt.setCalendar(calendar);
                        locFmt.format(date, result, fp);
                        break;
                    }
                    case 'X': {
                        SimpleDateFormat locFmt = (SimpleDateFormat)DateFormat.getTimeInstance(3);
                        locFmt.setCalendar(calendar);
                        locFmt.format(date, result, fp);
                        break;
                    }
                    case 'y': {
                        fmt.applyPattern("yy");
                        fmt.format(date, result, fp);
                        break;
                    }
                    case 'Y': {
                        fmt.applyPattern("yyyy");
                        fmt.format(date, result, fp);
                        break;
                    }
                    case 'Z': {
                        fmt.applyPattern("zzz");
                        fmt.format(date, result, fp);
                        break;
                    }
                    default: {
                        result.append(format.charAt(ix));
                        break;
                    }
                }
                continue;
            }
            result.append(format.charAt(ix));
        }
        interp.setResult(result.toString());
    }

    private int GetWeek(Calendar calendar, int firstDayOfWeek, boolean iso) {
        if (iso) {
            firstDayOfWeek = 2;
        }
        calendar.setFirstDayOfWeek(firstDayOfWeek);
        calendar.setMinimalDaysInFirstWeek(iso ? 4 : 7);
        calendar.setTime(calendar.getTime());
        int week = calendar.get(3);
        if (!iso && calendar.get(2) == 0 && week > 50) {
            week = 0;
        }
        return week;
    }

    private void SetWeekday(Calendar calendar, ClockRelTimespan diff) {
        int weekday = diff.getWeekday();
        int dayOrdinal = diff.getDayOrdinal();
        while (calendar.get(7) != weekday) {
            calendar.add(5, 1);
        }
        if (dayOrdinal > 1) {
            calendar.add(5, 7 * (dayOrdinal - 1));
        }
    }

    private void SetOrdMonth(Calendar calendar, ClockRelTimespan diff) {
        int month = diff.getMonths();
        int ordMonth = diff.getOrdMonth();
        calendar.add(2, 1);
        while (calendar.get(2) != month) {
            calendar.add(2, 1);
        }
        if (ordMonth > 1) {
            calendar.add(1, ordMonth - 1);
        }
        calendar.set(5, 1);
        calendar.clear(11);
        calendar.clear(12);
        calendar.clear(13);
    }

    private Date GetDate(String dateString, Date baseDate, boolean useGMT) {
        GregorianCalendar calendar = new GregorianCalendar();
        Calendar now = Calendar.getInstance();
        now.setTime(baseDate);
        calendar.set(now.get(1), now.get(2), now.get(5), 0, 0, 0);
        if (useGMT) {
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        ClockToken[] dt = this.GetTokens(dateString, false);
        ParsePosition parsePos = new ParsePosition(0);
        ClockRelTimespan diff = new ClockRelTimespan();
        int hasTime = 0;
        int hasZone = 0;
        int hasDate = 0;
        int hasDay = 0;
        int hasOrdMonth = 0;
        int hasRel = 0;
        while (parsePos.getIndex() < dt.length) {
            if (this.ParseTime(dt, parsePos, calendar)) {
                ++hasTime;
                continue;
            }
            if (this.ParseZone(dt, parsePos, calendar)) {
                ++hasZone;
                continue;
            }
            if (this.ParseIso(dt, parsePos, calendar)) {
                ++hasDate;
                continue;
            }
            if (this.ParseDate(dt, parsePos, calendar)) {
                ++hasDate;
                continue;
            }
            if (this.ParseDay(dt, parsePos, diff)) {
                ++hasDay;
                continue;
            }
            if (this.ParseOrdMonth(dt, parsePos, diff)) {
                ++hasOrdMonth;
                continue;
            }
            if (this.ParseRelSpec(dt, parsePos, diff)) {
                ++hasRel;
                continue;
            }
            if (this.ParseNumber(dt, parsePos, calendar, hasDate > 0 && hasTime > 0 && hasRel == 0)) {
                if (hasDate != 0 && hasTime != 0 && hasRel <= 0) continue;
                ++hasTime;
                continue;
            }
            if (this.ParseTrek(dt, parsePos, calendar)) {
                ++hasDate;
                ++hasTime;
                continue;
            }
            return null;
        }
        if (hasTime > 1 || hasZone > 1 || hasDate > 1 || hasDay > 1 || hasOrdMonth > 1) {
            return null;
        }
        int thisYear = calendar.get(1);
        if (thisYear < 100) {
            if (thisYear >= 69) {
                calendar.set(1, thisYear + 1900);
            } else {
                calendar.set(1, thisYear + 2000);
            }
        }
        if (hasRel > 0) {
            if (hasTime == 0 && hasDate == 0 && hasDay == 0) {
                calendar.setTime(baseDate);
            }
            int seconds_in_day = 86400;
            int seconds = diff.getSeconds();
            boolean negative_seconds = seconds < 0;
            int days = 0;
            if (negative_seconds) {
                seconds *= -1;
            }
            while (seconds >= 86400) {
                seconds -= 86400;
                ++days;
            }
            if (negative_seconds) {
                seconds *= -1;
                days *= -1;
            }
            if (days != 0) {
                calendar.add(5, days);
            }
            if (seconds != 0) {
                calendar.add(13, seconds);
            }
            calendar.add(2, diff.getMonths());
        }
        if (hasDay > 0 && hasDate == 0) {
            this.SetWeekday(calendar, diff);
        }
        if (hasOrdMonth > 0) {
            this.SetOrdMonth(calendar, diff);
        }
        return calendar.getTime();
    }

    private boolean ParseTime(ClockToken[] dt, ParsePosition parsePos, Calendar calendar) {
        ClockToken zone;
        int pos = parsePos.getIndex();
        if (pos + 6 < dt.length && dt[pos].isUNumber() && dt[pos + 1].is(':') && dt[pos + 2].isUNumber() && dt[pos + 3].is(':') && dt[pos + 4].isUNumber() && dt[pos + 5].is('-') && dt[pos + 6].isUNumber() && (zone = this.GetTimeZoneFromRawOffset(-dt[pos + 6].getInt() / 100)) != null) {
            calendar.set(11, dt[pos].getInt());
            calendar.set(12, dt[pos + 2].getInt());
            calendar.set(13, dt[pos + 4].getInt());
            calendar.setTimeZone(zone.getZone());
            parsePos.setIndex(pos + 7);
            return true;
        }
        if (pos + 4 < dt.length && dt[pos].isUNumber() && dt[pos + 1].is(':') && dt[pos + 2].isUNumber() && dt[pos + 3].is(':') && dt[pos + 4].isUNumber()) {
            parsePos.setIndex(pos + 5);
            this.ParseMeridianAndSetHour(dt, parsePos, calendar, dt[pos].getInt());
            calendar.set(12, dt[pos + 2].getInt());
            calendar.set(13, dt[pos + 4].getInt());
            return true;
        }
        if (pos + 4 < dt.length && dt[pos].isUNumber() && dt[pos + 1].is(':') && dt[pos + 2].isUNumber() && dt[pos + 3].is('-') && dt[pos + 4].isUNumber() && (zone = this.GetTimeZoneFromRawOffset(-dt[pos + 4].getInt() / 100)) != null) {
            calendar.set(11, dt[pos].getInt());
            calendar.set(12, dt[pos + 2].getInt());
            calendar.setTimeZone(zone.getZone());
            parsePos.setIndex(pos + 5);
            return true;
        }
        if (pos + 2 < dt.length && dt[pos].isUNumber() && dt[pos + 1].is(':') && dt[pos + 2].isUNumber()) {
            parsePos.setIndex(pos + 3);
            this.ParseMeridianAndSetHour(dt, parsePos, calendar, dt[pos].getInt());
            calendar.set(12, dt[pos + 2].getInt());
            return true;
        }
        if (pos + 1 < dt.length && dt[pos].isUNumber() && dt[pos + 1].is(15)) {
            parsePos.setIndex(pos + 1);
            this.ParseMeridianAndSetHour(dt, parsePos, calendar, dt[pos].getInt());
            return true;
        }
        return false;
    }

    private boolean ParseZone(ClockToken[] dt, ParsePosition parsePos, Calendar calendar) {
        int pos = parsePos.getIndex();
        if (pos + 1 < dt.length && dt[pos].is(12) && dt[pos + 1].is(14)) {
            calendar.setTimeZone(dt[pos].getZone());
            parsePos.setIndex(pos + 2);
            return true;
        }
        if (pos < dt.length && dt[pos].is(12)) {
            calendar.setTimeZone(dt[pos].getZone());
            parsePos.setIndex(pos + 1);
            return true;
        }
        if (pos < dt.length && dt[pos].is(13)) {
            calendar.setTimeZone(dt[pos].getZone());
            parsePos.setIndex(pos + 1);
            return true;
        }
        return false;
    }

    private boolean ParseDay(ClockToken[] dt, ParsePosition parsePos, ClockRelTimespan diff) {
        int pos = parsePos.getIndex();
        if (pos + 2 < dt.length && dt[pos].is('+') && dt[pos + 1].isUNumber() && dt[pos + 2].is(6)) {
            diff.setWeekday(dt[pos + 2].getInt(), dt[pos + 1].getInt());
            parsePos.setIndex(pos + 3);
            return true;
        }
        if (pos + 2 < dt.length && dt[pos].is('-') && dt[pos + 1].isUNumber() && dt[pos + 2].is(6)) {
            diff.setWeekday(dt[pos + 2].getInt(), -dt[pos + 1].getInt());
            parsePos.setIndex(pos + 3);
            return true;
        }
        if (pos + 1 < dt.length && dt[pos].is(16) && dt[pos + 1].is(6)) {
            diff.setWeekday(dt[pos + 1].getInt(), 2);
            parsePos.setIndex(pos + 2);
            return true;
        }
        if (pos + 1 < dt.length && dt[pos].is(6) && dt[pos + 1].is(',')) {
            diff.setWeekday(dt[pos].getInt());
            parsePos.setIndex(pos + 2);
            return true;
        }
        if (pos + 1 < dt.length && dt[pos].isUNumber() && dt[pos + 1].is(6)) {
            diff.setWeekday(dt[pos + 1].getInt(), dt[pos].getInt());
            parsePos.setIndex(pos + 2);
            return true;
        }
        if (pos < dt.length && dt[pos].is(6)) {
            diff.setWeekday(dt[pos].getInt());
            parsePos.setIndex(pos + 1);
            return true;
        }
        return false;
    }

    private boolean ParseDate(ClockToken[] dt, ParsePosition parsePos, Calendar calendar) {
        int pos = parsePos.getIndex();
        if (pos + 4 < dt.length && dt[pos].isUNumber() && dt[pos + 1].is('/') && dt[pos + 2].isUNumber() && dt[pos + 3].is('/') && dt[pos + 4].isUNumber()) {
            calendar.set(5, dt[pos + 2].getInt());
            calendar.set(2, dt[pos].getInt() - 1);
            calendar.set(1, dt[pos + 4].getInt());
            parsePos.setIndex(pos + 5);
            return true;
        }
        if (pos + 4 < dt.length && dt[pos].isUNumber() && dt[pos + 1].is('-') && dt[pos + 2].is(5) && dt[pos + 3].is('-') && dt[pos + 4].isUNumber()) {
            calendar.set(1, dt[pos + 4].getInt());
            calendar.set(2, dt[pos + 2].getInt());
            calendar.set(5, dt[pos].getInt());
            parsePos.setIndex(pos + 5);
            return true;
        }
        if (pos + 4 < dt.length && dt[pos].isUNumber() && dt[pos + 1].is('-') && dt[pos + 2].isUNumber() && dt[pos + 3].is('-') && dt[pos + 4].isUNumber()) {
            calendar.set(1, dt[pos].getInt());
            calendar.set(2, dt[pos + 2].getInt() - 1);
            calendar.set(5, dt[pos + 4].getInt());
            parsePos.setIndex(pos + 5);
            return true;
        }
        if (pos + 3 < dt.length && dt[pos].is(5) && dt[pos + 1].isUNumber() && dt[pos + 2].is(',') && dt[pos + 3].isUNumber()) {
            calendar.set(5, dt[pos + 1].getInt());
            calendar.set(2, dt[pos].getInt());
            calendar.set(1, dt[pos + 3].getInt());
            parsePos.setIndex(pos + 4);
            return true;
        }
        if (pos + 2 < dt.length && dt[pos].isUNumber() && dt[pos + 1].is('/') && dt[pos + 2].isUNumber()) {
            calendar.set(5, dt[pos + 2].getInt());
            calendar.set(2, dt[pos].getInt() - 1);
            parsePos.setIndex(pos + 3);
            return true;
        }
        if (pos + 2 < dt.length && dt[pos].isUNumber() && dt[pos + 1].is(5) && dt[pos + 2].isUNumber()) {
            calendar.set(5, dt[pos].getInt());
            calendar.set(2, dt[pos + 1].getInt());
            calendar.set(1, dt[pos + 2].getInt());
            parsePos.setIndex(pos + 3);
            return true;
        }
        if (pos + 1 < dt.length && dt[pos].is(5) && dt[pos + 1].isUNumber()) {
            calendar.set(5, dt[pos + 1].getInt());
            calendar.set(2, dt[pos].getInt());
            parsePos.setIndex(pos + 2);
            return true;
        }
        if (pos + 1 < dt.length && dt[pos].isUNumber() && dt[pos + 1].is(5)) {
            calendar.set(5, dt[pos].getInt());
            calendar.set(2, dt[pos + 1].getInt());
            parsePos.setIndex(pos + 2);
            return true;
        }
        if (pos < dt.length && dt[pos].isIsoBase()) {
            calendar.set(5, dt[pos].getInt() % 100);
            calendar.set(2, dt[pos].getInt() % 10000 / 100 - 1);
            calendar.set(1, dt[pos].getInt() / 10000);
            parsePos.setIndex(pos + 1);
            return true;
        }
        if (pos < dt.length && dt[pos].is(11)) {
            calendar.set(5, 1);
            calendar.set(2, 0);
            calendar.set(1, 1970);
            parsePos.setIndex(pos + 1);
            return true;
        }
        return false;
    }

    private boolean ParseNumber(ClockToken[] dt, ParsePosition parsePos, Calendar calendar, boolean mayBeYear) {
        int pos = parsePos.getIndex();
        if (pos < dt.length && dt[pos].isUNumber()) {
            parsePos.setIndex(pos + 1);
            if (mayBeYear) {
                calendar.set(1, dt[pos].getInt());
            } else {
                calendar.set(11, dt[pos].getInt() / 100);
                calendar.set(12, dt[pos].getInt() % 100);
                calendar.set(13, 0);
            }
            return true;
        }
        return false;
    }

    private boolean ParseRelSpec(ClockToken[] dt, ParsePosition parsePos, ClockRelTimespan diff) {
        if (!this.ParseRelUnits(dt, parsePos, diff)) {
            return false;
        }
        int pos = parsePos.getIndex();
        if (pos < dt.length && dt[pos].is(10)) {
            diff.negate();
            parsePos.setIndex(pos + 1);
        }
        return true;
    }

    private boolean ParseRelUnits(ClockToken[] dt, ParsePosition parsePos, ClockRelTimespan diff) {
        int pos = parsePos.getIndex();
        if (pos + 2 < dt.length && dt[pos].is('+') && dt[pos + 1].isUNumber() && dt[pos + 2].isUnit()) {
            diff.addUnit(dt[pos + 2], dt[pos + 1].getInt());
            parsePos.setIndex(pos + 3);
            return true;
        }
        if (pos + 2 < dt.length && dt[pos].is('-') && dt[pos + 1].isUNumber() && dt[pos + 2].isUnit()) {
            diff.addUnit(dt[pos + 2], -dt[pos + 1].getInt());
            parsePos.setIndex(pos + 3);
            return true;
        }
        if (pos + 1 < dt.length && dt[pos].isUNumber() && dt[pos + 1].isUnit()) {
            diff.addUnit(dt[pos + 1], dt[pos].getInt());
            parsePos.setIndex(pos + 2);
            return true;
        }
        if (pos + 2 < dt.length && dt[pos].is(16) && dt[pos + 1].isUNumber() && dt[pos + 2].isUnit()) {
            diff.addUnit(dt[pos + 2], dt[pos + 1].getInt());
            parsePos.setIndex(pos + 3);
            return true;
        }
        if (pos + 1 < dt.length && dt[pos].is(16) && dt[pos + 1].isUnit()) {
            diff.addUnit(dt[pos + 1]);
            parsePos.setIndex(pos + 2);
            return true;
        }
        if (pos < dt.length && dt[pos].isUnit()) {
            diff.addUnit(dt[pos]);
            parsePos.setIndex(pos + 1);
            return true;
        }
        return false;
    }

    private boolean ParseOrdMonth(ClockToken[] dt, ParsePosition parsePos, ClockRelTimespan diff) {
        int pos = parsePos.getIndex();
        if (pos + 2 < dt.length && dt[pos].is(16) && dt[pos + 1].isUNumber() && dt[pos + 2].is(5)) {
            diff.addOrdMonth(dt[pos + 2].getInt(), dt[pos + 1].getInt());
            parsePos.setIndex(pos + 3);
            return true;
        }
        if (pos + 1 < dt.length && dt[pos].is(16) && dt[pos + 1].is(5)) {
            diff.addOrdMonth(dt[pos + 1].getInt(), 1);
            parsePos.setIndex(pos + 2);
            return true;
        }
        return false;
    }

    private boolean ParseIso(ClockToken[] dt, ParsePosition parsePos, Calendar calendar) {
        int pos = parsePos.getIndex();
        if (pos + 6 < dt.length && dt[pos].isIsoBase() && dt[pos + 1].is(12) && dt[pos + 2].isUNumber() && dt[pos + 3].is(':') && dt[pos + 4].isUNumber() && dt[pos + 5].is(':') && dt[pos + 6].isUNumber()) {
            calendar.set(5, dt[pos].getInt() % 100);
            calendar.set(2, dt[pos].getInt() % 10000 / 100 - 1);
            calendar.set(1, dt[pos].getInt() / 10000);
            calendar.set(11, dt[pos + 2].getInt());
            calendar.set(12, dt[pos + 4].getInt());
            calendar.set(13, dt[pos + 6].getInt());
            parsePos.setIndex(pos + 7);
            return true;
        }
        if (pos + 2 < dt.length && dt[pos].isIsoBase() && dt[pos + 1].is(12) && dt[pos + 1].getZone().getRawOffset() == -25200000 && dt[pos + 2].isIsoBase()) {
            calendar.set(5, dt[pos].getInt() % 100);
            calendar.set(2, dt[pos].getInt() % 10000 / 100 - 1);
            calendar.set(1, dt[pos].getInt() / 10000);
            calendar.set(11, dt[pos + 2].getInt() / 10000);
            calendar.set(12, dt[pos + 2].getInt() % 10000 / 100);
            calendar.set(13, dt[pos + 2].getInt() % 100);
            parsePos.setIndex(pos + 3);
            return true;
        }
        if (pos + 1 < dt.length && dt[pos].isIsoBase() && dt[pos + 1].isIsoBase()) {
            calendar.set(5, dt[pos].getInt() % 100);
            calendar.set(2, dt[pos].getInt() % 10000 / 100 - 1);
            calendar.set(1, dt[pos].getInt() / 10000);
            calendar.set(11, dt[pos + 1].getInt() / 10000);
            calendar.set(12, dt[pos + 1].getInt() % 10000 / 100);
            calendar.set(13, dt[pos + 1].getInt() % 100);
            parsePos.setIndex(pos + 2);
            return true;
        }
        return false;
    }

    private boolean ParseTrek(ClockToken[] dt, ParsePosition parsePos, GregorianCalendar calendar) {
        int pos = parsePos.getIndex();
        if (pos + 3 < dt.length && dt[pos].is(17) && dt[pos + 1].isUNumber() && dt[pos + 2].is('.') && dt[pos + 3].isUNumber()) {
            int trekYear = dt[pos + 1].getInt() / 1000 + 2323 - 377;
            int trekDay = 1 + dt[pos + 1].getInt() % 1000 * (calendar.isLeapYear(trekYear) ? 366 : 365) / 1000;
            int trekSeconds = dt[pos + 3].getInt() * 144 * 60;
            calendar.set(1, trekYear);
            calendar.set(6, trekDay);
            calendar.set(13, trekSeconds);
            parsePos.setIndex(pos + 4);
            return true;
        }
        return false;
    }

    private void ParseMeridianAndSetHour(ClockToken[] dt, ParsePosition parsePos, Calendar calendar, int hour) {
        int hourField;
        int pos = parsePos.getIndex();
        if (pos < dt.length && dt[pos].is(15)) {
            calendar.set(9, dt[pos].getInt());
            parsePos.setIndex(pos + 1);
            hourField = 10;
        } else {
            hourField = 11;
        }
        if (hourField == 10 && hour == 12) {
            hour = 0;
        }
        calendar.set(hourField, hour);
    }

    private ClockToken[] GetTokens(String in, boolean debug) {
        ClockToken dt;
        ParsePosition parsePos = new ParsePosition(0);
        Vector<ClockToken> tokenVector = new Vector<ClockToken>(in.length());
        while ((dt = this.GetNextToken(in, parsePos)) != null) {
            tokenVector.addElement(dt);
        }
        Object[] tokenArray = new ClockToken[tokenVector.size()];
        tokenVector.copyInto(tokenArray);
        if (debug) {
            for (int ix = 0; ix < tokenArray.length; ++ix) {
                if (ix != 0) {
                    System.err.print(",");
                }
                System.err.print(((ClockToken)tokenArray[ix]).toString());
            }
            System.err.println("");
        }
        return tokenArray;
    }

    private ClockToken GetNextToken(String in, ParsePosition parsePos) {
        int pos;
        for (pos = parsePos.getIndex(); pos < in.length() && Character.isSpaceChar(in.charAt(pos)); ++pos) {
        }
        if (pos < in.length()) {
            char c = in.charAt(pos);
            if (Character.isDigit(c)) {
                int number = 0;
                int count = 0;
                while (pos < in.length() && Character.isDigit(c = in.charAt(pos))) {
                    number = 10 * number + c - 48;
                    ++pos;
                    ++count;
                }
                parsePos.setIndex(pos);
                return new ClockToken(number, count >= 6);
            }
            if (Character.isLetter(c)) {
                int beginPos = pos;
                while (++pos < in.length() && (Character.isLetter(c = in.charAt(pos)) || c == '.')) {
                }
                parsePos.setIndex(pos);
                return this.LookupWord(in.substring(beginPos, pos));
            }
            parsePos.setIndex(pos + 1);
            return new ClockToken(in.charAt(pos));
        }
        parsePos.setIndex(pos + 1);
        return null;
    }

    private ClockToken LookupWord(String word) {
        int ix;
        boolean abbrev;
        if (word.equalsIgnoreCase("am") || word.equalsIgnoreCase("a.m.")) {
            return new ClockToken(15, 0);
        }
        if (word.equalsIgnoreCase("pm") || word.equalsIgnoreCase("p.m.")) {
            return new ClockToken(15, 1);
        }
        if (word.length() == 3) {
            abbrev = true;
        } else if (word.length() == 4 && word.charAt(3) == '.') {
            abbrev = true;
            word = word.substring(0, 3);
        } else {
            abbrev = false;
        }
        DateFormatSymbols symbols = new DateFormatSymbols(Locale.US);
        String[] names = abbrev ? symbols.getShortMonths() : symbols.getMonths();
        for (ix = 0; ix < names.length; ++ix) {
            if (!word.equalsIgnoreCase(names[ix])) continue;
            return new ClockToken(5, ix);
        }
        names = abbrev ? symbols.getShortWeekdays() : symbols.getWeekdays();
        for (ix = 0; ix < names.length; ++ix) {
            if (!word.equalsIgnoreCase(names[ix])) continue;
            return new ClockToken(6, ix);
        }
        StringBuffer withoutDotsBuf = new StringBuffer(word.length());
        for (ix = 0; ix < word.length(); ++ix) {
            if (word.charAt(ix) == '.') continue;
            withoutDotsBuf.append(word.charAt(ix));
        }
        String withoutDots = new String(withoutDotsBuf);
        String[][] zones = symbols.getZoneStrings();
        for (ix = 0; ix < zones.length; ++ix) {
            if (!withoutDots.equalsIgnoreCase(zones[ix][2]) && !withoutDots.equalsIgnoreCase(zones[ix][4])) continue;
            TimeZone zone = TimeZone.getTimeZone(zones[ix][0]);
            return new ClockToken(12, zone);
        }
        if (withoutDots.equalsIgnoreCase("dst")) {
            return new ClockToken(14, null);
        }
        String singular = word.endsWith("s") ? word.substring(0, word.length() - 1) : word;
        if (singular.equalsIgnoreCase("year")) {
            return new ClockToken(7, 12);
        }
        if (singular.equalsIgnoreCase("month")) {
            return new ClockToken(7, 1);
        }
        if (singular.equalsIgnoreCase("fortnight")) {
            return new ClockToken(8, 20160);
        }
        if (singular.equalsIgnoreCase("week")) {
            return new ClockToken(8, 10080);
        }
        if (singular.equalsIgnoreCase("day")) {
            return new ClockToken(8, 1440);
        }
        if (singular.equalsIgnoreCase("hour")) {
            return new ClockToken(8, 60);
        }
        if (singular.equalsIgnoreCase("minute")) {
            return new ClockToken(8, 1);
        }
        if (singular.equalsIgnoreCase("min")) {
            return new ClockToken(8, 1);
        }
        if (singular.equalsIgnoreCase("second")) {
            return new ClockToken(9, 1);
        }
        if (singular.equalsIgnoreCase("sec")) {
            return new ClockToken(9, 1);
        }
        if (singular.equalsIgnoreCase("tomorrow")) {
            return new ClockToken(8, 1440);
        }
        if (singular.equalsIgnoreCase("yesterday")) {
            return new ClockToken(8, -1440);
        }
        if (singular.equalsIgnoreCase("today")) {
            return new ClockToken(8, 0);
        }
        if (singular.equalsIgnoreCase("now")) {
            return new ClockToken(8, 0);
        }
        if (singular.equalsIgnoreCase("last")) {
            return new ClockToken(-1, false);
        }
        if (singular.equalsIgnoreCase("this")) {
            return new ClockToken(8, 0);
        }
        if (singular.equalsIgnoreCase("next")) {
            return new ClockToken(16, 1);
        }
        if (singular.equalsIgnoreCase("ago")) {
            return new ClockToken(10, 1);
        }
        if (singular.equalsIgnoreCase("epoch")) {
            return new ClockToken(11, 0);
        }
        if (singular.equalsIgnoreCase("stardate")) {
            return new ClockToken(17, 0);
        }
        if (withoutDots.length() == 1) {
            ClockToken zone;
            int rawOffset = 0;
            boolean found = true;
            char milTz = Character.toLowerCase(withoutDots.charAt(0));
            if (milTz >= 'a' && milTz <= 'm') {
                rawOffset = milTz - 97 + 1;
            } else if (milTz >= 'n' && milTz < 'z') {
                rawOffset = 110 - milTz - 1;
            } else if (milTz != 'z') {
                found = false;
            }
            if (found && (zone = this.GetTimeZoneFromRawOffset(rawOffset)) != null) {
                return zone;
            }
        }
        return new ClockToken(word);
    }

    private ClockToken GetTimeZoneFromRawOffset(int rawOffset) {
        String[] tzNames = TimeZone.getAvailableIDs(rawOffset * 3600000);
        if (tzNames.length > 0) {
            TimeZone zone = TimeZone.getTimeZone(tzNames[0]);
            return new ClockToken(12, zone);
        }
        return null;
    }
}

