/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Util;

class LreplaceCmd
implements Command {
    LreplaceCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 4) {
            throw new TclNumArgsException(interp, 1, argv, "list first last ?element element ...?");
        }
        int size = TclList.getLength(interp, argv[1]);
        int first = Util.getIntForIndex(interp, argv[2], size - 1);
        int last = Util.getIntForIndex(interp, argv[3], size - 1);
        if (first < 0) {
            first = 0;
        }
        if (first >= size && size > 0) {
            throw new TclException(interp, "list doesn't contain element " + argv[2]);
        }
        if (last >= size) {
            last = size - 1;
        }
        int numToDelete = first <= last ? last - first + 1 : 0;
        TclObject list = argv[1];
        boolean isDuplicate = false;
        if (list.isShared()) {
            list = list.duplicate();
            isDuplicate = true;
        }
        try {
            TclList.replace(interp, list, first, numToDelete, argv, 4, argv.length - 1);
            interp.setResult(list);
        }
        catch (TclException e) {
            if (isDuplicate) {
                list.release();
            }
            throw e;
        }
    }
}

