/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import java.util.Hashtable;
import tcl.lang.Channel;
import tcl.lang.Interp;
import tcl.lang.StdChannel;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

class TclIO {
    static final int READ_ALL = 1;
    static final int READ_LINE = 2;
    static final int READ_N_BYTES = 3;
    static final int SEEK_SET = 1;
    static final int SEEK_CUR = 2;
    static final int SEEK_END = 3;
    static final int RDONLY = 1;
    static final int WRONLY = 2;
    static final int RDWR = 4;
    static final int APPEND = 8;
    static final int CREAT = 16;
    static final int EXCL = 32;
    static final int TRUNC = 64;
    static final int BUFF_FULL = 0;
    static final int BUFF_LINE = 1;
    static final int BUFF_NONE = 2;
    static final int TRANS_AUTO = 0;
    static final int TRANS_BINARY = 1;
    static final int TRANS_LF = 2;
    static final int TRANS_CR = 3;
    static final int TRANS_CRLF = 4;
    static int TRANS_PLATFORM = Util.isWindows() ? 4 : (Util.isMac() ? 3 : 2);
    private static StdChannel stdinChan = null;
    private static StdChannel stdoutChan = null;
    private static StdChannel stderrChan = null;

    TclIO() {
    }

    static Channel getChannel(Interp interp, String chanName) {
        return (Channel)TclIO.getInterpChanTable(interp).get(chanName);
    }

    static void registerChannel(Interp interp, Channel chan) {
        if (interp != null) {
            Hashtable chanTable = TclIO.getInterpChanTable(interp);
            chanTable.put(chan.getChanName(), chan);
            ++chan.refCount;
        }
    }

    static void unregisterChannel(Interp interp, Channel chan) {
        Hashtable chanTable = TclIO.getInterpChanTable(interp);
        chanTable.remove(chan.getChanName());
        if (--chan.refCount <= 0) {
            try {
                chan.close();
            }
            catch (IOException e) {
                throw new TclRuntimeError("TclIO.unregisterChannel() Error: IOException when closing " + chan.getChanName() + ": " + e.getMessage());
            }
        }
    }

    static Hashtable getInterpChanTable(Interp interp) {
        if (interp.interpChanTable == null) {
            interp.interpChanTable = new Hashtable();
            Channel chan = TclIO.getStdChannel(0);
            TclIO.registerChannel(interp, chan);
            chan = TclIO.getStdChannel(1);
            TclIO.registerChannel(interp, chan);
            chan = TclIO.getStdChannel(2);
            TclIO.registerChannel(interp, chan);
        }
        return interp.interpChanTable;
    }

    static Channel getStdChannel(int type) {
        StdChannel chan = null;
        switch (type) {
            case 0: {
                if (stdinChan == null) {
                    stdinChan = new StdChannel(0);
                }
                chan = stdinChan;
                break;
            }
            case 1: {
                if (stdoutChan == null) {
                    stdoutChan = new StdChannel(1);
                }
                chan = stdoutChan;
                break;
            }
            case 2: {
                if (stderrChan == null) {
                    stderrChan = new StdChannel(2);
                }
                chan = stderrChan;
                break;
            }
            default: {
                throw new TclRuntimeError("Invalid type for StdChannel");
            }
        }
        return chan;
    }

    static String getNextDescriptor(Interp interp, String prefix) {
        Hashtable htbl = TclIO.getInterpChanTable(interp);
        int i = prefix.equals("file") ? 3 : 0;
        while (htbl.get(prefix + i) != null) {
            ++i;
        }
        return prefix + i;
    }

    static String getTranslationString(int translation) {
        switch (translation) {
            case 0: {
                return "auto";
            }
            case 3: {
                return "cr";
            }
            case 4: {
                return "crlf";
            }
            case 2: {
                return "lf";
            }
            case 1: {
                return "lf";
            }
        }
        throw new TclRuntimeError("bad translation id");
    }

    static int getTranslationID(String translation) {
        if (translation.equals("auto")) {
            return 0;
        }
        if (translation.equals("cr")) {
            return 3;
        }
        if (translation.equals("crlf")) {
            return 4;
        }
        if (translation.equals("lf")) {
            return 2;
        }
        if (translation.equals("binary")) {
            return 2;
        }
        if (translation.equals("platform")) {
            return TRANS_PLATFORM;
        }
        return -1;
    }

    static String getBufferingString(int buffering) {
        switch (buffering) {
            case 0: {
                return "full";
            }
            case 1: {
                return "line";
            }
            case 2: {
                return "none";
            }
        }
        throw new TclRuntimeError("bad buffering id");
    }

    static int getBufferingID(String buffering) {
        if (buffering.equals("full")) {
            return 0;
        }
        if (buffering.equals("line")) {
            return 1;
        }
        if (buffering.equals("none")) {
            return 2;
        }
        return -1;
    }
}

