/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.ceciliaModule;

import blue.BlueSystem;
import blue.soundObject.ceciliaModule.ModuleDefinition;
import blue.ui.utilities.FileChooserManager;
import blue.utility.TextUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javafx.stage.FileChooser;

public class CeciliaModuleImportDialog {
    private static final String FILE_IMPORT = "ceciliaModuleImportDialog";
    private static final FileChooser.ExtensionFilter fileFilter = new FileChooser.ExtensionFilter("blue Cecilia Module (*.bcm)", new String[]{"*.bcm"});

    private CeciliaModuleImportDialog() {
    }

    public static ModuleDefinition importCeciliaModule() {
        List retVal = FileChooserManager.getDefault().showOpenDialog((Object)FILE_IMPORT, null);
        if (retVal.isEmpty()) {
            return null;
        }
        File temp = (File)retVal.get(0);
        return CeciliaModuleImportDialog.convertCeciliaModule(temp);
    }

    public static ModuleDefinition convertCeciliaModule(File ceciliaFile) {
        String moduleText;
        try {
            moduleText = TextUtilities.getTextFromFile((File)ceciliaFile);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        ModuleDefinition moduleDefinition = new ModuleDefinition();
        moduleDefinition.info = TextUtilities.getTextBetweenTags((String)"info", (String)moduleText);
        moduleDefinition.tk_interface = TextUtilities.getTextBetweenTags((String)"tk_interface", (String)moduleText);
        moduleDefinition.mono = TextUtilities.getTextBetweenTags((String)"mono", (String)moduleText);
        moduleDefinition.stereo = TextUtilities.getTextBetweenTags((String)"stereo", (String)moduleText);
        moduleDefinition.quad = TextUtilities.getTextBetweenTags((String)"quad", (String)moduleText);
        moduleDefinition.score = TextUtilities.getTextBetweenTags((String)"score", (String)moduleText);
        return moduleDefinition;
    }

    static {
        FileChooserManager.getDefault().setDialogTitle((Object)FILE_IMPORT, BlueSystem.getString((String)"ceciliaModule.openFileTitle"));
        String libFolder = BlueSystem.getLibDir() + File.separator + "ceciliaModule/";
        FileChooserManager.getDefault().setSelectedFile((Object)FILE_IMPORT, new File(libFolder));
        FileChooserManager.getDefault().addFilter((Object)FILE_IMPORT, fileFilter);
    }
}

