/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.ceciliaModule;

import blue.soundObject.CeciliaModule;
import blue.soundObject.ceciliaModule.CToggle;
import blue.soundObject.ceciliaModule.CeciliaObject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import pnuts.awt.PnutsLayout;

public class TogglePanel
extends JComponent
implements ActionListener {
    private HashMap interfaceObjectMap = new HashMap();
    private HashMap dataValues = new HashMap();

    public TogglePanel() {
        this.setLayout(new PnutsLayout("cols=1,valign=top, halign=left"));
    }

    public void clearToggles() {
        this.removeAll();
        this.interfaceObjectMap.clear();
        this.dataValues.clear();
    }

    public void addToggle(String name) {
        JCheckBox toggle = new JCheckBox(name);
        toggle.setActionCommand(name);
        toggle.addActionListener(this);
        this.add(toggle);
        this.interfaceObjectMap.put(name, toggle);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        System.err.println(e.getActionCommand());
        JCheckBox checkBox = (JCheckBox)e.getSource();
        CToggle toggle = (CToggle)this.dataValues.get(e.getActionCommand());
        toggle.setToggled(checkBox.isSelected());
    }

    public void editCeciliaModule(CeciliaModule ceciliaModule) {
        HashMap map = ceciliaModule.getStateData();
        if (map.size() == 0) {
            return;
        }
        for (CeciliaObject element : map.values()) {
            if (!(element instanceof CToggle)) continue;
            CToggle toggle = (CToggle)element;
            JCheckBox checkBox = (JCheckBox)this.interfaceObjectMap.get(toggle.getObjectName());
            checkBox.setText(toggle.getLabel());
            checkBox.setSelected(toggle.isToggled());
            this.dataValues.put(toggle.getObjectName(), toggle);
        }
    }
}

