/*
 * Decompiled with CFR 0.152.
 */
package blue.midi;

import blue.midi.BlueMidiDevice;
import blue.midi.MidiInputManager;
import java.util.Vector;
import javax.sound.midi.MidiUnavailableException;
import javax.swing.table.AbstractTableModel;
import org.openide.util.Exceptions;

public class MidiInputTableModel
extends AbstractTableModel {
    private final Vector<BlueMidiDevice> devices = MidiInputManager.getInstance().getInputDeviceOptions();

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Enabled";
            }
            case 1: {
                return "Device Name";
            }
            case 2: {
                return "Description";
            }
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.devices.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        BlueMidiDevice device = this.devices.get(row);
        switch (column) {
            case 0: {
                return device.isEnabled();
            }
            case 1: {
                return device.toString();
            }
            case 2: {
                return device.getDeviceInfo().getDescription();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (column == 0) {
            BlueMidiDevice device = this.devices.get(row);
            boolean enabled = (Boolean)aValue;
            device.setEnabled(enabled);
            if (MidiInputManager.getInstance().isRunning()) {
                if (enabled) {
                    try {
                        device.open();
                    }
                    catch (MidiUnavailableException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    device.close();
                }
            }
            MidiInputManager.getInstance().save();
            this.fireTableCellUpdated(row, column);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 0 ? Boolean.class : String.class;
    }
}

